/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.BorderUIResource;
import org.asyrinx.brownie.core.util.DateUtils;
import org.asyrinx.brownie.swing.AbsoluteConstraints;
import org.asyrinx.brownie.swing.AbsoluteLayout;

public final class DatePicker
extends JPanel {
    private static final Font smallFont = new Font("Dialog", 0, 10);
    private static final Font largeFont = new Font("Dialog", 0, 12);
    private static final Color highlight = new Color(255, 255, 204);
    private static final Color white = new Color(255, 255, 255);
    private static final Color gray = new Color(204, 204, 204);
    private Component selectedDay = null;
    private GregorianCalendar selectedDate = null;
    private GregorianCalendar originalDate = null;
    private boolean hideOnSelect = true;
    private final JButton yearBackButton = new JButton();
    private final JButton monthBackButton = new JButton();
    private final JLabel monthAndYear = new JLabel();
    private final JButton monthForwardButton = new JButton();
    private final JButton yearForwardButton = new JButton();
    private final JTextField selectedTimeField = new JTextField();
    private final JTextField[] dayHeadings = new JTextField[]{new JTextField("S"), new JTextField("M"), new JTextField("T"), new JTextField("W"), new JTextField("T"), new JTextField("F"), new JTextField("S")};
    private final JTextField[][] daysInMonth = this.initDayTextFields();
    private final JButton todayButton = new JButton();
    private final JButton cancelButton = new JButton();
    private DateFormat titleDateFormat = new SimpleDateFormat("yyyy/MM");
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    private JTextField[][] initDayTextFields() {
        JTextField[][] result = new JTextField[6][7];
        int w = 0;
        while (w < result.length) {
            int d = 0;
            while (d < result[w].length) {
                result[w][d] = new JTextField();
                ++d;
            }
            ++w;
        }
        return result;
    }

    public DatePicker() {
        this.selectedDate = DatePicker.getToday();
        this.initialize();
    }

    public DatePicker(Date initialDate) {
        if (initialDate == null) {
            this.selectedDate = DatePicker.getToday();
        } else {
            this.selectedDate = new GregorianCalendar();
            this.selectedDate.setTime(initialDate);
        }
        this.originalDate = new GregorianCalendar(this.selectedDate.get(1), this.selectedDate.get(2), this.selectedDate.get(5));
        this.initialize();
    }

    private void initialize() {
        Insets insets = new Insets(2, 2, 2, 2);
        this.setLayout(new AbsoluteLayout());
        this.setMinimumSize(new Dimension(210, 240));
        this.setMaximumSize(this.getMinimumSize());
        this.setPreferredSize(this.getMinimumSize());
        this.setBorder(new BorderUIResource.EtchedBorderUIResource());
        this.yearBackButton.setFont(smallFont);
        this.yearBackButton.setText("<<");
        this.yearBackButton.setMargin(insets);
        this.yearBackButton.setDefaultCapable(false);
        this.yearBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onYearBackClicked(evt);
            }
        });
        this.add((Component)this.yearBackButton, new AbsoluteConstraints(10, 10, 30, 20));
        this.monthBackButton.setFont(smallFont);
        this.monthBackButton.setText("<");
        this.monthBackButton.setMargin(insets);
        this.monthBackButton.setDefaultCapable(false);
        this.monthBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onMonthBackClicked(evt);
            }
        });
        this.add((Component)this.monthBackButton, new AbsoluteConstraints(40, 10, 20, 20));
        this.monthAndYear.setFont(largeFont);
        this.monthAndYear.setHorizontalAlignment(0);
        this.monthAndYear.setText(this.titleDateFormat.format(this.selectedDate.getTime()));
        this.add((Component)this.monthAndYear, new AbsoluteConstraints(50, 10, 100, 20));
        this.monthForwardButton.setFont(smallFont);
        this.monthForwardButton.setText(">");
        this.monthForwardButton.setMargin(insets);
        this.monthForwardButton.setDefaultCapable(false);
        this.monthForwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onMonthForwardClicked(evt);
            }
        });
        this.add((Component)this.monthForwardButton, new AbsoluteConstraints(150, 10, 20, 20));
        this.yearForwardButton.setFont(smallFont);
        this.yearForwardButton.setText(">>");
        this.yearForwardButton.setMargin(insets);
        this.yearForwardButton.setDefaultCapable(false);
        this.yearForwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onYearForwardClicked(evt);
            }
        });
        this.add((Component)this.yearForwardButton, new AbsoluteConstraints(170, 10, 30, 20));
        int startX = 35;
        int startY = 60;
        int x = 35;
        int ii = 0;
        while (ii < this.dayHeadings.length) {
            this.dayHeadings[ii].setBackground(gray);
            this.dayHeadings[ii].setEditable(false);
            this.dayHeadings[ii].setFont(smallFont);
            this.dayHeadings[ii].setHorizontalAlignment(0);
            this.dayHeadings[ii].setFocusable(false);
            this.add((Component)this.dayHeadings[ii], new AbsoluteConstraints(x, 40, 21, 21));
            x += 20;
            ++ii;
        }
        x = 35;
        int y = 60;
        int ii2 = 0;
        while (ii2 < this.daysInMonth.length) {
            int jj = 0;
            while (jj < this.daysInMonth[ii2].length) {
                this.daysInMonth[ii2][jj].setBackground(gray);
                this.daysInMonth[ii2][jj].setEditable(false);
                this.daysInMonth[ii2][jj].setFont(smallFont);
                this.daysInMonth[ii2][jj].setHorizontalAlignment(4);
                this.daysInMonth[ii2][jj].setText("");
                this.daysInMonth[ii2][jj].setFocusable(false);
                this.daysInMonth[ii2][jj].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        DatePicker.this.onDayClicked(e);
                    }
                });
                this.add((Component)this.daysInMonth[ii2][jj], new AbsoluteConstraints(x, y, 21, 21));
                x += 20;
                ++jj;
            }
            x = 35;
            y += 20;
            ++ii2;
        }
        this.selectedTimeField.setHorizontalAlignment(0);
        this.selectedTimeField.setText(this.timeFormat.format(this.selectedDate.getTime()));
        this.add((Component)this.selectedTimeField, new AbsoluteConstraints(60, 186, 100, 20));
        this.initButtons(true);
        this.calculateCalendar();
        this.setSize(300, 229);
    }

    private void initButtons(boolean firstTime) {
        int posY = 210;
        if (firstTime) {
            Insets insets = new Insets(2, 2, 2, 2);
            Dimension buttonSize = new Dimension(68, 24);
            this.todayButton.setFont(largeFont);
            this.todayButton.setText("Today");
            this.todayButton.setMargin(insets);
            this.todayButton.setMaximumSize(buttonSize);
            this.todayButton.setMinimumSize(buttonSize);
            this.todayButton.setPreferredSize(buttonSize);
            this.todayButton.setDefaultCapable(true);
            this.todayButton.setSelected(true);
            this.todayButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DatePicker.this.onToday(evt);
                }
            });
            this.cancelButton.setFont(largeFont);
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMargin(insets);
            this.cancelButton.setMaximumSize(buttonSize);
            this.cancelButton.setMinimumSize(buttonSize);
            this.cancelButton.setPreferredSize(buttonSize);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DatePicker.this.onCancel(evt);
                }
            });
        } else {
            this.remove(this.todayButton);
            this.remove(this.cancelButton);
        }
        if (this.hideOnSelect) {
            this.add((Component)this.todayButton, new AbsoluteConstraints(50, 210, 52, -1));
            this.add((Component)this.cancelButton, new AbsoluteConstraints(112, 210, 52, -1));
        } else {
            this.add((Component)this.todayButton, new AbsoluteConstraints(70, 210, 52, -1));
        }
    }

    public boolean isHideOnSelect() {
        return this.hideOnSelect;
    }

    public void setHideOnSelect(boolean hideOnSelect) {
        if (this.hideOnSelect != hideOnSelect) {
            this.hideOnSelect = hideOnSelect;
            this.initButtons(false);
        }
    }

    public Date getDate() {
        if (this.selectedDate != null) {
            return this.selectedDate.getTime();
        }
        return null;
    }

    protected void onToday(ActionEvent evt) {
        this.selectedDate = DatePicker.getToday();
        this.setVisible(!this.hideOnSelect);
        if (this.isVisible()) {
            this.monthAndYear.setText(this.titleDateFormat.format(this.selectedDate.getTime()));
            this.calculateCalendar();
        }
    }

    protected void onCancel(ActionEvent evt) {
        this.selectedDate = this.originalDate;
        this.setVisible(!this.hideOnSelect);
    }

    private void moveMonth(int diff) {
        int day = this.selectedDate.get(5);
        this.selectedDate.set(5, 1);
        this.selectedDate.add(2, diff);
        this.selectedDate.set(5, Math.min(day, DatePicker.calculateDaysInMonth(this.selectedDate)));
        this.monthAndYear.setText(this.titleDateFormat.format(this.selectedDate.getTime()));
        this.calculateCalendar();
    }

    protected void onMonthForwardClicked(ActionEvent evt) {
        this.moveMonth(1);
    }

    protected void onMonthBackClicked(ActionEvent evt) {
        this.moveMonth(-1);
    }

    protected void onYearForwardClicked(ActionEvent evt) {
        this.moveMonth(12);
    }

    protected void onYearBackClicked(ActionEvent evt) {
        this.moveMonth(-12);
    }

    protected void onDayClicked(MouseEvent evt) {
        JTextField fld = (JTextField)evt.getSource();
        if (!"".equals(fld.getText())) {
            if (this.selectedDay != null) {
                this.selectedDay.setBackground(white);
            }
            fld.setBackground(highlight);
            this.selectedDay = fld;
            this.selectedDate.set(5, Integer.parseInt(fld.getText()));
            this.setVisible(!this.hideOnSelect);
        }
    }

    private static GregorianCalendar getToday() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    private void calculateCalendar() {
        int week;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(white);
            this.selectedDay = null;
        }
        GregorianCalendar c = new GregorianCalendar(this.selectedDate.get(1), this.selectedDate.get(2), 1);
        int maxDay = DatePicker.calculateDaysInMonth(c);
        int selectedDayValue = Math.min(maxDay, this.selectedDate.get(5));
        int dow = c.get(7);
        int dd = 0;
        while (dd < dow) {
            this.daysInMonth[0][dd].setText("");
            this.daysInMonth[0][dd].setBackground(gray);
            ++dd;
        }
        do {
            week = c.get(4);
            dow = c.get(7);
            JTextField fld = this.daysInMonth[week - 1][dow - 1];
            fld.setText(Integer.toString(c.get(5)));
            if (selectedDayValue == c.get(5)) {
                fld.setBackground(highlight);
                this.selectedDay = fld;
            } else {
                fld.setBackground(white);
            }
            if (c.get(5) >= maxDay) break;
            c.add(5, 1);
        } while (c.get(5) <= maxDay);
        int ww = --week;
        while (ww < this.daysInMonth.length) {
            int dd2 = dow;
            while (dd2 < this.daysInMonth[ww].length) {
                this.daysInMonth[ww][dd2].setText("");
                this.daysInMonth[ww][dd2].setBackground(gray);
                ++dd2;
            }
            dow = 0;
            ++ww;
        }
        c.set(5, selectedDayValue);
        this.selectedDate = c;
    }

    private static int calculateDaysInMonth(Calendar c) {
        return DateUtils.getLastDayOfMonth(c.get(1), c.get(2) + 1);
    }

    public DateFormat getTitleDateFormat() {
        return this.titleDateFormat;
    }

    public void setTitleDateFormat(DateFormat titleDateFormat) {
        this.titleDateFormat = titleDateFormat;
    }
}

