/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogCallableStatement;
import org.asyrinx.brownie.jdbc.logger.LogPreparedStatement;
import org.asyrinx.brownie.jdbc.logger.LogStatement;
import org.asyrinx.brownie.jdbc.wrapper.ConnectionWrapper;

public class LogConnection
extends ConnectionWrapper {
    private final CascadeNamedLog log;

    public LogConnection(Connection wrapped) {
        this(wrapped, wrapped.getClass().getName());
    }

    public LogConnection(Connection wrapped, String loggerName) {
        this(wrapped, loggerName, "debug");
    }

    public LogConnection(Connection wrapped, String loggerName, String logLevel) {
        this(wrapped, new CascadeNamedLog(loggerName, logLevel));
    }

    public LogConnection(Connection wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(this.wrapped);
    }

    public Statement createStatement() throws SQLException {
        return new LogStatement(super.createStatement(), this.log);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement result = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new LogStatement(result, this.log.subLog(result));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement result = super.createStatement(resultSetType, resultSetConcurrency);
        return new LogStatement(result, this.log.subLog(result));
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String result = super.nativeSQL(sql);
            this.log.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log.log((Object)sql, e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement result = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new LogCallableStatement(result, sql, this.log.subLog(result));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement result = super.prepareCall(sql, resultSetType, resultSetConcurrency);
        return new LogCallableStatement(result, sql, this.log.subLog(result));
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement result = super.prepareCall(sql);
        return new LogCallableStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql, autoGeneratedKeys);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql, columnIndexes);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql, columnNames);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql);
        return new LogPreparedStatement(result, sql, this.log.subLog(result));
    }

    public void commit() throws SQLException {
        try {
            super.commit();
            this.log.log("commit()");
        }
        catch (SQLException e) {
            this.log.error("failed to commit()", e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        try {
            super.rollback();
            this.log.log("rollback()");
        }
        catch (SQLException e) {
            this.log.error("failed to rollback()", e);
            throw e;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            super.rollback(savepoint);
            this.log.log("rollback(" + savepoint + ")");
        }
        catch (SQLException e) {
            this.log.error("failed to rollback(" + savepoint + ")", e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            super.setAutoCommit(autoCommit);
            this.log.log("setAutoCommit(" + autoCommit + ")");
        }
        catch (SQLException e) {
            this.log.error("failed to setAutoCommit(" + autoCommit + ")", e);
            throw e;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            Savepoint result = super.setSavepoint();
            this.log.log("setSavepoint(): " + result);
            return result;
        }
        catch (SQLException e) {
            this.log.error("failed to setSavepoint()", e);
            throw e;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            Savepoint result = super.setSavepoint(name);
            this.log.log("setSavepoint(" + name + "): " + result);
            return result;
        }
        catch (SQLException e) {
            this.log.error("failed to setSavepoint(" + name + ")", e);
            throw e;
        }
    }
}

