/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io;

import java.io.File;
import java.util.List;
import org.asyrinx.brownie.core.io.PathPointer;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public final class FileNameUtils {
    public static boolean hasZipExtension(String filename) {
        String ext = StringUtils.defaultString((String)FileNameUtils.getExtension(filename)).toLowerCase();
        return ext.equals("zip") || ext.equals("jar") || ext.equals("war") || ext.equals("ear");
    }

    public static boolean isAbsolutePath(String fileName) {
        File f = new File(fileName);
        return f.isAbsolute();
    }

    public static String toAbsolutePath(String rootPath, String path) {
        if (FileNameUtils.isAbsolutePath(path)) {
            return path;
        }
        if (StringUtils.isEmpty((String)rootPath)) {
            return path;
        }
        PathPointer pointer = new PathPointer(rootPath);
        pointer.moveTo(path);
        return FileNameUtils.replaceSeparator(pointer.getPath(), FileNameUtils.getFileSeparator(rootPath), FileNameUtils.getFileSeparator(path));
    }

    public static boolean isSeparatorTail(String path) {
        return FileNameUtils.isSeparator(path, File.separator, false) || FileNameUtils.isSeparator(path, "/", false);
    }

    public static boolean isSeparatorHead(String path) {
        return FileNameUtils.isSeparator(path, File.separator, true) || FileNameUtils.isSeparator(path, "/", true);
    }

    private static boolean isSeparator(String path, String separator, boolean isHead) {
        if (path == null) {
            return false;
        }
        if (path.length() < File.separator.length()) {
            return false;
        }
        String target = isHead ? path.substring(0, File.separator.length()) : path.substring(path.length() - File.separator.length());
        return separator.equals(target);
    }

    public static boolean hasFileSeparator(String path) {
        return FileNameUtils.hasFileSeparator(path, File.separator);
    }

    public static boolean hasFileSeparatorSlash(String path) {
        return FileNameUtils.hasFileSeparator(path, "/");
    }

    private static boolean hasFileSeparator(String path, String separator) {
        return path.indexOf(separator) > -1;
    }

    public static String adjustFileSeparator(String path) {
        return FileNameUtils.toFileSeparatorSlash(path);
    }

    public static String toFileSeparatorSlash(String path) {
        return FileNameUtils.hasFileSeparator(path) ? FileNameUtils.replaceSeparator(path, File.separator, "/") : path;
    }

    public static String toFileSeparator(String path) {
        return FileNameUtils.hasFileSeparatorSlash(path) ? FileNameUtils.replaceSeparator(path, "/", File.separator) : path;
    }

    public static String toFileSeparator(String path, String separator) {
        return FileNameUtils.replaceSeparator(FileNameUtils.replaceSeparator(path, "/", separator), File.separator, separator);
    }

    public static boolean hasOneKindSeparator(String path) {
        boolean hasFS = FileNameUtils.hasFileSeparator(path);
        boolean hasFSS = FileNameUtils.hasFileSeparatorSlash(path);
        return !hasFS || !hasFSS;
    }

    public static String getFileSeparator(String path) {
        boolean hasFS = FileNameUtils.hasFileSeparator(path);
        boolean hasFSS = FileNameUtils.hasFileSeparatorSlash(path);
        if (hasFS && !hasFSS) {
            return File.separator;
        }
        return "/";
    }

    public static String addSeparatorHead(String path) {
        if (FileNameUtils.isSeparatorHead(path)) {
            return path;
        }
        return String.valueOf(FileNameUtils.getFileSeparator(path)) + path;
    }

    public static String addSeparatorTail(String path) {
        if (FileNameUtils.isSeparatorTail(path)) {
            return path;
        }
        return String.valueOf(path) + FileNameUtils.getFileSeparator(path);
    }

    public static String deleteSeparatorHead(String path) {
        if (FileNameUtils.isSeparatorHead(path)) {
            String separator = FileNameUtils.getFileSeparator(path);
            return path.substring(separator.length(), path.length() - separator.length() + 1);
        }
        return path;
    }

    public static String deleteSeparatorTail(String path) {
        if (FileNameUtils.isSeparatorTail(path)) {
            return path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    public static String getParentPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        return new File(path).getParent();
    }

    public static String replaceSeparator(String path, String oldSeparator, String newSeparator) {
        return StringUtils.replace((String)path, (String)oldSeparator, (String)newSeparator);
    }

    public static String replaceSeparatorSlash(String path) {
        return StringUtils.replace((String)path, (String)"/", (String)File.separator);
    }

    private static String deleteHeadPath(String targetPath, String deletePath, boolean addSeparator) {
        deletePath = addSeparator ? FileNameUtils.deleteSeparatorTail(deletePath) : FileNameUtils.addSeparatorTail(deletePath);
        int idx = targetPath.indexOf(deletePath);
        if (idx != 0) {
            return targetPath;
        }
        String result = targetPath.substring(deletePath.length());
        if (addSeparator) {
            return FileNameUtils.addSeparatorHead(result);
        }
        return FileNameUtils.deleteSeparatorHead(result);
    }

    public static String toRelativePath(String filePath, String basePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return null;
        }
        if (StringUtils.isEmpty((String)basePath)) {
            return filePath;
        }
        basePath = FileNameUtils.replaceSeparator(FileNameUtils.deleteSeparatorTail(basePath), File.separator, "/");
        if ((filePath = FileNameUtils.replaceSeparator(FileNameUtils.deleteSeparatorTail(filePath), File.separator, "/")).equals(basePath)) {
            return ".";
        }
        if (filePath.startsWith(basePath)) {
            return "." + FileNameUtils.addSeparatorHead(FileNameUtils.deleteHeadPath(filePath, basePath, true));
        }
        if (basePath.startsWith(filePath)) {
            String diff = StringUtils.difference((String)filePath, (String)basePath);
            return FileNameUtils.toParentPath(diff);
        }
        int diffIndex = StringUtils.indexOfDifference((String)filePath, (String)basePath);
        String baseDiff = basePath.substring(diffIndex);
        String fileDiff = filePath.substring(diffIndex);
        return String.valueOf(FileNameUtils.toParentPath("/" + baseDiff)) + "/" + fileDiff;
    }

    private static String toParentPath(String diff) {
        int slashCount = StringUtils.countMatches((String)diff, (String)"/");
        return String.valueOf(StringUtils.repeat((String)"../", (int)(slashCount - 1))) + "..";
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        Object[] parsed = StringUtils.tokenizeToArray(fileName, ".");
        if (parsed.length < 2) {
            return null;
        }
        String result = (String)ArrayUtils.getLast(parsed);
        if (FileNameUtils.replaceSeparatorSlash(result).indexOf(File.separatorChar) > -1) {
            return "";
        }
        return result;
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = FileNameUtils.getExtension(fileName);
        if (ext == null) {
            return fileName;
        }
        return fileName.substring(0, fileName.length() - ext.length() - 1);
    }

    public static String changeExtension(String fileName, String newExtension) {
        if (fileName == null) {
            return null;
        }
        String baseFileName = FileNameUtils.removeExtension(fileName);
        if (StringUtils.isEmpty((String)newExtension)) {
            return baseFileName;
        }
        if (newExtension.charAt(0) != '.') {
            newExtension = String.valueOf('.') + newExtension;
        }
        return String.valueOf(baseFileName) + newExtension;
    }

    public static boolean isURL(String string) {
        return string.indexOf("://") > -1;
    }

    public static List parseFileNames(String fileNames) {
        return StringUtils.tokenize(fileNames, File.pathSeparator);
    }

    public static File toFile(Object obj) {
        if (obj == null) {
            return null;
        }
        if ("".equals(obj)) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        return new File(String.valueOf(obj));
    }
}

