/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.asyrinx.brownie.core.collection.maptree.MapTreeKey;
import org.asyrinx.brownie.core.collection.maptree.MapTreeKeyFactory;
import org.asyrinx.brownie.core.collection.maptree.MapTreeVisitor;

public interface MapTree {
    public Map getRoot();

    public Object get(MapTreeKey var1);

    public Map getMap(MapTreeKey var1);

    public void put(MapTreeKey var1, Object var2);

    public static interface ArrayKey {
        public Map getRoot();

        public Object get(Object[] var1);

        public Map getMap(Object[] var1);

        public void put(Object[] var1, Object var2);
    }

    public static interface ObjectKey {
        public Map getRoot();

        public Object get(Object var1);

        public Map getMap(Object var1);

        public void put(Object var1, Object var2);
    }

    public static interface PropertiesAccessible {
        public void saveTo(Properties var1);

        public void loadFrom(Properties var1);
    }

    public static interface PropertiesAccessibleSupport {
        public void saveToProperties(MapTree var1, Properties var2);

        public void loadFromProperties(MapTree var1, Properties var2);
    }

    public static class Wrapper
    implements MapTree {
        protected final MapTree mapTree;

        public Wrapper(MapTree mapTree) {
            this.mapTree = mapTree;
        }

        public Object get(MapTreeKey key) {
            return this.mapTree.get(key);
        }

        public Map getMap(MapTreeKey key) {
            return this.mapTree.getMap(key);
        }

        public Map getRoot() {
            return this.mapTree.getRoot();
        }

        public void put(MapTreeKey key, Object value) {
            this.mapTree.put(key, value);
        }
    }

    public static final class Unmodifiable
    extends Wrapper {
        public Unmodifiable(MapTree mapTree) {
            super(mapTree);
        }

        public Map getRoot() {
            return Collections.unmodifiableMap(super.getRoot());
        }

        public Map getMap(MapTreeKey key) {
            return Collections.unmodifiableMap(super.getMap(key));
        }

        public void put(MapTreeKey key, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Indexed
    extends Wrapper {
        final Map valueIndex = new HashMap();
        final Map mapIndex = new HashMap();
        final MapTreeKeyFactory keyFactory;

        public Indexed(Unmodifiable unmodifiable, MapTreeKeyFactory keyFactory) {
            super(unmodifiable);
            this.keyFactory = keyFactory;
            this.initIndexes();
        }

        private void initIndexes() {
            MapTreeVisitor visitor = new MapTreeVisitor(this, this.mapTree.getRoot()){
                final /* synthetic */ Indexed this$1;
                {
                    this.this$1 = indexed;
                }

                public void doOnLeaf(Object value) {
                    this.this$1.valueIndex.put(this.this$1.keyFactory.createKey(this.keyStack.toArray()), value);
                }

                public void doOnMap(Map map) {
                    this.this$1.mapIndex.put(this.this$1.keyFactory.createKey(this.keyStack.toArray()), map);
                }
            };
            visitor.execute();
        }

        public Object get(MapTreeKey key) {
            return this.valueIndex.get(key);
        }

        public Map getMap(MapTreeKey key) {
            return (Map)this.mapIndex.get(key);
        }

        public Map getValueIndex() {
            return Collections.unmodifiableMap(this.valueIndex);
        }

        public Map getMapIndex() {
            return Collections.unmodifiableMap(this.mapIndex);
        }
    }
}

