<?php
//-- 配役設定 --//
class ChaosConfig {
  //-- 固定枠 --//
  //闇鍋
  public static $chaos_fix_role_list		= ['mage' => 1, 'wolf' => 1];

  //真・闇鍋
  public static $chaosfull_fix_role_list	= ['mage' => 1, 'wolf' => 1];

  //超・闇鍋
  public static $chaos_hyper_fix_role_list	= ['mage' => 1, 'wolf' => 1];

  //裏・闇鍋
  public static $chaos_verso_fix_role_list	= [];

  //-- 配役テーブル --//
  //人狼の最小出現枠 (役職名 => 出現比)
  //闇鍋
  public static $chaos_wolf_list = [
    'wolf'        => 60,
    'boss_wolf'   =>  5,
    'poison_wolf' => 10,
    'tongue_wolf' =>  5,
    'silver_wolf' => 20
  ];

  //真・闇鍋
  public static $chaosfull_wolf_list = [
    'wolf'        => 60,
    'boss_wolf'   =>  5,
    'cursed_wolf' =>  5,
    'poison_wolf' =>  5,
    'resist_wolf' =>  5,
    'tongue_wolf' =>  5,
    'cute_wolf'   => 10,
    'silver_wolf' =>  5
  ];

  //超・闇鍋
  public static $chaos_hyper_wolf_list = [
    'wolf'           => 15,
    'boss_wolf'      =>  1,
    'mist_wolf'      =>  2,
    'tiger_wolf'     =>  2,
    'gold_wolf'      =>  2,
    'phantom_wolf'   =>  2,
    'cursed_wolf'    =>  2,
    'quiet_wolf'     =>  2,
    'wise_wolf'      =>  3,
    'eye_wolf'       =>  2,
    'disguise_wolf'  =>  2,
    'purple_wolf'    =>  2,
    'snow_wolf'      =>  2,
    'ascetic_wolf'   =>  2,
    'fortitude_wolf' =>  2,
    'poison_wolf'    =>  3,
    'resist_wolf'    =>  2,
    'revive_wolf'    =>  2,
    'trap_wolf'      =>  2,
    'fire_wolf'      =>  2,
    'thorn_wolf'     =>  1,
    'step_wolf'      =>  2,
    'blue_wolf'      =>  2,
    'emerald_wolf'   =>  2,
    'decieve_wolf'   =>  2,
    'doom_wolf'      =>  2,
    'sex_wolf'       =>  2,
    'honey_wolf'     =>  1,
    'sharp_wolf'     =>  1,
    'hungry_wolf'    =>  1,
    'tongue_wolf'    =>  1,
    'possessed_wolf' =>  1,
    'sirius_wolf'    =>  1,
    'elder_wolf'     =>  3,
    'cute_wolf'      =>  7,
    'scarlet_wolf'   =>  3,
    'silver_wolf'    =>  9,
    'emperor_wolf'   =>  5
  ];

  //妖狐の最小出現枠 (役職名 => 出現比)
  //闇鍋
  public static $chaos_fox_list = [
    'fox'       => 90,
    'child_fox' => 10
  ];

  //真・闇鍋
  public static $chaosfull_fox_list = [
    'fox'        => 80,
    'white_fox'  =>  3,
    'poison_fox' =>  3,
    'voodoo_fox' =>  3,
    'cursed_fox' =>  3,
    'silver_fox' =>  3,
    'child_fox'  =>  5
  ];

  //超・闇鍋
  public static $chaos_hyper_fox_list = [
    'fox'            => 18,
    'white_fox'      =>  2,
    'black_fox'      =>  2,
    'mist_fox'       =>  3,
    'tiger_fox'      =>  3,
    'gold_fox'       =>  2,
    'phantom_fox'    =>  2,
    'purple_fox'     =>  2,
    'snow_fox'       =>  3,
    'fortitude_fox'  =>  2,
    'poison_fox'     =>  3,
    'blue_fox'       =>  2,
    'spell_fox'      =>  2,
    'sacrifice_fox'  =>  2,
    'emerald_fox'    =>  2,
    'voodoo_fox'     =>  2,
    'step_fox'       =>  2,
    'revive_fox'     =>  2,
    'possessed_fox'  =>  2,
    'doom_fox'       =>  2,
    'trap_fox'       =>  2,
    'cursed_fox'     =>  2,
    'elder_fox'      =>  3,
    'cute_fox'       =>  5,
    'scarlet_fox'    =>  3,
    'silver_fox'     =>  3,
    'immolate_fox'   =>  2,
    'child_fox'      =>  4,
    'sex_fox'        =>  2,
    'stargazer_fox'  =>  2,
    'jammer_fox'     =>  2,
    'monk_fox'       =>  2,
    'miasma_fox'     =>  2,
    'howl_fox'       =>  2,
    'vindictive_fox' =>  2,
    'critical_fox'   =>  2
  ];

  //ランダム配役テーブル (役職名 => 出現比)
  //闇鍋
  public static $chaos_random_role_list = [
    'human'           => 88,
    'mage'            => 50,
    'soul_mage'       =>  5,
    'psycho_mage'     => 10,
    'necromancer'     => 60,
    'medium'          => 30,
    'guard'           => 70,
    'poison_guard'    =>  5,
    'reporter'        => 15,
    'common'          => 75,
    'poison'          => 40,
    'incubate_poison' => 10,
    'pharmacist'      => 20,
    'assassin'        => 20,
    'doll'            => 20,
    'doll_master'     => 10,
    'escaper'         => 30,
    'wolf'            => 80,
    'boss_wolf'       => 10,
    'poison_wolf'     => 40,
    'tongue_wolf'     => 20,
    'silver_wolf'     => 30,
    'mad'             => 60,
    'fanatic_mad'     => 20,
    'whisper_mad'     => 10,
    'fox'             => 50,
    'child_fox'       => 20,
    'cupid'           => 30,
    'self_cupid'      => 10,
    'quiz'            =>  2,
    'chiroptera'      => 50,
    'mania'           => 10
  ];

  //真・闇鍋
  public static $chaosfull_random_role_list = [
    'human'              =>  3,
    'suspect'            => 15,
    'unconscious'        => 20,
    'mage'               => 20,
    'soul_mage'          =>  5,
    'psycho_mage'        => 10,
    'sex_mage'           => 15,
    'voodoo_killer'      => 10,
    'dummy_mage'         => 15,
    'necromancer'        => 40,
    'soul_necromancer'   =>  5,
    'yama_necromancer'   => 10,
    'dummy_necromancer'  => 25,
    'medium'             => 30,
    'guard'              => 40,
    'poison_guard'       =>  5,
    'reporter'           => 10,
    'anti_voodoo'        => 15,
    'dummy_guard'        => 20,
    'common'             => 80,
    'dummy_common'       => 10,
    'poison'             => 20,
    'strong_poison'      =>  5,
    'incubate_poison'    => 10,
    'dummy_poison'       => 15,
    'poison_cat'         => 10,
    'pharmacist'         => 30,
    'assassin'           => 20,
    'mind_scanner'       => 20,
    'jealousy'           => 15,
    'wolf'               => 75,
    'boss_wolf'          => 10,
    'cursed_wolf'        => 10,
    'poison_wolf'        => 15,
    'resist_wolf'        => 15,
    'tongue_wolf'        => 20,
    'cute_wolf'          => 30,
    'silver_wolf'        => 15,
    'mad'                => 20,
    'fanatic_mad'        => 10,
    'whisper_mad'        =>  5,
    'jammer_mad'         => 10,
    'voodoo_mad'         => 10,
    'dream_eater_mad'    => 10,
    'trap_mad'           => 10,
    'corpse_courier_mad' => 15,
    'fox'                => 30,
    'white_fox'          => 10,
    'poison_fox'         =>  7,
    'voodoo_fox'         =>  5,
    'cursed_fox'         =>  3,
    'silver_fox'         =>  5,
    'child_fox'          => 10,
    'cupid'              => 25,
    'self_cupid'         => 10,
    'mind_cupid'         =>  5,
    'quiz'               =>  2,
    'chiroptera'         => 20,
    'poison_chiroptera'  =>  5,
    'cursed_chiroptera'  =>  5,
    'mania'              => 20,
    'unknown_mania'      => 10
  ];

  //超・闇鍋
  public static $chaos_hyper_random_role_list = [
    'human'                 =>   1,
    'saint'                 =>  12,
    'executor'              =>   9,
    'elder'                 =>  20,
    'scripter'              =>  10,
    'eccentricer'           =>  10,
    'tough'                 =>   9,
    'prince'                =>   9,
    'suspect'               =>  20,
    'unconscious'           =>  20,
    'mage'                  => 100,
    'puppet_mage'           =>  40,
    'step_mage'             =>  25,
    'critical_mage'         =>  30,
    'soul_mage'             =>  20,
    'psycho_mage'           =>  60,
    'sex_mage'              =>  40,
    'stargazer_mage'        =>  40,
    'voodoo_killer'         =>  90,
    'cute_mage'             =>  35,
    'dummy_mage'            =>  70,
    'necromancer'           => 100,
    'soul_necromancer'      =>  20,
    'psycho_necromancer'    =>  65,
    'embalm_necromancer'    =>  60,
    'emissary_necromancer'  =>  30,
    'attempt_necromancer'   =>  60,
    'yama_necromancer'      =>  90,
    'dummy_necromancer'     =>  75,
    'medium'                =>  60,
    'bacchus_medium'        =>  45,
    'seal_medium'           =>  35,
    'revive_medium'         =>  25,
    'eclipse_medium'        =>  35,
    'priest'                =>  40,
    'bishop_priest'         =>  30,
    'dowser_priest'         =>  20,
    'weather_priest'        =>  20,
    'high_priest'           =>  20,
    'crisis_priest'         =>  30,
    'widow_priest'          =>  25,
    'holy_priest'           =>  20,
    'revive_priest'         => 100,
    'border_priest'         =>  20,
    'dummy_priest'          =>  25,
    'guard'                 => 120,
    'hunter_guard'          =>  90,
    'blind_guard'           =>  25,
    'gatekeeper_guard'      =>  40,
    'step_guard'            =>  35,
    'grave_guard'           =>  30,
    'wanderer_guard'        =>  35,
    'reflect_guard'         =>  30,
    'poison_guard'          =>  20,
    'fend_guard'            =>  25,
    'reporter'              => 100,
    'anti_voodoo'           => 150,
    'elder_guard'           =>  70,
    'dummy_guard'           =>  80,
    'common'                => 250,
    'leader_common'         =>  35,
    'detective_common'      =>  40,
    'trap_common'           =>  60,
    'sacrifice_common'      =>  50,
    'ghost_common'          =>  25,
    'spell_common'          =>  30,
    'critical_common'       =>  40,
    'hermit_common'         =>  70,
    'dummy_common'          => 150,
    'poison'                => 120,
    'strong_poison'         =>  30,
    'incubate_poison'       =>  80,
    'guide_poison'          =>  60,
    'snipe_poison'          =>  60,
    'chain_poison'          =>  60,
    'dummy_poison'          =>  90,
    'poison_cat'            =>  40,
    'revive_cat'            =>  25,
    'sacrifice_cat'         =>  25,
    'doom_cat'              =>  20,
    'missfire_cat'          =>  20,
    'eclipse_cat'           =>  20,
    'pharmacist'            =>  60,
    'cure_pharmacist'       =>  40,
    'revive_pharmacist'     =>  30,
    'alchemy_pharmacist'    =>  30,
    'centaurus_pharmacist'  =>  40,
    'assassin'              =>  25,
    'doom_assassin'         =>  18,
    'select_assassin'       =>  16,
    'step_assassin'         =>  12,
    'sweep_assassin'        =>  12,
    'professional_assassin' =>  12,
    'ascetic_assassin'      =>  15,
    'reverse_assassin'      =>  12,
    'soul_assassin'         =>  10,
    'eclipse_assassin'      =>  18,
    'mind_scanner'          =>  25,
    'evoke_scanner'         =>  18,
    'presage_scanner'       =>  15,
    'step_scanner'          =>  12,
    'clairvoyance_scanner'  =>  10,
    'eye_scanner'           =>  18,
    'whisper_scanner'       =>  14,
    'howl_scanner'          =>  14,
    'telepath_scanner'      =>  14,
    'dummy_scanner'         =>  20,
    'jealousy'              =>  30,
    'divorce_jealousy'      =>  20,
    'priest_jealousy'       =>  20,
    'poison_jealousy'       =>  15,
    'miasma_jealousy'       =>  15,
    'critical_jealousy'     =>  20,
    'brownie'               =>  20,
    'thunder_brownie'       =>  14,
    'echo_brownie'          =>  10,
    'revive_brownie'        =>  14,
    'harvest_brownie'       =>  12,
    'maple_brownie'         =>  12,
    'cursed_brownie'        =>  10,
    'sun_brownie'           =>  10,
    'history_brownie'       =>  10,
    'barrier_brownie'       =>   8,
    'wizard'                =>  18,
    'soul_wizard'           =>   6,
    'pierrot_wizard'        =>   8,
    'esper_wizard'          =>  12,
    'awake_wizard'          =>  14,
    'mimic_wizard'          =>  14,
    'spiritism_wizard'      =>  12,
    'philosophy_wizard'     =>  14,
    'barrier_wizard'        =>  10,
    'astray_wizard'         =>  12,
    'doll'                  =>  50,
    'friend_doll'           =>  30,
    'phantom_doll'          =>  20,
    'poison_doll'           =>  20,
    'doom_doll'             =>  20,
    'revive_doll'           =>  20,
    'scarlet_doll'          =>  20,
    'silver_doll'           =>  20,
    'doll_master'           =>  40,
    'toy_doll_master'       =>  30,
    'revive_doll_master'    =>  20,
    'serve_doll_master'     =>  10,
    'escaper'               =>  25,
    'psycho_escaper'        =>  18,
    'incubus_escaper'       =>  16,
    'succubus_escaper'      =>  16,
    'doom_escaper'          =>  10,
    'agent_escaper'         =>  12,
    'divine_escaper'        =>   8,
    'stargazer_escaper'     =>  15,
    'wolf'                  => 150,
    'boss_wolf'             =>  20,
    'mist_wolf'             =>  30,
    'tiger_wolf'            =>  30,
    'gold_wolf'             =>  30,
    'phantom_wolf'          =>  40,
    'cursed_wolf'           =>  30,
    'quiet_wolf'            =>  30,
    'wise_wolf'             => 100,
    'eye_wolf'              =>  30,
    'disguise_wolf'         =>  30,
    'purple_wolf'           =>  40,
    'snow_wolf'             =>  40,
    'ascetic_wolf'          =>  40,
    'fortitude_wolf'        =>  30,
    'poison_wolf'           => 150,
    'resist_wolf'           => 100,
    'revive_wolf'           =>  30,
    'trap_wolf'             =>  30,
    'fire_wolf'             =>  40,
    'thorn_wolf'            =>  20,
    'step_wolf'             =>  30,
    'blue_wolf'             =>  40,
    'emerald_wolf'          =>  40,
    'decieve_wolf'          =>  30,
    'doom_wolf'             =>  40,
    'sex_wolf'              =>  40,
    'honey_wolf'            =>  30,
    'sharp_wolf'            =>  30,
    'hungry_wolf'           =>  50,
    'tongue_wolf'           =>  30,
    'possessed_wolf'        =>  20,
    'sirius_wolf'           =>  20,
    'elder_wolf'            =>  50,
    'cute_wolf'             => 100,
    'scarlet_wolf'          =>  70,
    'silver_wolf'           =>  90,
    'emperor_wolf'          =>  50,
    'mad'                   =>  75,
    'fanatic_mad'           =>  25,
    'whisper_mad'           =>  20,
    'swindle_mad'           =>  30,
    'jammer_mad'            =>  60,
    'voodoo_mad'            =>  40,
    'enchant_mad'           =>  30,
    'seiren_mad'            =>  30,
    'step_mad'              =>  30,
    'dream_eater_mad'       =>  60,
    'possessed_mad'         =>  30,
    'grave_mad'             =>  30,
    'trap_mad'              =>  40,
    'snow_trap_mad'         =>  30,
    'corpse_courier_mad'    =>  50,
    'amaze_mad'             =>  30,
    'agitate_mad'           =>  30,
    'miasma_mad'            =>  30,
    'critical_mad'          =>  30,
    'fire_mad'              =>  30,
    'follow_mad'            =>  30,
    'therian_mad'           =>  40,
    'revive_mad'            =>  30,
    'spy_mad'               =>  25,
    'immolate_mad'          =>  45,
    'fox'                   =>  40,
    'white_fox'             =>  10,
    'black_fox'             =>  12,
    'mist_fox'              =>  12,
    'tiger_fox'             =>  12,
    'gold_fox'              =>  14,
    'phantom_fox'           =>  14,
    'purple_fox'            =>  16,
    'snow_fox'              =>  16,
    'fortitude_fox'         =>  12,
    'poison_fox'            =>  18,
    'blue_fox'              =>  14,
    'spell_fox'             =>  14,
    'sacrifice_fox'         =>  16,
    'emerald_fox'           =>  14,
    'voodoo_fox'            =>  10,
    'step_fox'              =>  14,
    'revive_fox'            =>  12,
    'possessed_fox'         =>  12,
    'doom_fox'              =>  10,
    'trap_fox'              =>  10,
    'cursed_fox'            =>   8,
    'elder_fox'             =>  18,
    'cute_fox'              =>  18,
    'scarlet_fox'           =>  18,
    'silver_fox'            =>  16,
    'immolate_fox'          =>  20,
    'child_fox'             =>  24,
    'sex_fox'               =>  14,
    'stargazer_fox'         =>  14,
    'jammer_fox'            =>  10,
    'monk_fox'              =>  12,
    'miasma_fox'            =>  16,
    'howl_fox'              =>  16,
    'vindictive_fox'        =>  12,
    'critical_fox'          =>  12,
    'depraver'              =>  30,
    'fire_depraver'         =>  15,
    'sacrifice_depraver'    =>  10,
    'silver_depraver'       =>  15,
    'cupid'                 =>  25,
    'self_cupid'            =>  18,
    'moon_cupid'            =>  12,
    'altair_cupid'          =>  10,
    'mind_cupid'            =>  15,
    'sweet_cupid'           =>  15,
    'letter_cupid'          =>  10,
    'minstrel_cupid'        =>   8,
    'triangle_cupid'        =>  12,
    'nephila_cupid'         =>  10,
    'revive_cupid'          =>  10,
    'snow_cupid'            =>  15,
    'angel'                 =>  30,
    'rose_angel'            =>  20,
    'lily_angel'            =>  20,
    'exchange_angel'        =>  12,
    'ark_angel'             =>  12,
    'sacrifice_angel'       =>   8,
    'scarlet_angel'         =>  18,
    'cursed_angel'          =>  20,
    'quiz'                  =>  20,
    'vampire'               =>  18,
    'poison_vampire'        =>  14,
    'follow_vampire'        =>  10,
    'incubus_vampire'       =>  10,
    'succubus_vampire'      =>  10,
    'homogeneous_vampire'   =>  12,
    'heterologous_vampire'  =>  12,
    'passion_vampire'       =>  12,
    'step_vampire'          =>  12,
    'doom_vampire'          =>   8,
    'sacrifice_vampire'     =>   8,
    'soul_vampire'          =>   6,
    'scarlet_vampire'       =>  18,
    'chiroptera'            =>  40,
    'poison_chiroptera'     =>  20,
    'cursed_chiroptera'     =>  20,
    'boss_chiroptera'       =>  10,
    'elder_chiroptera'      =>  15,
    'cute_chiroptera'       =>  25,
    'doom_chiroptera'       =>  15,
    'scarlet_chiroptera'    =>  20,
    'dummy_chiroptera'      =>  15,
    'fairy'                 =>  10,
    'spring_fairy'          =>   7,
    'summer_fairy'          =>   7,
    'autumn_fairy'          =>   7,
    'winter_fairy'          =>   7,
    'flower_fairy'          =>   6,
    'star_fairy'            =>   6,
    'sun_fairy'             =>   6,
    'moon_fairy'            =>   6,
    'grass_fairy'           =>   6,
    'light_fairy'           =>   6,
    'dark_fairy'            =>   6,
    'shadow_fairy'          =>   6,
    'greater_fairy'         =>   6,
    'mirror_fairy'          =>   6,
    'sweet_fairy'           =>   6,
    'gender_fairy'          =>   6,
    'chill_fairy'           =>   5,
    'ice_fairy'             =>   5,
    'ogre'                  =>  12,
    'orange_ogre'           =>   9,
    'indigo_ogre'           =>   9,
    'cow_ogre'              =>   7,
    'horse_ogre'            =>   7,
    'poison_ogre'           =>   9,
    'west_ogre'             =>   6,
    'east_ogre'             =>   6,
    'north_ogre'            =>   6,
    'south_ogre'            =>   6,
    'incubus_ogre'          =>   8,
    'wise_ogre'             =>   8,
    'collector_ogre'        =>   8,
    'power_ogre'            =>   6,
    'revive_ogre'           =>   8,
    'sacrifice_ogre'        =>   5,
    'yaksa'                 =>  12,
    'betray_yaksa'          =>  10,
    'cursed_yaksa'          =>  10,
    'succubus_yaksa'        =>  10,
    'hariti_yaksa'          =>  10,
    'vajra_yaksa'           =>  10,
    'power_yaksa'           =>  10,
    'dowser_yaksa'          =>   8,
    'duelist'               =>   8,
    'valkyrja_duelist'      =>   6,
    'critical_duelist'      =>   4,
    'cowboy_duelist'        =>   6,
    'triangle_duelist'      =>   5,
    'triphase_duelist'      =>   5,
    'doom_duelist'          =>   5,
    'perverse_duelist'      =>   5,
    'sea_duelist'           =>   6,
    'avenger'               =>  10,
    'poison_avenger'        =>   6,
    'cursed_avenger'        =>   6,
    'critical_avenger'      =>   8,
    'trick_avenger'         =>   3,
    'foughten_avenger'      =>   6,
    'revive_avenger'        =>   4,
    'cute_avenger'          =>   7,
    'patron'                =>  12,
    'soul_patron'           =>   7,
    'sacrifice_patron'      =>   6,
    'shepherd_patron'       =>   8,
    'plumage_patron'        =>   7,
    'critical_patron'       =>  10,
    'tengu'                 =>  25,
    'soul_tengu'            =>  10,
    'passion_tengu'         =>  20,
    'meteor_tengu'          =>  15,
    'involve_tengu'         =>  12,
    'priest_tengu'          =>  18,
    'eclipse_tengu'         =>  20,
    'mania'                 =>  65,
    'trick_mania'           =>  20,
    'basic_mania'           =>  20,
    'scarlet_mania'         =>  15,
    'soul_mania'            =>  10,
    'dummy_mania'           =>  10,
    'unknown_mania'         =>  14,
    'wirepuller_mania'      =>   8,
    'fire_mania'            =>   8,
    'sacrifice_mania'       =>   5,
    'resurrect_mania'       =>   5,
    'revive_mania'          =>   5,
    'lute_mania'            =>   5,
    'harp_mania'            =>   5,
    'mask_mania'            =>   5
  ];

  //裏・闇鍋
  public static $chaos_verso_random_role_list = [
    'human'       => 14,
    'mage'        => 10,
    'necromancer' => 10,
    'guard'       =>  5,
    'common'      => 10,
    'poison'      =>  5,
    'assassin'    =>  5,
    'wolf'        => 20,
    'mad'         => 10,
    'fanatic_mad' =>  5,
    'fox'         =>  5,
    'quiz'        =>  1
  ];

  //村人から振り返る役職 => 出現比
  //闇鍋
  public static $chaos_replace_human_role_list		= ['mania' => 1];

  //真・闇鍋
  public static $chaosfull_replace_human_role_list	= ['mania' => 7, 'unknown_mania' => 3];

  //超・闇鍋
  public static $chaos_hyper_replace_human_role_list	= [
    'mania'            => 15,
    'trick_mania'      => 12,
    'basic_mania'      => 12,
    'scarlet_mania'    =>  9,
    'soul_mania'       =>  7,
    'dummy_mania'      =>  5,
    'unknown_mania'    =>  8,
    'wirepuller_mania' =>  6,
    'fire_mania'       =>  5,
    'sacrifice_mania'  =>  3,
    'resurrect_mania'  =>  3,
    'revive_mania'     =>  3,
    'lute_mania'       =>  4,
    'harp_mania'       =>  4,
    'mask_mania'       =>  4
  ];

  //-- 出現補正値 --//
  public static $min_wolf_rate  = 10; //人狼の最小出現比 (総人口 / N)
  public static $min_fox_rate   = 15; //妖狐の最小出現比 (総人口 / N)
  public static $max_human_rate = 10; //村人の最大出現比 (総人口 / N)

  //役職グループの最大出現比 (グループ => 総人口 / N)
  public static $role_group_rate_list = [
    CampGroup::MAGE         =>  6.2,
    CampGroup::NECROMANCER  =>  6.2,
    CampGroup::MEDIUM       =>  6.2,
    CampGroup::PRIEST       =>  7.1,
    CampGroup::GUARD        =>  7.1,
    CampGroup::COMMON       =>  7.1,
    CampGroup::POISON       =>  7.1,
    CampGroup::POISON_CAT   => 10,
    CampGroup::PHARMACIST   =>  7.1,
    CampGroup::ASSASSIN     =>  9,
    CampGroup::MIND_SCANNER =>  7.1,
    CampGroup::JEALOUSY     =>  8,
    CampGroup::BROWNIE      =>  8,
    CampGroup::WIZARD       =>  9,
    CampGroup::DOLL         =>  7.1,
    CampGroup::ESCAPER      =>  7.1,
    CampGroup::WOLF         =>  4.8,
    CampGroup::MAD          =>  7.1,
    CampGroup::FOX          => 10,
    CampGroup::CHILD_FOX    => 14.2,
    CampGroup::DEPRAVER     => 16.1,
    CampGroup::CUPID        => 10,
    CampGroup::ANGEL        => 12,
    CampGroup::QUIZ         =>  8,
    CampGroup::VAMPIRE      =>  8,
    CampGroup::CHIROPTERA   =>  8,
    CampGroup::FAIRY        =>  9,
    CampGroup::OGRE         =>  9,
    CampGroup::YAKSA        => 12,
    CampGroup::DUELIST      => 15.0,
    CampGroup::AVENGER      => 16.1,
    CampGroup::PATRON       => 15.0,
    CampGroup::TENGU        => 12
  ];

  //-- 固定配役追加モード --//
  /*
    fix    : 固定枠
    random : ランダム枠 (各配列の中身は役職 => 出現比)
    count  : ランダム出現数 (ランダム枠毎の出現数)

    例)
    doll_master が +1, [doll:poison_doll = 2:1] の割合でランダムに +1,
    [scarlet_doll:silver_doll = 5:1] の割合でランダムに +2
    'a' => ['fix'    => ['doll_master' => 1],
	    'random' => [['doll'  => 2, 'poison_doll' => 1],
			 ['scarlet_doll' => 5, 'silver_doll' => 1]],
	     'count'  => [1, 2]],
  */
  public static $topping_list = [
    'a' => ['random' => [['doll'         => 30,
			  'friend_doll'  =>  5,
			  'phantom_doll' => 10,
			  'poison_doll'  => 15,
			  'doom_doll'    => 15,
			  'revive_doll'  => 10,
			  'scarlet_doll' => 10,
			  'silver_doll'  =>  5],
			 ['doll_master'        => 40,
			  'toy_doll_master'    => 30,
			  'revive_doll_master' => 20,
			  'serve_doll_master'  => 10],
			 ['puppet_mage'        => 15,
			  'scarlet_doll'       =>  5,
			  'scarlet_wolf'       => 25,
			  'scarlet_fox'        => 15,
			  'scarlet_angel'      => 15,
			  'scarlet_vampire'    => 10,
			  'scarlet_chiroptera' => 10,
			  'scarlet_mania'      =>  5]],
	    'count'  => [1, 1, 1]],
    'b' => ['fix'    => ['quiz' => 1, 'poison_ogre' => 1]],
    'c' => ['random' => [['vampire'              => 12,
			  'poison_vampire'       => 10,
			  'follow_vampire'       =>  8,
			  'incubus_vampire'      =>  6,
			  'succubus_vampire'     =>  6,
			  'homogeneous_vampire'  =>  8,
			  'heterologous_vampire' =>  8,
			  'passion_vampire'      =>  9,
			  'step_vampire'         =>  8,
			  'doom_vampire'         =>  6,
			  'sacrifice_vampire'    =>  6,
			  'soul_vampire'         =>  3,
			  'scarlet_vampire'      => 10],
			 ['mist_wolf'       => 60,
			  'mist_fox'        => 30,
			  'boss_chiroptera' => 10]],
	    'count' => [1, 1]],
    'd' => ['fix'    => ['grave_mad' => 1],
	    'random' => [['poison_cat'    => 3,
			  'revive_cat'    => 2,
			  'sacrifice_cat' => 1,
			  'doom_cat'      => 1,
			  'missfire_cat'  => 1,
			  'eclipse_cat'   => 2]],
	    'count'  => [1]],
    'e' => ['fix' => ['anti_voodoo' => 1, 'possessed_wolf' => 1]],
    'f' => ['random' => [['ogre'           => 8,
			  'orange_ogre'    => 5,
			  'indigo_ogre'    => 5,
			  'cow_ogre'       => 3,
			  'horse_ogre'     => 3,
			  'poison_ogre'    => 3,
			  'west_ogre'      => 3,
			  'east_ogre'      => 3,
			  'north_ogre'     => 3,
			  'south_ogre'     => 3,
			  'incubus_ogre'   => 3,
			  'wise_ogre'      => 5,
			  'collector_ogre' => 4,
			  'power_ogre'     => 4,
			  'revive_ogre'    => 4,
			  'sacrifice_ogre' => 3,
			  'yaksa'          => 7,
			  'betray_yaksa'   => 5,
			  'cursed_yaksa'   => 5,
			  'succubus_yaksa' => 3,
			  'hariti_yaksa'   => 5,
			  'vajra_yaksa'    => 5,
			  'power_yaksa'    => 5,
			  'dowser_yaksa'   => 3]],
	    'count' => [2]],
    'g' => ['random' => [['mad'                => 5,
			  'fanatic_mad'        => 3,
			  'whisper_mad'        => 2,
			  'swindle_mad'        => 3,
			  'jammer_mad'         => 4,
			  'voodoo_mad'         => 4,
			  'enchant_mad'        => 5,
			  'seiren_mad'         => 4,
			  'step_mad'           => 4,
			  'dream_eater_mad'    => 5,
			  'possessed_mad'      => 4,
			  'grave_mad'          => 4,
			  'trap_mad'           => 4,
			  'snow_trap_mad'      => 4,
			  'corpse_courier_mad' => 5,
			  'amaze_mad'          => 4,
			  'agitate_mad'        => 4,
			  'miasma_mad'         => 4,
			  'critical_mad'       => 4,
			  'fire_mad'           => 4,
			  'follow_mad'         => 4,
			  'therian_mad'        => 5,
			  'revive_mad'         => 4,
			  'spy_mad'            => 4,
			  'immolate_mad'       => 4],
			 ['suspect'           => 1,
			  'unconscious'       => 1,
			  'dummy_mage'        => 1,
			  'dummy_necromancer' => 1,
			  'dummy_priest'      => 1,
			  'dummy_guard'       => 1,
			  'dummy_common'      => 1,
			  'dummy_poison'      => 1,
			  'dummy_scanner'     => 1,
			  'dummy_chiroptera'  => 1,
			  'dummy_mania'       => 1],
			 ['psycho_mage'        => 10,
			  'psycho_necromancer' =>  5,
			  'psycho_escaper'     => 20,
			  'dream_eater_mad'    => 10,
			  'revive_ogre'        =>  5]],
	    'count' => [1, 1, 1]],
    'h' => ['fix' => ['human' => 2]],
    'i' => ['random' => [['jealousy'          => 30,
			  'divorce_jealousy'  => 20,
			  'priest_jealousy'   => 15,
			  'poison_jealousy'   => 10,
			  'miasma_jealousy'   =>  5,
			  'critical_jealousy' => 20],
			 ['cupid'           => 9,
			  'self_cupid'      => 5,
			  'moon_cupid'      => 3,
			  'altair_cupid'    => 3,
			  'mind_cupid'      => 3,
			  'sweet_cupid'     => 5,
			  'letter_cupid'    => 3,
			  'minstrel_cupid'  => 2,
			  'triangle_cupid'  => 4,
			  'nephila_cupid'   => 3,
			  'revive_cupid'    => 3,
			  'snow_cupid'      => 7,
			  'angel'           => 8,
			  'rose_angel'      => 8,
			  'lily_angel'      => 8,
			  'exchange_angel'  => 5,
			  'ark_angel'       => 5,
			  'sacrifice_angel' => 5,
			  'scarlet_angel'   => 5,
			  'cursed_angel'    => 6]],
	    'count' => [1, 2]],
    'j' => ['random' => [['duelist'          =>  8,
			  'valkyrja_duelist' =>  6,
			  'critical_duelist' =>  4,
			  'cowboy_duelist'   =>  6,
			  'triangle_duelist' =>  5,
			  'triphase_duelist' =>  5,
			  'doom_duelist'     =>  5,
			  'perverse_duelist' =>  5,
			  'sea_duelist'      =>  6,
			  'avenger'          =>  5,
			  'poison_avenger'   =>  2,
			  'cursed_avenger'   =>  2,
			  'critical_avenger' =>  2,
			  'trick_avenger'    =>  2,
			  'foughten_avenger' =>  2,
			  'revive_avenger'   =>  2,
			  'cute_avenger'     =>  3,
			  'patron'           =>  8,
			  'soul_patron'      =>  4,
			  'sacrifice_patron' =>  4,
			  'shepherd_patron'  =>  4,
			  'plumage_patron'   =>  4,
			  'critical_patron'  =>  6]],
	    'count' => [1]],
    'k' => ['random' => [['executor'             => 8,
			  'soul_mage'            => 4,
			  'soul_necromancer'     => 6,
			  'revive_medium'        => 6,
			  'high_priest'          => 6,
			  'poison_guard'         => 4,
			  'ghost_common'         => 4,
			  'strong_poison'        => 6,
			  'revive_cat'           => 6,
			  'alchemy_pharmacist'   => 6,
			  'soul_assassin'        => 4,
			  'clairvoyance_scanner' => 6,
			  'miasma_jealousy'      => 6,
			  'barrier_brownie'      => 6,
			  'soul_wizard'          => 6,
			  'serve_doll_master'    => 8,
			  'divine_escaper'       => 8],
			 ['boss_wolf'      => 2,
			  'eye_wolf'       => 1,
			  'thorn_wolf'     => 1,
			  'sharp_wolf'     => 1,
			  'tongue_wolf'    => 1,
			  'possessed_wolf' => 1,
			  'sirius_wolf'    => 1,
			  'whisper_mad'    => 2],
			 ['cursed_fox'         =>  7,
			  'jammer_fox'         =>  5,
			  'sacrifice_depraver' =>  3,
			  'minstrel_cupid'     =>  9,
			  'sacrifice_angel'    =>  6,
			  'quiz'               =>  5,
			  'soul_vampire'       => 10,
			  'boss_chiroptera'    =>  9,
			  'ice_fairy'          =>  6,
			  'sacrifice_ogre'     =>  9,
			  'dowser_yaksa'       =>  6,
			  'critical_duelist'   =>  5,
			  'revive_avenger'     =>  3,
			  'sacrifice_patron'   =>  2,
			  'soul_tengu'         =>  5,
			  'soul_mania'         =>  5,
			  'sacrifice_mania'    =>  5]],
	    'count' => [1, 1, 1]],
    'l' => ['fix' => ['ghost_common' => 1,
		      'boss_wolf'    => 1,
		      'silver_wolf'  => 1,
		      'howl_fox'     => 1]],
    'm' => ['fix'    => ['trap_wolf' => 1, 'doom_fox' => 1],
	    'random' => [['step_assassin' => 3, 'sweep_assassin' => 7]],
	    'count'  => [2]],
    'n' => ['fix' => ['guard' => 1, 'trap_wolf' => 1, 'trap_mad' => 1]],
    'o' => ['fix' => ['voodoo_killer' => 1, 'cursed_yaksa' => 1, 'cursed_avenger' => 1],
	    'random' => [['wizard'            => 18,
			  'soul_wizard'       =>  4,
			  'esper_wizard'      =>  8,
			  'pierrot_wizard'    =>  6,
			  'awake_wizard'      => 10,
			  'mimic_wizard'      => 12,
			  'spiritism_wizard'  => 10,
			  'philosophy_wizard' => 14,
			  'barrier_wizard'    =>  6,
			  'astray_wizard'     => 12]],
	    'count'  => [1]],
    'p' => ['fix' => ['step_wolf' => 1],
	    'random' => [['step_mage'     => 20,
			  'step_guard'    => 16,
			  'step_assassin' =>  7,
			  'step_scanner'  =>  7,
			  'step_mad'      => 18,
			  'step_fox'      => 12,
			  'step_vampire'  => 10,
			  'lute_mania'    =>  5,
			  'harp_mania'    =>  5]],
	    'count'  => [2]],
    'q' => ['random' => [['sex_mage' => 20,
			  'sex_wolf' => 2,
			  'sex_fox'  => 1],
			 ['incubus_escaper'      => 15,
			  'succubus_escaper'     => 15,
			  'angel'                =>  8,
			  'rose_angel'           =>  8,
			  'lily_angel'           =>  8,
			  'incubus_vampire'      =>  5,
			  'succubus_vampire'     =>  5,
			  'homogeneous_vampire'  =>  5,
			  'heterologous_vampire' =>  5,
			  'incubus_ogre'         => 10,
			  'succubus_yaksa'       => 10,
			  'gender_fairy'         =>  6]],
	    'count'  => [1, 1]],
    'r' => ['random' => [['fairy'         => 1,
			  'spring_fairy'  => 1,
			  'summer_fairy'  => 1,
			  'autumn_fairy'  => 1,
			  'winter_fairy'  => 1,
			  'flower_fairy'  => 1,
			  'star_fairy'    => 1,
			  'sun_fairy'     => 1,
			  'moon_fairy'    => 1,
			  'grass_fairy'   => 1,
			  'light_fairy'   => 1,
			  'dark_fairy'    => 1,
			  'shadow_fairy'  => 1,
			  'greater_fairy' => 1,
			  'mirror_fairy'  => 1,
			  'sweet_fairy'   => 1,
			  'gender_fairy'  => 1,
			  'chill_fairy'   => 1,
			  'ice_fairy'     => 1],
			 ['dummy_guard'     => 1,
			  'dummy_poison'    => 1,
			  'dream_eater_mad' => 2]],
	    'count'  => [1, 1]],
    's' => ['fix'    => ['boss_wolf' => 1],
	    'random' => [['necromancer'       => 6,
			  'soul_necromancer'  => 1,
			  'dummy_necromancer' => 3],
			 ['white_fox'       => 3,
			  'black_fox'       => 5,
			  'cute_chiroptera' => 2]],
	    'count'  => [1,1]],
    't' => ['random' => [['tengu'         => 24,
			  'soul_tengu'    => 10,
			  'passion_tengu' => 12,
			  'meteor_tengu'  => 12,
			  'involve_tengu' => 12,
			  'priest_tengu'  => 14,
			  'eclipse_tengu' => 16]],
	    'count'  => [1]],
    'u' => ['fix'    => ['fanatic_mad' => 1],
	    'random' => [['depraver'           => 5,
			  'fire_depraver'      => 2,
			  'sacrifice_depraver' => 1,
			  'silver_depraver'    => 2]],
	    'count'  => [1]],
  ];

  //-- 出現率変動モード --//
  /* 役職 => 倍率 (0 なら出現しなくなる) */
  public static $boost_rate_list = [
    'a' => ['homogeneous_vampire'   => 10,
	    'heterologous_vampire'  => 10,
	    'gender_fairy'          => 25],
    'b' => ['elder'             => 0,
	    'scripter'          => 0,
	    'eccentricer'       => 0,
	    'critical_mage'     => 0,
	    'elder_guard'       => 0,
	    'critical_common'   => 0,
	    'critical_jealousy' => 0,
	    'brownie'           => 0,
	    'harvest_brownie'   => 0,
	    'maple_brownie'     => 0,
	    'esper_wizard'      => 0,
	    'philosophy_wizard' => 0,
	    'divine_escaper'    => 0,
	    'ascetic_wolf'      => 0,
	    'elder_wolf'        => 0,
	    'possessed_mad'     => 0,
	    'elder_fox'         => 0,
	    'elder_chiroptera'  => 0,
	    'critical_mad'      => 0,
	    'critical_fox'      => 0,
	    'altair_cupid'      => 0,
	    'poison_ogre'       => 0,
	    'critical_duelist'  => 0,
	    'cowboy_duelist'    => 0,
	    'critical_avenger'  => 0,
	    'critical_patron'   => 0,
	    'wirepuller_mania'  => 0,
	    'mask_mania'        => 0],
    'c' => ['human'         => 0,
	    'mage'          => 0,
	    'necromancer'   => 0,
	    'medium'        => 0,
	    'priest'        => 0,
	    'guard'         => 0,
	    'common'        => 0,
	    'poison'        => 0,
	    'poison_cat'    => 0,
	    'pharmacist'    => 0,
	    'assassin'      => 0,
	    'mind_scanner'  => 0,
	    'jealousy'      => 0,
	    'brownie'       => 0,
	    'wizard'        => 0,
	    'doll'          => 0,
	    'escaper'       => 0,
	    'wolf'          => 0,
	    'mad'           => 0,
	    'fox'           => 0,
	    'child_fox'     => 0,
	    'depraver'      => 0,
	    'cupid'         => 0,
	    'angel'         => 0,
	    'quiz'          => 0,
	    'vampire'       => 0,
	    'chiroptera'    => 0,
	    'fairy'         => 0,
	    'ogre'          => 0,
	    'yaksa'         => 0,
	    'duelist'       => 0,
	    'avenger'       => 0,
	    'patron'        => 0,
	    'tengu'         => 0,
	    'mania'         => 0,
	    'unknown_mania' => 0],
    'd' => ['grave_guard'        => 0,
	    'revive_medium'      => 0,
	    'poison_cat'         => 0,
	    'revive_cat'         => 0,
	    'sacrifice_cat'      => 0,
	    'doom_cat'           => 0,
	    'missfire_cat'       => 0,
	    'eclipse_cat'        => 0,
	    'revive_doll_master' => 0,
	    'possessed_mad'      => 0,
	    'grave_mad'          => 0,
	    'possessed_fox'      => 0,
	    'revive_fox'         => 0,
	    'revive_mania'       => 0],
    'e' => ['possessed_wolf' => 0,
	    'possessed_mad'  => 0,
	    'possessed_fox'  => 0,
	    'exchange_angel' => 0],
    'f' => ['depraver'           => 0,
	    'fire_depraver'      => 0,
	    'sacrifice_depraver' => 0,
	    'silver_depraver'    => 0,
	    'chiroptera'         => 0,
	    'poison_chiroptera'  => 0,
	    'cursed_chiroptera'  => 0,
	    'boss_chiroptera'    => 0,
	    'elder_chiroptera'   => 0,
	    'cute_chiroptera'    => 0,
	    'doom_chiroptera'    => 0,
	    'scarlet_chiroptera' => 0,
	    'dummy_chiroptera'   => 0,
	    'fairy'              => 0,
	    'spring_fairy'       => 0,
	    'summer_fairy'       => 0,
	    'autumn_fairy'       => 0,
	    'winter_fairy'       => 0,
	    'flower_fairy'       => 0,
	    'star_fairy'         => 0,
	    'sun_fairy'          => 0,
	    'moon_fairy'         => 0,
	    'grass_fairy'        => 0,
	    'light_fairy'        => 0,
	    'dark_fairy'         => 0,
	    'shadow_fairy'       => 0,
	    'greater_fairy'      => 0,
	    'mirror_fairy'       => 0,
	    'sweet_fairy'        => 0,
	    'gender_fairy'       => 0,
	    'chill_fairy'        => 0,
	    'ice_fairy'          => 0,
	    'ogre'               => 0,
	    'orange_ogre'        => 0,
	    'indigo_ogre'        => 0,
	    'cow_ogre'           => 0,
	    'horse_ogre'         => 0,
	    'poison_ogre'        => 0,
	    'west_ogre'          => 0,
	    'east_ogre'          => 0,
	    'north_ogre'         => 0,
	    'south_ogre'         => 0,
	    'incubus_ogre'       => 0,
	    'wise_ogre'          => 0,
	    'collector_ogre'     => 0,
	    'power_ogre'         => 0,
	    'revive_ogre'        => 0,
	    'sacrifice_ogre'     => 0,
	    'yaksa'              => 0,
	    'betray_yaksa'       => 0,
	    'cursed_yaksa'       => 0,
	    'succubus_yaksa'     => 0,
	    'hariti_yaksa'       => 0,
	    'vajra_yaksa'        => 0,
	    'power_yaksa'        => 0,
	    'dowser_yaksa'       => 0,
	    'duelist'            => 0,
	    'valkyrja_duelist'   => 0,
	    'critical_duelist'   => 0,
	    'cowboy_duelist'     => 0,
	    'triangle_duelist'   => 0,
	    'triphase_duelist'   => 0,
	    'doom_duelist'       => 0,
	    'perverse_duelist'   => 0,
	    'sea_duelist'        => 0,
	    'avenger'            => 0,
	    'poison_avenger'     => 0,
	    'cursed_avenger'     => 0,
	    'critical_avenger'   => 0,
	    'trick_avenger'      => 0,
	    'foughten_avenger'   => 0,
	    'revive_avenger'     => 0,
	    'cute_avenger'       => 0,
	    'patron'             => 0,
	    'soul_patron'        => 0,
	    'sacrifice_patron'   => 0,
	    'shepherd_patron'    => 0,
	    'plumage_patron'     => 0,
	    'critical_patron'    => 0],
    'g' => ['jealousy'          => 0,
	    'divorce_jealousy'  => 0,
	    'priest_jealousy'   => 0,
	    'poison_jealousy'   => 0,
	    'miasma_jealousy'   => 0,
	    'critical_jealousy' => 0,
	    'cupid'             => 0,
	    'self_cupid'        => 0,
	    'moon_cupid'        => 0,
	    'altair_cupid'      => 0,
	    'mind_cupid'        => 0,
	    'sweet_cupid'       => 0,
	    'letter_cupid'      => 0,
	    'minstrel_cupid'    => 0,
	    'triangle_cupid'    => 0,
	    'nephila_cupid'     => 0,
	    'revive_cupid'      => 0,
	    'snow_cupid'        => 0,
	    'angel'             => 0,
	    'rose_angel'        => 0,
	    'lily_angel'        => 0,
	    'exchange_angel'    => 0,
	    'ark_angel'         => 0,
	    'sacrifice_angel'   => 0,
	    'scarlet_angel'     => 0,
	    'cursed_angel'      => 0],
    'h' => ['poison_guard'         => 0,
	    'poison'               => 0,
	    'strong_poison'        => 0,
	    'incubate_poison'      => 0,
	    'guide_poison'         => 0,
	    'snipe_poison'         => 0,
	    'chain_poison'         => 0,
	    'dummy_poison'         => 0,
	    'poison_cat'           => 0,
	    'pharmacist'           => 0,
	    'cure_pharmacist'      => 0,
	    'revive_pharmacist'    => 0,
	    'alchemy_pharmacist'   => 0,
	    'centaurus_pharmacist' => 0,
	    'poison_jealousy'      => 0,
	    'poison_doll'          => 0,
	    'poison_wolf'          => 0,
	    'resist_wolf'          => 0,
	    'poison_fox'           => 0,
	    'poison_vampire'       => 0,
	    'poison_chiroptera'    => 0,
	    'horse_ogre'           => 0,
	    'poison_ogre'          => 0,
	    'poison_avenger'       => 0,
	    'plumage_patron'       => 0],
    'i' => ['tough'             => 0,
	    'medium'            => 0,
	    'bacchus_medium'    => 0,
	    'seal_medium'       => 0,
	    'revive_medium'     => 0,
	    'eclipse_medium'    => 0,
	    'grave_guard'       => 0,
	    'ghost_common'      => 0,
	    'doom_assassin'     => 0,
	    'step_assassin'     => 0,
	    'doom_cat'          => 0,
	    'cure_pharmacist'   => 0,
	    'revive_pharmacist' => 0,
	    'jealousy'          => 0,
	    'miasma_jealousy'   => 0,
	    'brownie'           => 0,
	    'thunder_brownie'   => 0,
	    'harvest_brownie'   => 0,
	    'maple_brownie'     => 0,
	    'cursed_brownie'    => 0,
	    'soul_wizard'       => 0,
	    'pierrot_wizard'    => 0,
	    'esper_wizard'      => 0,
	    'philosophy_wizard' => 0,
	    'astray_wizard'     => 0,
	    'doom_doll'         => 0,
	    'doom_escaper'      => 0,
	    'purple_wolf'       => 0,
	    'snow_wolf'         => 0,
	    'fortitude_wolf'    => 0,
	    'thorn_wolf'        => 0,
	    'doom_wolf'         => 0,
	    'seiren_mad'        => 0,
	    'grave_mad'         => 0,
	    'snow_trap_mad'     => 0,
	    'agitate_mad'       => 0,
	    'miasma_mad'        => 0,
	    'follow_mad'        => 0,
	    'purple_fox'        => 0,
	    'snow_fox'          => 0,
	    'fortitude_fox'     => 0,
	    'doom_fox'          => 0,
	    'miasma_fox'        => 0,
	    'moon_cupid'        => 0,
	    'revive_cupid'      => 0,
	    'snow_cupid'        => 0,
	    'cursed_angel'      => 0,
	    'doom_vampire'      => 0,
	    'doom_chiroptera'   => 0,
	    'chill_fairy'       => 0,
	    'ice_fairy'         => 0,
	    'poison_ogre'       => 0,
	    'cowboy_duelist'    => 0,
	    'triphase_duelist'  => 0,
	    'doom_duelist'      => 0,
	    'perverse_duelist'  => 0,
	    'sea_duelist'       => 0,
	    'cursed_avenger'    => 0,
	    'tengu'             => 0,
	    'soul_tengu'        => 0,
	    'passion_tengu'     => 0,
	    'meteor_tengu'      => 0,
	    'involve_tengu'     => 0,
	    'priest_tengu'      => 0,
	    'eclipse_tengu'     => 0],
    'j' => ['voodoo_killer'     => 0,
	    'anti_voodoo'       => 0,
	    'cursed_brownie'    => 0,
	    'astray_wizard'     => 0,
	    'cursed_wolf'       => 0,
	    'voodoo_mad'        => 0,
	    'voodoo_fox'        => 0,
	    'cursed_fox'        => 0,
	    'cursed_angel'      => 0,
	    'cursed_chiroptera' => 0,
	    'cursed_yaksa'      => 0,
	    'cursed_avenger'    => 0],
    'k' => ['suspect'              => 0,
	    'dummy_mage'           => 0,
	    'dummy_necromancer'    => 0,
	    'eclipse_medium'       => 0,
	    'dummy_priest'         => 0,
	    'dummy_guard'          => 0,
	    'dummy_common'         => 0,
	    'dummy_poison'         => 0,
	    'eclipse_cat'          => 0,
	    'centaurus_pharmacist' => 0,
	    'eclipse_assassin'     => 0,
	    'dummy_scanner'        => 0,
	    'critical_jealousy'    => 0,
	    'maple_brownie'        => 0,
	    'astray_wizard'        => 0,
	    'silver_doll'          => 0,
	    'stargazer_escaper'    => 0,
	    'emperor_wolf'         => 0,
	    'dream_eater_mad'      => 0,
	    'immolate_mad'         => 0,
	    'immolate_fox'         => 0,
	    'critical_fox'         => 0,
	    'silver_depraver'      => 0,
	    'snow_cupid'           => 0,
	    'cursed_angel'         => 0,
	    'quiz'                 => 0,
	    'scarlet_vampire'      => 0,
	    'dummy_chiroptera'     => 0,
	    'mirror_fairy'         => 0,
	    'incubus_ogre'         => 0,
	    'succubus_yaksa'       => 0,
	    'sea_duelist'          => 0,
	    'cute_avenger'         => 0,
	    'critical_patron'      => 0,
	    'eclipse_tengu'        => 0,
	    'dummy_mania'          => 0],
    'l' => ['doll'              => 0,
	    'friend_doll'       => 0,
	    'phantom_doll'      => 0,
	    'poison_doll'       => 0,
	    'doom_doll'         => 0,
	    'revive_doll'       => 0,
	    'scarlet_doll'      => 0,
	    'silver_doll'       => 0,
	    'escaper'           => 0,
	    'psycho_escaper'    => 0,
	    'incubus_escaper'   => 0,
	    'succubus_escaper'  => 0,
	    'doom_escaper'      => 0,
	    'agent_escaper'     => 0,
	    'divine_escaper'    => 0,
	    'stargazer_escaper' => 0,
	    'emperor_wolf'      => 0,
	    'spy_mad'           => 0,
	    'immolate_mad'      => 0,
	    'immolate_fox'      => 0,
	    'critical_fox'      => 0],
    'm' => ['puppet_mage'        => 0,
	    'scarlet_doll'       => 0,
	    'silver_doll'        => 0,
	    'toy_doll_master'    => 0,
	    'blue_wolf'          => 0,
	    'scarlet_wolf'       => 0,
	    'silver_wolf'        => 0,
	    'blue_fox'           => 0,
	    'scarlet_fox'        => 0,
	    'silver_fox'         => 0,
	    'silver_depraver'    => 0,
	    'scarlet_angel'      => 0,
	    'scarlet_vampire'    => 0,
	    'scarlet_chiroptera' => 0,
	    'scarlet_mania'      => 0]
  ];

  //サブ役職制限：EASYモード
  public static $chaos_sub_role_limit_easy_list = [
    'decide', 'plague', 'counter_decide', 'dropout', 'good_luck', 'bad_luck', 'authority',
    'reduce_voter', 'upper_voter', 'downer_voter', 'critical_voter', 'random_voter', 'rebel',
    'watcher'
  ];

  //サブ役職制限：NORMALモード
  public static $chaos_sub_role_limit_normal_list = [
    'decide', 'plague', 'counter_decide', 'dropout', 'good_luck', 'bad_luck', 'authority',
    'reduce_voter', 'upper_voter', 'downer_voter', 'critical_voter', 'random_voter', 'rebel',
    'watcher', 'upper_luck', 'downer_luck', 'star', 'disfavor', 'critical_luck', 'random_luck',
    'wisp', 'black_wisp', 'spell_wisp', 'foughten_wisp', 'gold_wisp', 'tengu_spell_wisp'
  ];

  //サブ役職制限：HARDモード
  public static $chaos_sub_role_limit_hard_list = [
    'decide', 'plague', 'counter_decide', 'dropout', 'good_luck', 'bad_luck', 'authority',
    'reduce_voter', 'upper_voter', 'downer_voter', 'critical_voter', 'random_voter', 'rebel',
    'watcher', 'upper_luck', 'downer_luck', 'star', 'disfavor', 'critical_luck', 'random_luck',
    'strong_voice', 'normal_voice', 'weak_voice', 'upper_voice', 'downer_voice', 'inside_voice',
    'outside_voice', 'random_voice', 'mind_open', 'wisp', 'black_wisp', 'spell_wisp',
    'foughten_wisp', 'gold_wisp', 'tengu_spell_wisp'
  ];
}
