/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;

public class TextView
extends JFrame
implements WindowListener {
    private String userDir = JHime.USER_DIR;
    private InfoDialog infoDialog = null;
    private TextView textView;
    private JTextArea textArea;
    private JLabel statusLine = new JLabel("   line: 1");
    private String[] encoding_str = new String[]{"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
    private String pathName = null;
    private String encodingName = "UTF-8";
    private boolean changeFlag = false;
    private static int cnt = 0;
    private boolean comboFlag;
    private static HTMLTag[] BLOCK_ELEMENTS = new HTMLTag[]{new HTMLTag("\u6bb5\u843d", "p", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff11", "h1", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff12", "h2", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff13", "h3", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff14", "h4", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff15", "h5", HTMLTag.BLOCK, false, true), new HTMLTag("\u898b\u51fa\u3057\uff16", "h6", HTMLTag.BLOCK, false, true), new HTMLTag("\u4f5c\u6210\u8005\u60c5\u5831", "address", HTMLTag.BLOCK, false, true), new HTMLTag("\u6c34\u5e73\u533a\u753b\u7dda", "hr", HTMLTag.EMPTY, true, true), new HTMLTag("\u5f15\u7528\u6587", "blockquote", HTMLTag.BLOCK, true, true), new HTMLTag("\u6574\u5f62\u30c6\u30ad\u30b9\u30c8", "pre", HTMLTag.BLOCK, false, true)};
    private static HTMLTag[] INLINE_ELEMENTS = new HTMLTag[]{new HTMLTag("\u6539\u884c", "br", HTMLTag.EMPTY, false, false), new HTMLTag("\u5f37\u8abf", "em", HTMLTag.BLOCK, false, false), new HTMLTag("\u6700\u5f37\u8abf", "strong", HTMLTag.BLOCK, false, false), new HTMLTag("\u7528\u8a9e", "dfn", HTMLTag.BLOCK, false, false), new HTMLTag("\u30b3\u30fc\u30c9", "code", HTMLTag.BLOCK, false, false), new HTMLTag("\u5909\u6570\u30fb\u5f15\u6570", "var", HTMLTag.BLOCK, false, false), new HTMLTag("\u51fa\u529b\u30b5\u30f3\u30d7\u30eb", "samp", HTMLTag.BLOCK, false, false), new HTMLTag("\u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b", "kbd", HTMLTag.BLOCK, false, false), new HTMLTag("\u4e0a\u4ed8\u304d\u6587\u5b57", "sup", HTMLTag.BLOCK, false, false), new HTMLTag("\u4e0b\u4ed8\u304d\u6587\u5b57", "sub", HTMLTag.BLOCK, false, false), new HTMLTag("\u5f15\u7528\u5143", "cite", HTMLTag.BLOCK, false, false), new HTMLTag("\u5f15\u7528\u6587", "q", HTMLTag.BLOCK, false, false), new HTMLTag("\u7701\u7565\u8a9e", "abbr", HTMLTag.BLOCK, false, false), new HTMLTag("\u982d\u5b57\u8a9e", "acronym", HTMLTag.BLOCK, false, false), new HTMLTag("\u8ffd\u52a0\u6587", "ins", HTMLTag.BLOCK, false, false), new HTMLTag("\u524a\u9664\u6587", "del", HTMLTag.BLOCK, false, false)};
    private static HTMLTag[] LIST_ELEMENTS = new HTMLTag[]{new HTMLTag("\u7121\u9806\u5e8f\u30ea\u30b9\u30c8", "ul", HTMLTag.BLOCK, true, true), new HTMLTag("\u9806\u5e8f\u30ea\u30b9\u30c8", "ol", HTMLTag.BLOCK, true, true), new HTMLTag("\u30ea\u30b9\u30c8\u9805\u76ee", "li", HTMLTag.BLOCK, false, true), new HTMLTag("\u5b9a\u7fa9\u30ea\u30b9\u30c8", "dl", HTMLTag.BLOCK, true, true), new HTMLTag("\u7528\u8a9e\u9805\u76ee", "dt", HTMLTag.BLOCK, false, true), new HTMLTag("\u8aac\u660e\u9805\u76ee", "dd", HTMLTag.BLOCK, false, true)};
    private static HTMLTag[] TABLE_ELEMENTS = new HTMLTag[]{new HTMLTag("\u8868\u7d44", "table", HTMLTag.BLOCK, true, true), new HTMLTag("\u8868\u898b\u51fa\u3057", "caption", HTMLTag.BLOCK, false, true), new HTMLTag("\u884c", "tr", HTMLTag.BLOCK, true, true), new HTMLTag("\u898b\u51fa\u3057\u30bb\u30eb", "th", HTMLTag.BLOCK, true, true), new HTMLTag("\u30c7\u30fc\u30bf\u30bb\u30eb", "td", HTMLTag.BLOCK, true, true)};

    public TextView() {
        super("\u540d\u79f0\u672a\u8a2d\u5b9a");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point cPoint = ge.getCenterPoint();
        this.setDefaultCloseOperation(0);
        Container cnt = this.getContentPane();
        this.setJMenuBar(this.createMenuBar());
        Box ppan = Box.createVerticalBox();
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add("HTML", this.createHtmlToolBar2());
        tabPane.add("CSS(1)", this.createCssToolBar());
        tabPane.add("CSS(2)", this.createCssToolBar2());
        tabPane.add("RSS", this.createRssToolBar());
        ppan.add(this.createHtmlToolBar());
        ppan.add(tabPane);
        cnt.add((Component)ppan, "North");
        this.textArea = new JTextArea(25, 100);
        this.textArea.setFont(new Font("Monospaced", 0, JHime.FONT_SIZE));
        this.textArea.setTabSize(JHime.TAB_SIZE);
        this.textArea.setLineWrap(false);
        this.textArea.setMargin(new Insets(1, 5, 1, 5));
        this.textArea.getDocument().putProperty("EndOfLineStringProperty", "\r\n");
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                TextView.this.getLineAtCaret();
            }
        });
        JScrollPane pane = new JScrollPane(this.textArea);
        cnt.add((Component)pane, "Center");
        cnt.add((Component)this.statusLine, "South");
        int h = this.getPreferredSize().height + 20;
        int w = this.getPreferredSize().width + 20;
        if (h > 700) {
            h = 600;
        }
        if (w > 1000) {
            w = 800;
        }
        this.setBounds(cPoint.x - w / 2, 0, w, h);
        this.setVisible(true);
        this.textArea.requestFocusInWindow();
        this.textView = this;
        ++TextView.cnt;
        JHime.ViewVector.add(this);
        this.addDocumentChangeListener(this.textView);
        this.addWindowListener(this);
    }

    private void getLineAtCaret() {
        int pos = this.textArea.getCaretPosition();
        Element root = this.textArea.getDocument().getDefaultRootElement();
        this.statusLine.setText("   line: " + (root.getElementIndex(pos) + 1));
    }

    private void xmlValidation(boolean valid) {
        JWindow win = new JWindow(this);
        JLabel label = new JLabel("XML \u691c\u8a3c\u4e2d...", 0);
        win.getContentPane().add(label);
        int x = this.getLocationOnScreen().x;
        int y = this.getLocationOnScreen().y;
        x = x + this.getSize().width / 2 - 100;
        if (x < 0) {
            x = this.getLocationOnScreen().x;
        }
        win.setBounds(x, y, 200, 100);
        win.setVisible(true);
        if (this.infoDialog == null) {
            this.infoDialog = new InfoDialog(this);
            this.infoDialog.setDialog("XML\u691c\u8a3c", 600, 400);
        }
        this.infoDialog.xmlValidation(this.textArea.getText(), valid);
        win.dispose();
        this.infoDialog.setVisible(true);
        this.setTextFocus();
    }

    private void tagHighlight() {
        DefaultHighlighter.DefaultHighlightPainter rPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 0, 0, 127));
        DefaultHighlighter.DefaultHighlightPainter gPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(0, 255, 0, 127));
        DefaultHighlighter.DefaultHighlightPainter bPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(0, 0, 255, 127));
        this.resetHighlight();
        try {
            Highlighter hilite = this.textArea.getHighlighter();
            Document doc = this.textArea.getDocument();
            String text = doc.getText(0, doc.getLength());
            int textLength = text.length();
            int pos = 0;
            while ((pos = text.indexOf("<", pos)) >= 0) {
                int ePos = text.indexOf(">", pos + 1);
                if (ePos < 0) {
                    ePos = textLength - 1;
                }
                int len = ePos - pos + 1;
                DefaultHighlighter.DefaultHighlightPainter painter = gPainter;
                if (pos + 1 < textLength) {
                    char c = text.charAt(pos + 1);
                    if (c == '!' || c == '?') {
                        painter = rPainter;
                    } else if (ePos > 1 && (c = text.charAt(ePos - 1)) == '/') {
                        painter = bPainter;
                    }
                }
                hilite.addHighlight(pos, pos + len, painter);
                pos += len;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private void resetHighlight() {
        Highlighter hilite = this.textArea.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    private void addDocumentChangeListener(TextView view) {
        Document doc = view.textArea.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                TextView.this.changeFlag = true;
            }

            public void insertUpdate(DocumentEvent e) {
                TextView.this.changeFlag = true;
            }

            public void removeUpdate(DocumentEvent e) {
                TextView.this.changeFlag = true;
            }
        });
    }

    private void openFile() {
        if (this.changeFlag) {
            int ret = JOptionPane.showConfirmDialog(null, this.getTitle() + " \u3092\u4fdd\u5b58\u3057\u307e\u3059\u304b?", "\u4fdd\u5b58\u78ba\u8a8d", 1);
            switch (ret) {
                case 0: {
                    if (this.pathName == null) {
                        this.saveAsFile();
                        break;
                    }
                    this.saveFile();
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        JPanel pane = new JPanel(new GridLayout(this.encoding_str.length, 1));
        pane.setBorder(BorderFactory.createLoweredBevelBorder());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton[] encodingBtn = new JRadioButton[this.encoding_str.length];
        for (int i = 0; i < this.encoding_str.length; ++i) {
            encodingBtn[i] = i == 0 ? new JRadioButton(this.encoding_str[i], true) : new JRadioButton(this.encoding_str[i]);
            pane.add(encodingBtn[i]);
            bg.add(encodingBtn[i]);
        }
        JFileChooser fc = new JFileChooser(this.userDir);
        FileIOFilter fl = new FileIOFilter("html");
        fc.addChoosableFileFilter(fl);
        fc.addChoosableFileFilter(new FileIOFilter("css"));
        fc.addChoosableFileFilter(new FileIOFilter("xml"));
        fc.addChoosableFileFilter(new FileIOFilter("javascript"));
        fc.setFileFilter(fl);
        JPanel pPane = new JPanel(new BorderLayout(2, 2));
        pPane.add((Component)new JLabel(""), "West");
        pPane.add((Component)new JLabel(" "), "East");
        pPane.add((Component)new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0", 0), "North");
        pPane.add((Component)pane, "Center");
        fc.setAccessory(pPane);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            this.setUserDir(fc.getSelectedFile().getParent());
            this.pathName = fc.getSelectedFile().getPath();
            for (int i = 0; i < this.encoding_str.length; ++i) {
                if (!encodingBtn[i].isSelected()) continue;
                this.encodingName = this.encoding_str[i];
                break;
            }
            try {
                InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(this.pathName), this.encodingName);
                this.textArea.read(r, null);
                this.textArea.setTabSize(JHime.TAB_SIZE);
                this.addDocumentChangeListener(this.textView);
                this.setTitle(this.pathName);
                this.changeFlag = false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u306e\u5165\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc", 0);
            }
        }
        this.setTextFocus();
    }

    private void saveAsFile() {
        JPanel pane = new JPanel(new GridLayout(this.encoding_str.length, 1));
        pane.setBorder(BorderFactory.createLoweredBevelBorder());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton[] encodingBtn = new JRadioButton[this.encoding_str.length];
        for (int i = 0; i < this.encoding_str.length; ++i) {
            encodingBtn[i] = this.encodingName.equals(this.encoding_str[i]) ? new JRadioButton(this.encoding_str[i], true) : new JRadioButton(this.encoding_str[i]);
            pane.add(encodingBtn[i]);
            bg.add(encodingBtn[i]);
        }
        JFileChooser fc = new JFileChooser(this.userDir);
        FileIOFilter fl = new FileIOFilter("html");
        fc.addChoosableFileFilter(fl);
        fc.addChoosableFileFilter(new FileIOFilter("css"));
        fc.addChoosableFileFilter(new FileIOFilter("xml"));
        fc.setFileFilter(fl);
        JPanel pPane = new JPanel(new BorderLayout(2, 2));
        pPane.add((Component)new JLabel(""), "West");
        pPane.add((Component)new JLabel(" "), "East");
        pPane.add((Component)new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0", 0), "North");
        pPane.add((Component)pane, "Center");
        fc.setAccessory(pPane);
        int ret = fc.showSaveDialog(this);
        if (ret == 0) {
            this.setUserDir(fc.getSelectedFile().getParent());
            File f = new File(fc.getSelectedFile().getPath());
            if (f.canRead() && (ret = JOptionPane.showConfirmDialog(null, "\u30d5\u30a1\u30a4\u30eb\u304c\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u66f8\u304d\u63db\u3048\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u4e0a\u66f8\u304d\u78ba\u8a8d", 0)) == 1) {
                this.setTextFocus();
                return;
            }
            for (int i = 0; i < this.encoding_str.length; ++i) {
                if (!encodingBtn[i].isSelected()) continue;
                this.encodingName = this.encoding_str[i];
                break;
            }
            try {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(fc.getSelectedFile().getPath()), this.encodingName);
                this.textArea.write(w);
                this.pathName = fc.getSelectedFile().getPath();
                this.setTitle(this.pathName);
                this.changeFlag = false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc", 0);
            }
        }
        this.setTextFocus();
    }

    private void saveFile() {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pathName), this.encodingName);
            this.textArea.write(w);
            this.changeFlag = false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc", 0);
        }
        this.setTextFocus();
    }

    private JMenu createFileMenu() {
        JMenuItem newItem = new JMenuItem("\u65b0\u898f");
        newItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "N"));
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TextView();
            }
        });
        JMenuItem openItem = new JMenuItem("\u958b\u304f...");
        openItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "O"));
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.openFile();
            }
        });
        JMenuItem closeItem = new JMenuItem("\u9589\u3058\u308b");
        closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textView.dispatchEvent(new WindowEvent(TextView.this.textView, 201));
            }
        });
        JMenuItem saveItem = new JMenuItem("\u4fdd\u5b58");
        saveItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "S"));
        saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TextView.this.changeFlag) {
                    if (TextView.this.pathName == null) {
                        TextView.this.saveAsFile();
                    } else {
                        TextView.this.saveFile();
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JMenuItem saveAsItem = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58...");
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke("shift " + JHime.CTRL + "S"));
        saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.saveAsFile();
            }
        });
        JMenuItem quitItem = new JMenuItem("\u7d42\u4e86");
        quitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int n = JHime.ViewVector.size();
                for (int i = n - 1; i > 0; --i) {
                    TextView view = (TextView)JHime.ViewVector.get(i);
                    view.dispatchEvent(new WindowEvent(view, 201));
                }
            }
        });
        JMenu fileMenu = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        fileMenu.add(newItem);
        fileMenu.addSeparator();
        fileMenu.add(openItem);
        fileMenu.add(closeItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(quitItem);
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu("\u7de8\u96c6");
        JMenuItem cutItem = new JMenuItem("\u30ab\u30c3\u30c8");
        cutItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "X"));
        cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.cut();
                TextView.this.setTextFocus();
            }
        });
        JMenuItem copyItem = new JMenuItem("\u30b3\u30d4\u30fc");
        copyItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "C"));
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.copy();
                TextView.this.setTextFocus();
            }
        });
        JMenuItem pasteItem = new JMenuItem("\u30da\u30fc\u30b9\u30c8");
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "V"));
        pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.paste();
                TextView.this.setTextFocus();
            }
        });
        JMenuItem selectAllItem = new JMenuItem("\u3059\u3079\u3066\u3092\u9078\u629e");
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + "A"));
        selectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.selectAll();
                TextView.this.setTextFocus();
            }
        });
        JMenuItem optionItem = new JMenuItem("\u30a8\u30c7\u30a3\u30bf\u8a2d\u5b9a");
        optionItem.setAccelerator(KeyStroke.getKeyStroke(JHime.CTRL + ","));
        optionItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JHimeOptionDialog dlg = new JHimeOptionDialog(TextView.this.textView);
                if (dlg.getResult()) {
                    dlg.setOption();
                }
            }
        });
        editMenu.add(cutItem);
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.addSeparator();
        editMenu.add(selectAllItem);
        editMenu.addSeparator();
        editMenu.add(optionItem);
        return editMenu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("\u8868\u793a");
        JCheckBoxMenuItem cItem = new JCheckBoxMenuItem("\u884c\u306e\u6298\u308a\u8fd4\u3057");
        cItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    TextView.this.textArea.setLineWrap(true);
                } else {
                    TextView.this.textArea.setLineWrap(false);
                }
            }
        });
        menu.add(cItem);
        menu.addSeparator();
        JMenuItem item = new JMenuItem("XML\u7c21\u6613\u30cf\u30a4\u30e9\u30a4\u30c8\u691c\u8a3c");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.tagHighlight();
                TextView.this.setTextFocus();
            }
        });
        menu.add(item);
        item = new JMenuItem("\u30cf\u30a4\u30e9\u30a4\u30c8\u30af\u30ea\u30a2");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.resetHighlight();
                TextView.this.setTextFocus();
            }
        });
        menu.add(item);
        item = new JMenuItem("XML\u6574\u5f62\u5f0f\u691c\u8a3c");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.xmlValidation(false);
                TextView.this.setTextFocus();
            }
        });
        menu.add(item);
        item = new JMenuItem("XML\u59a5\u5f53\u6027\u691c\u8a3c");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.xmlValidation(true);
                TextView.this.setTextFocus();
            }
        });
        menu.add(item);
        return menu;
    }

    private JMenu createHtmlMenu() {
        JMenu htmlMenu = new JMenu("HTML");
        JMenuItem item = new JMenuItem("\u6c4e\u7528\u5c5e\u6027...");
        item.setActionCommand("attr");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericAttribute(TextView.this.textView);
            }
        });
        htmlMenu.add(item);
        htmlMenu.addSeparator();
        item = new JMenuItem("html\u6587\u66f8...");
        item.setActionCommand("html");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericHtml(TextView.this.textView, e.getActionCommand());
            }
        });
        htmlMenu.add(item);
        JMenu subMenu = new JMenu("html\u6587\u66f8\u30d8\u30c3\u30c0");
        item = new JMenuItem("\u30d8\u30c3\u30c0");
        item.setActionCommand("head");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30bf\u30a4\u30c8\u30eb");
        item.setActionCommand("title");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("MIME\u30bf\u30a4\u30d7...");
        item.setActionCommand("meta");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericMetaMime(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30e1\u30bf\u60c5\u5831...");
        item.setActionCommand("meta");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericMeta(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        JMenu styleMenu = new JMenu("\u30b9\u30bf\u30a4\u30eb");
        String[] style_str = new String[]{"\u5916\u90e8\u30b9\u30bf\u30a4\u30eb\u30b7\u30fc\u30c8...", "\u5185\u90e8\u30b9\u30bf\u30a4\u30eb\u30b7\u30fc\u30c8..."};
        String[] style_tag = new String[]{"link", "style"};
        for (int i = 0; i < style_str.length; ++i) {
            item = new JMenuItem(style_str[i]);
            item.setActionCommand(style_tag[i]);
            styleMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericStyle(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(styleMenu);
        JMenu scriptMenu = new JMenu("\u30b9\u30af\u30ea\u30d7\u30c8");
        String[] script_str = new String[]{"\u30b9\u30af\u30ea\u30d7\u30c8\u6307\u5b9a...", "\u975e\u30b9\u30af\u30ea\u30d7\u30c8\u6307\u5b9a"};
        String[] script_tag = new String[]{"script", "noscript"};
        for (int i = 0; i < script_str.length; ++i) {
            item = new JMenuItem(script_str[i]);
            item.setActionCommand(script_tag[i]);
            scriptMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericScript(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(scriptMenu);
        htmlMenu.add(subMenu);
        item = new JMenuItem("html\u6587\u66f8\u30dc\u30c7\u30a3");
        item.setActionCommand("body");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        htmlMenu.add(item);
        htmlMenu.addSeparator();
        subMenu = new JMenu("\u30d6\u30ed\u30c3\u30af\u8981\u7d20");
        JMenu headingMenu = new JMenu("\u898b\u51fa\u3057");
        String[] heading_str = new String[]{"\u898b\u51fa\u3057\uff11", "\u898b\u51fa\u3057\uff12", "\u898b\u51fa\u3057\uff13", "\u898b\u51fa\u3057\uff14", "\u898b\u51fa\u3057\uff15", "\u898b\u51fa\u3057\uff16"};
        String[] heading_tag = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        for (int i = 0; i < heading_str.length; ++i) {
            item = new JMenuItem(heading_str[i]);
            item.setActionCommand(heading_tag[i]);
            headingMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
                }
            });
        }
        subMenu.add(headingMenu);
        item = new JMenuItem("\u6bb5\u843d");
        item.setActionCommand("p");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4f5c\u6210\u8005\u60c5\u5831");
        item.setActionCommand("address");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u6c34\u5e73\u533a\u753b\u7dda");
        item.setActionCommand("hr");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertSimpleTag(TextView.this.textView, e.getActionCommand(), true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5f15\u7528\u6587...");
        item.setActionCommand("blockquote");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericBlockquote(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u6574\u5f62\u30c6\u30ad\u30b9\u30c8");
        item.setActionCommand("pre");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        subMenu = new JMenu("\u30a4\u30f3\u30e9\u30a4\u30f3\u8981\u7d20");
        item = new JMenuItem("\u6539\u884c");
        item.setActionCommand("br");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertSimpleTag(TextView.this.textView, e.getActionCommand(), false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5f37\u8abf");
        item.setActionCommand("em");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u6700\u5f37\u8abf");
        item.setActionCommand("strong");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u7528\u8a9e");
        item.setActionCommand("dfn");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30b3\u30fc\u30c9");
        item.setActionCommand("code");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5909\u6570\u30fb\u5f15\u6570");
        item.setActionCommand("var");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u51fa\u529b\u30b5\u30f3\u30d7\u30eb");
        item.setActionCommand("samp");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b");
        item.setActionCommand("kbd");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4e0a\u4ed8\u304d\u6587\u5b57");
        item.setActionCommand("sup");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4e0b\u4ed8\u304d\u6587\u5b57");
        item.setActionCommand("sub");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5f15\u7528\u5143");
        item.setActionCommand("cite");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5f15\u7528\u6587");
        item.setActionCommand("q");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u7701\u7565\u8a9e");
        item.setActionCommand("abbr");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u982d\u5b57\u8a9e");
        item.setActionCommand("acronym");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u8ffd\u52a0\u6587...");
        item.setActionCommand("ins");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericInsDel(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u524a\u9664\u6587...");
        item.setActionCommand("del");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericInsDel(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        subMenu = new JMenu("\u7b87\u6761\u66f8\u304d");
        item = new JMenuItem("\u7121\u9806\u5e8f\u30ea\u30b9\u30c8");
        item.setActionCommand("ul");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u9806\u5e8f\u30ea\u30b9\u30c8");
        item.setActionCommand("ol");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30ea\u30b9\u30c8\u9805\u76ee");
        item.setActionCommand("li");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5b9a\u7fa9\u30ea\u30b9\u30c8");
        item.setActionCommand("dl");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u7528\u8a9e\u9805\u76ee");
        item.setActionCommand("dt");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u8aac\u660e\u9805\u76ee");
        item.setActionCommand("dd");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        subMenu = new JMenu("\u30c6\u30fc\u30d6\u30eb");
        item = new JMenuItem("\u8868\u7d44...");
        item.setActionCommand("table");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericTable(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u8868\u898b\u51fa\u3057");
        item.setActionCommand("caption");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u884c");
        item.setActionCommand("tr");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u898b\u51fa\u3057\u30bb\u30eb...");
        item.setActionCommand("th");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericTableCell(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30c7\u30fc\u30bf\u30bb\u30eb...");
        item.setActionCommand("td");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericTableCell(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        item = new JMenuItem("\u30ea\u30f3\u30af...");
        item.setActionCommand("a");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericA(TextView.this.textView, e.getActionCommand());
            }
        });
        htmlMenu.add(item);
        item = new JMenuItem("\u753b\u50cf...");
        item.setActionCommand("img");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericImg(TextView.this.textView, e.getActionCommand());
            }
        });
        htmlMenu.add(item);
        subMenu = new JMenu("\u7d44\u8fbc\u307f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8");
        item = new JMenuItem("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8...");
        item.setActionCommand("object");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericObject(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30d1\u30e9\u30e1\u30fc\u30bf...");
        item.setActionCommand("param");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericParam(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        subMenu = new JMenu("\u30d5\u30a9\u30fc\u30e0");
        item = new JMenuItem("\u30d5\u30a9\u30fc\u30e0...");
        item.setActionCommand("form");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericForm(TextView.this.textView, e.getActionCommand());
            }
        });
        subMenu.add(item);
        JMenu buttonMenu = new JMenu("\u30dc\u30bf\u30f3");
        String[] button_str = new String[]{"\u9001\u4fe1\u30dc\u30bf\u30f3...", "\u30ea\u30bb\u30c3\u30c8\u30dc\u30bf\u30f3...", "\u6c4e\u7528\u30dc\u30bf\u30f3...", "\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9...", "\u30e9\u30b8\u30aa\u30dc\u30bf\u30f3...", "\u753b\u50cf\u30dc\u30bf\u30f3..."};
        String[] button_tag = new String[]{"submit", "reset", "button", "checkbox", "radio", "image"};
        for (int i = 0; i < button_str.length; ++i) {
            item = new JMenuItem(button_str[i]);
            item.setActionCommand(button_tag[i]);
            buttonMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericInput(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(buttonMenu);
        JMenu textMenu = new JMenu("\u30d5\u30a3\u30fc\u30eb\u30c9");
        String[] text_str = new String[]{"\u30c6\u30ad\u30b9\u30c8\u30d5\u30a3\u30fc\u30eb\u30c9...", "\u30d1\u30b9\u30ef\u30fc\u30c9\u30d5\u30a3\u30fc\u30eb\u30c9...", "\u96a0\u3057\u30d5\u30a3\u30fc\u30eb\u30c9...", "\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2...", "\u30d5\u30a1\u30a4\u30eb\u9078\u629e..."};
        String[] text_tag = new String[]{"text", "password", "hidden", "textarea", "file"};
        for (int i = 0; i < text_str.length; ++i) {
            item = new JMenuItem(text_str[i]);
            item.setActionCommand(text_tag[i]);
            textMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericInput(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(textMenu);
        JMenu selectMenu = new JMenu("\u9078\u629e\u30dc\u30c3\u30af\u30b9");
        String[] select_str = new String[]{"\u9078\u629e\u30dc\u30c3\u30af\u30b9...", "\u9078\u629e\u9805\u76ee..."};
        String[] select_tag = new String[]{"select", "option"};
        for (int i = 0; i < select_str.length; ++i) {
            item = new JMenuItem(select_str[i]);
            item.setActionCommand(select_tag[i]);
            selectMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericSelectOption(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(selectMenu);
        item = new JMenuItem("\u30e9\u30d9\u30eb...");
        item.setActionCommand("label");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericLabel(TextView.this.textView);
            }
        });
        subMenu.add(item);
        JMenu fieldsetMenu = new JMenu("\u30b0\u30eb\u30fc\u30d7");
        String[] fieldset_str = new String[]{"\u30d5\u30a3\u30fc\u30eb\u30c9\u30bb\u30c3\u30c8", "\u30b0\u30eb\u30fc\u30d7\u30e9\u30d9\u30eb"};
        String[] fieldset_tag = new String[]{"fieldset", "legend"};
        for (int i = 0; i < fieldset_str.length; ++i) {
            item = new JMenuItem(fieldset_str[i]);
            item.setActionCommand(fieldset_tag[i]);
            fieldsetMenu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLAction.genericFormGroup(TextView.this.textView, e.getActionCommand());
                }
            });
        }
        subMenu.add(fieldsetMenu);
        htmlMenu.add(subMenu);
        subMenu = new JMenu("\u30b3\u30f3\u30c6\u30ca");
        item = new JMenuItem("\u30d6\u30ed\u30c3\u30af\u30b3\u30f3\u30c6\u30ca");
        item.setActionCommand("div");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30a4\u30f3\u30e9\u30a4\u30f3\u30b3\u30f3\u30c6\u30ca");
        item.setActionCommand("span");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        subMenu.add(item);
        htmlMenu.add(subMenu);
        return htmlMenu;
    }

    private JMenu createCssMenu() {
        JMenu cssMenu = new JMenu("CSS");
        JMenuItem item = new JMenuItem("\u30bb\u30ec\u30af\u30bf...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericSelector(TextView.this.textView);
            }
        });
        cssMenu.add(item);
        JMenu subMenu = new JMenu("\uff20\u898f\u5247");
        item = new JMenuItem("@charset...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericAtCharset(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("@import...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericAtImport(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("@media...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericAtMedia(TextView.this.textView);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        item = new JMenuItem("\u30d6\u30ed\u30c3\u30af");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textView.insert(" {\n", "}\n");
            }
        });
        cssMenu.add(item);
        cssMenu.addSeparator();
        subMenu = new JMenu("\u8272\u30fb\u80cc\u666f");
        item = new JMenuItem("\u524d\u666f\u8272...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericColor(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u80cc\u666f\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericBackground(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u80cc\u666f\u4e00\u62ec\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericBackground(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u30d5\u30a9\u30f3\u30c8");
        item = new JMenuItem("\u30d5\u30a9\u30f3\u30c8\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericFont(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30d5\u30a9\u30f3\u30c8\u4e00\u62ec\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericFont(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        item = new JMenuItem("\u30c6\u30ad\u30b9\u30c8...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericText(TextView.this.textView);
            }
        });
        cssMenu.add(item);
        subMenu = new JMenu("\u30dc\u30c3\u30af\u30b9\u30e2\u30c7\u30eb");
        item = new JMenuItem("\u30de\u30fc\u30b8\u30f3\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericMargin(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30de\u30fc\u30b8\u30f3\u4e00\u62ec\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericMargin(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        subMenu.addSeparator();
        item = new JMenuItem("\u30d1\u30c7\u30a3\u30f3\u30b0\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericPadding(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30d1\u30c7\u30a3\u30f3\u30b0\u4e00\u62ec\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericPadding(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        subMenu.addSeparator();
        item = new JMenuItem("\u56db\u89d2\u30dc\u30fc\u30c0\u30fc\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericBorder(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30dc\u30fc\u30c0\u30fc\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericBorder(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u8996\u899a\u8868\u73fe");
        item = new JMenuItem("\u5185\u5bb9\u9818\u57df\u5e45...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericWidth(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5185\u5bb9\u9818\u57df\u9ad8\u3055...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericWidth(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u884c\u306e\u9ad8\u3055...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericLineHeight(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u5782\u76f4\u4f4d\u7f6e\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericVerticalAlign(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30dc\u30c3\u30af\u30b9\u751f\u6210...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericDisplay(TextView.this.textView);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u8996\u899a\u6574\u5f62");
        item = new JMenuItem("\u914d\u7f6e\u65b9\u6cd5...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericPosition(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4f4d\u7f6e\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericBoxPosition(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30d5\u30ed\u30fc\u30c8\u914d\u7f6e...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericFloat(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30d5\u30ed\u30fc\u30c8\u5236\u5fa1...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericClear(TextView.this.textView);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u8996\u899a\u52b9\u679c");
        item = new JMenuItem("\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u5236\u5fa1...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericOverflow(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u53ef\u8996\u5236\u5fa1...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericVisibility(TextView.this.textView);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u30ea\u30b9\u30c8");
        item = new JMenuItem("\u30ea\u30b9\u30c8\u500b\u5225\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericList(TextView.this.textView, false);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30ea\u30b9\u30c8\u4e00\u62ec\u6307\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericList(TextView.this.textView, true);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        subMenu = new JMenu("\u30c6\u30fc\u30d6\u30eb");
        item = new JMenuItem("\u30ad\u30e3\u30d7\u30b7\u30e7\u30f3\u4f4d\u7f6e...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericCaptionSide(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u30c6\u30fc\u30d6\u30eb\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericTable(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u7a7a\u30bb\u30eb\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericEmptyCell(TextView.this.textView);
            }
        });
        subMenu.add(item);
        cssMenu.add(subMenu);
        return cssMenu;
    }

    private JMenu createRssMenu() {
        JMenu menu = new JMenu("RSS");
        JMenu subMenu = new JMenu("\u30c1\u30e3\u30cd\u30eb\u8a2d\u5b9a");
        JMenuItem item = new JMenuItem("\u5fc5\u9808\u8981\u7d20\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssChannelBasicText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4efb\u610f\u8981\u7d20\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssChannelOptionalText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("itunes\u8981\u7d20\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssChannelItunesText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        menu.add(subMenu);
        menu.addSeparator();
        subMenu = new JMenu("\u9805\u76ee\u8a2d\u5b9a");
        item = new JMenuItem("item\u8981\u7d20");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssItemText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("\u4efb\u610f\u8981\u7d20\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssItemOptionalText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        item = new JMenuItem("itunes\u8981\u7d20\u8a2d\u5b9a...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSAction.genericRssItemItunesText(TextView.this.textView);
            }
        });
        subMenu.add(item);
        menu.add(subMenu);
        return menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createHtmlMenu());
        menuBar.add(this.createCssMenu());
        menuBar.add(this.createRssMenu());
        JMenu menu = new JMenu("\u30d8\u30eb\u30d7");
        JMenuItem item = new JMenuItem("\u60c5\u5831");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] msg = new String[]{"JHime version 0.4a (XHTML 1.0 & CSS 2.1 & RSS)", "    XML Well-formed Validator & DTD Validator", " ", "    Copyright (C) HIROTAKA YAMASHITA.", "    2008-06-07. All Rights Reserved.", " ", "    Java version:" + System.getProperty("java.version"), " "};
                JOptionPane help = new JOptionPane();
                JOptionPane.showMessageDialog(null, msg, "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831", 1);
            }
        });
        menu.add(item);
        menuBar.add(menu);
        return menuBar;
    }

    private JToolBar createHtmlToolBar() {
        JPanel newPane = new JPanel(new BorderLayout(0, 2));
        JButton newBtn = new JButton(new ImageIcon("icons/new.gif"));
        newBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TextView();
            }
        });
        JLabel newLabel = new JLabel("\u65b0\u898f", 0);
        newLabel.setFont(new Font("Monospaced", 0, 10));
        newPane.add((Component)newBtn, "Center");
        newPane.add((Component)newLabel, "South");
        newPane.setMaximumSize(newPane.getPreferredSize());
        JPanel openPane = new JPanel(new BorderLayout(0, 2));
        JButton openBtn = new JButton(new ImageIcon("icons/open.gif"));
        openBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.openFile();
            }
        });
        JLabel openLabel = new JLabel("\u958b\u304f", 0);
        openLabel.setFont(new Font("Monospaced", 0, 10));
        openPane.add((Component)openBtn, "Center");
        openPane.add((Component)openLabel, "South");
        openPane.setMaximumSize(openPane.getPreferredSize());
        JPanel savePane = new JPanel(new BorderLayout(0, 2));
        JButton saveBtn = new JButton(new ImageIcon("icons/save.gif"));
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TextView.this.changeFlag) {
                    if (TextView.this.pathName == null) {
                        TextView.this.saveAsFile();
                    } else {
                        TextView.this.saveFile();
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel saveLabel = new JLabel("\u4fdd\u5b58", 0);
        saveLabel.setFont(new Font("Monospaced", 0, 10));
        savePane.add((Component)saveBtn, "Center");
        savePane.add((Component)saveLabel, "South");
        savePane.setMaximumSize(savePane.getPreferredSize());
        JPanel cutPane = new JPanel(new BorderLayout(0, 2));
        JButton cutBtn = new JButton(new ImageIcon("icons/cut.gif"));
        cutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.cut();
                TextView.this.setTextFocus();
            }
        });
        JLabel cutLabel = new JLabel("\u30ab\u30c3\u30c8", 0);
        cutLabel.setFont(new Font("Monospaced", 0, 10));
        cutPane.add((Component)cutBtn, "Center");
        cutPane.add((Component)cutLabel, "South");
        cutPane.setMaximumSize(cutPane.getPreferredSize());
        JPanel copyPane = new JPanel(new BorderLayout(0, 2));
        JButton copyBtn = new JButton(new ImageIcon("icons/copy.gif"));
        copyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.copy();
                TextView.this.setTextFocus();
            }
        });
        JLabel copyLabel = new JLabel("\u30b3\u30d4\u30fc", 0);
        copyLabel.setFont(new Font("Monospaced", 0, 10));
        copyPane.add((Component)copyBtn, "Center");
        copyPane.add((Component)copyLabel, "South");
        copyPane.setMaximumSize(copyPane.getPreferredSize());
        JPanel pastePane = new JPanel(new BorderLayout(0, 2));
        JButton pasteBtn = new JButton(new ImageIcon("icons/paste.gif"));
        pasteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textArea.paste();
                TextView.this.setTextFocus();
            }
        });
        JLabel pasteLabel = new JLabel("\u30da\u30fc\u30b9\u30c8", 0);
        pasteLabel.setFont(new Font("Monospaced", 0, 10));
        pastePane.add((Component)pasteBtn, "Center");
        pastePane.add((Component)pasteLabel, "South");
        pastePane.setMaximumSize(pastePane.getPreferredSize());
        JPanel htmlAttrPane = new JPanel(new BorderLayout(0, 2));
        JButton attrBtn = new JButton(new ImageIcon("icons/attr.gif"));
        attrBtn.setActionCommand("attr");
        attrBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericAttribute(TextView.this.textView);
                TextView.this.setTextFocus();
            }
        });
        JLabel attrLabel = new JLabel("\u5c5e\u6027", 0);
        attrLabel.setFont(new Font("Monospaced", 0, 10));
        htmlAttrPane.add((Component)attrBtn, "Center");
        htmlAttrPane.add((Component)attrLabel, "South");
        htmlAttrPane.setMaximumSize(htmlAttrPane.getPreferredSize());
        JPanel htmlLinkPane = new JPanel(new BorderLayout(0, 2));
        JButton linkBtn = new JButton(new ImageIcon("icons/link.gif"));
        linkBtn.setActionCommand("a");
        linkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericA(TextView.this.textView, e.getActionCommand());
            }
        });
        JLabel linkLabel = new JLabel("\u30ea\u30f3\u30af", 0);
        linkLabel.setFont(new Font("Monospaced", 0, 10));
        htmlLinkPane.add((Component)linkBtn, "Center");
        htmlLinkPane.add((Component)linkLabel, "South");
        htmlLinkPane.setMaximumSize(htmlLinkPane.getPreferredSize());
        JPanel htmlImgPane = new JPanel(new BorderLayout(0, 2));
        JButton imgBtn = new JButton(new ImageIcon("icons/img.gif"));
        imgBtn.setActionCommand("img");
        imgBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.genericImg(TextView.this.textView, e.getActionCommand());
            }
        });
        JLabel imgLabel = new JLabel("\u753b\u50cf", 0);
        imgLabel.setFont(new Font("Monospaced", 0, 10));
        htmlImgPane.add((Component)imgBtn, "Center");
        htmlImgPane.add((Component)imgLabel, "South");
        htmlImgPane.setMaximumSize(htmlImgPane.getPreferredSize());
        JPanel htmlDivPane = new JPanel(new BorderLayout(0, 2));
        JButton divBtn = new JButton(new ImageIcon("icons/div.gif"));
        divBtn.setActionCommand("div");
        divBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), true, true);
            }
        });
        JLabel divLabel = new JLabel("DIV", 0);
        divLabel.setFont(new Font("Monospaced", 0, 10));
        htmlDivPane.add((Component)divBtn, "Center");
        htmlDivPane.add((Component)divLabel, "South");
        htmlDivPane.setMaximumSize(htmlDivPane.getPreferredSize());
        JPanel htmlSpanPane = new JPanel(new BorderLayout(0, 2));
        JButton spanBtn = new JButton(new ImageIcon("icons/span.gif"));
        spanBtn.setActionCommand("span");
        spanBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLAction.insertBlockTag(TextView.this.textView, e.getActionCommand(), false, false);
            }
        });
        JLabel spanLabel = new JLabel("SPAN", 0);
        spanLabel.setFont(new Font("Monospaced", 0, 10));
        htmlSpanPane.add((Component)spanBtn, "Center");
        htmlSpanPane.add((Component)spanLabel, "South");
        htmlSpanPane.setMaximumSize(htmlSpanPane.getPreferredSize());
        JPanel selectPane = new JPanel(new BorderLayout(0, 2));
        JButton selectBtn = new JButton(new ImageIcon("icons/cssSelect.gif"));
        selectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSSAction.genericSelector(TextView.this.textView);
            }
        });
        JLabel selectLabel = new JLabel("\u30bb\u30ec\u30af\u30bf", 0);
        selectLabel.setFont(new Font("Monospaced", 0, 10));
        selectPane.add((Component)selectBtn, "Center");
        selectPane.add((Component)selectLabel, "South");
        selectPane.setMaximumSize(selectPane.getPreferredSize());
        JPanel blockPane = new JPanel(new BorderLayout(0, 2));
        JButton blockBtn = new JButton(new ImageIcon("icons/cssBlock.gif"));
        blockBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextView.this.textView.insert(" {\n", "}\n");
            }
        });
        JLabel blockLabel = new JLabel("\u30d6\u30ed\u30c3\u30af", 0);
        blockLabel.setFont(new Font("Monospaced", 0, 10));
        blockPane.add((Component)blockBtn, "Center");
        blockPane.add((Component)blockLabel, "South");
        blockPane.setMaximumSize(blockPane.getPreferredSize());
        JToolBar toolBar = new JToolBar("\u6a19\u6e96");
        toolBar.add(newPane);
        toolBar.add(openPane);
        toolBar.add(savePane);
        toolBar.addSeparator(new Dimension(10, 10));
        toolBar.add(cutPane);
        toolBar.add(copyPane);
        toolBar.add(pastePane);
        toolBar.addSeparator(new Dimension(10, 10));
        toolBar.add(htmlAttrPane);
        toolBar.add(htmlLinkPane);
        toolBar.add(htmlImgPane);
        toolBar.add(htmlDivPane);
        toolBar.add(htmlSpanPane);
        toolBar.addSeparator(new Dimension(10, 10));
        toolBar.add(selectPane);
        toolBar.add(blockPane);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
        return toolBar;
    }

    private JToolBar createHtmlToolBar2() {
        JPanel htmlBlockPane = new JPanel(new BorderLayout(0, 1));
        JComboBox<String> htmlBlockBox = new JComboBox<String>(this.getElementsLabel(BLOCK_ELEMENTS));
        htmlBlockBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                String label = (String)((JComboBox)e.getSource()).getSelectedItem();
                HTMLTag command = TextView.this.getElementsTag(label, BLOCK_ELEMENTS);
                if (command.getName().equals("blockquote")) {
                    HTMLAction.genericBlockquote(TextView.this.textView, command.getName());
                } else if (command.getType()) {
                    HTMLAction.insertBlockTag(TextView.this.textView, command.getName(), command.getStartBr(), command.getEndBr());
                } else {
                    HTMLAction.insertSimpleTag(TextView.this.textView, command.getName(), command.getStartBr());
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel htmlBlockLabel = new JLabel("\u30d6\u30ed\u30c3\u30af\u8981\u7d20", 0);
        htmlBlockLabel.setFont(new Font("Monospaced", 0, 10));
        htmlBlockPane.add(htmlBlockBox, "Center");
        htmlBlockPane.add((Component)htmlBlockLabel, "South");
        htmlBlockPane.setMaximumSize(htmlBlockPane.getPreferredSize());
        JPanel htmlInlinePane = new JPanel(new BorderLayout(0, 1));
        JComboBox<String> htmlInlineBox = new JComboBox<String>(this.getElementsLabel(INLINE_ELEMENTS));
        htmlInlineBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                String label = (String)((JComboBox)e.getSource()).getSelectedItem();
                HTMLTag command = TextView.this.getElementsTag(label, INLINE_ELEMENTS);
                if (command.getName().equals("ins") || command.getName().equals("del")) {
                    HTMLAction.genericInsDel(TextView.this.textView, command.getName());
                } else if (command.getType()) {
                    HTMLAction.insertBlockTag(TextView.this.textView, command.getName(), command.getStartBr(), command.getEndBr());
                } else {
                    HTMLAction.insertSimpleTag(TextView.this.textView, command.getName(), command.getStartBr());
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel htmlInlineLabel = new JLabel("\u30a4\u30f3\u30e9\u30a4\u30f3\u8981\u7d20", 0);
        htmlInlineLabel.setFont(new Font("Monospaced", 0, 10));
        htmlInlinePane.add(htmlInlineBox, "Center");
        htmlInlinePane.add((Component)htmlInlineLabel, "South");
        htmlInlinePane.setMaximumSize(htmlInlinePane.getPreferredSize());
        JPanel htmlListPane = new JPanel(new BorderLayout(0, 1));
        JComboBox<String> htmlListBox = new JComboBox<String>(this.getElementsLabel(LIST_ELEMENTS));
        htmlListBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                String label = (String)((JComboBox)e.getSource()).getSelectedItem();
                HTMLTag command = TextView.this.getElementsTag(label, LIST_ELEMENTS);
                if (command.getType()) {
                    HTMLAction.insertBlockTag(TextView.this.textView, command.getName(), command.getStartBr(), command.getEndBr());
                } else {
                    HTMLAction.insertSimpleTag(TextView.this.textView, command.getName(), command.getStartBr());
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel htmlListLabel = new JLabel("\u7b87\u6761\u66f8\u304d", 0);
        htmlListLabel.setFont(new Font("Monospaced", 0, 10));
        htmlListPane.add(htmlListBox, "Center");
        htmlListPane.add((Component)htmlListLabel, "South");
        htmlListPane.setMaximumSize(htmlListPane.getPreferredSize());
        JPanel htmlTablePane = new JPanel(new BorderLayout(0, 1));
        JComboBox<String> htmlTableBox = new JComboBox<String>(this.getElementsLabel(TABLE_ELEMENTS));
        htmlTableBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                String label = (String)((JComboBox)e.getSource()).getSelectedItem();
                HTMLTag command = TextView.this.getElementsTag(label, TABLE_ELEMENTS);
                if (command.getName().equals("table")) {
                    HTMLAction.genericTable(TextView.this.textView, command.getName());
                } else if (command.getName().equals("th") || command.getName().equals("td")) {
                    HTMLAction.genericTableCell(TextView.this.textView, command.getName());
                } else if (command.getType()) {
                    HTMLAction.insertBlockTag(TextView.this.textView, command.getName(), command.getStartBr(), command.getEndBr());
                } else {
                    HTMLAction.insertSimpleTag(TextView.this.textView, command.getName(), command.getStartBr());
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel htmlTableLabel = new JLabel("\u30c6\u30fc\u30d6\u30eb", 0);
        htmlTableLabel.setFont(new Font("Monospaced", 0, 10));
        htmlTablePane.add(htmlTableBox, "Center");
        htmlTablePane.add((Component)htmlTableLabel, "South");
        htmlTablePane.setMaximumSize(htmlTablePane.getPreferredSize());
        JToolBar toolBar = new JToolBar("HTML");
        toolBar.add(htmlInlinePane);
        toolBar.add(htmlBlockPane);
        toolBar.add(htmlListPane);
        toolBar.add(htmlTablePane);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
        return toolBar;
    }

    private JToolBar createCssToolBar() {
        JPanel cssColorPane = new JPanel(new BorderLayout(0, 1));
        String[] cssColorStr = new String[]{"\u524d\u666f\u8272", "\u80cc\u666f\u500b\u5225\u6307\u5b9a", "\u80cc\u666f\u4e00\u62ec\u6307\u5b9a"};
        JComboBox<String> cssColorBox = new JComboBox<String>(cssColorStr);
        cssColorBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericColor(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        CSSAction.genericBackground(TextView.this.textView, false);
                        break;
                    }
                    case 2: {
                        CSSAction.genericBackground(TextView.this.textView, true);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssColorLabel = new JLabel("\u8272\u30fb\u80cc\u666f", 0);
        cssColorLabel.setFont(new Font("Monospaced", 0, 10));
        cssColorPane.add(cssColorBox, "Center");
        cssColorPane.add((Component)cssColorLabel, "South");
        cssColorPane.setMaximumSize(cssColorPane.getPreferredSize());
        JPanel cssFontPane = new JPanel(new BorderLayout(0, 1));
        String[] cssFontStr = new String[]{"\u30d5\u30a9\u30f3\u30c8\u500b\u5225\u6307\u5b9a", "\u30d5\u30a9\u30f3\u30c8\u4e00\u62ec\u6307\u5b9a", "\u30c6\u30ad\u30b9\u30c8"};
        JComboBox<String> cssFontBox = new JComboBox<String>(cssFontStr);
        cssFontBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericFont(TextView.this.textView, false);
                        break;
                    }
                    case 1: {
                        CSSAction.genericFont(TextView.this.textView, true);
                        break;
                    }
                    case 2: {
                        CSSAction.genericText(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssFontLabel = new JLabel("\u30d5\u30a9\u30f3\u30c8\u30fb\u30c6\u30ad\u30b9\u30c8", 0);
        cssFontLabel.setFont(new Font("Monospaced", 0, 10));
        cssFontPane.add(cssFontBox, "Center");
        cssFontPane.add((Component)cssFontLabel, "South");
        cssFontPane.setMaximumSize(cssFontPane.getPreferredSize());
        JPanel cssBoxPane = new JPanel(new BorderLayout(0, 1));
        String[] cssBoxStr = new String[]{"\u30de\u30fc\u30b8\u30f3\u500b\u5225\u6307\u5b9a", "\u30de\u30fc\u30b8\u30f3\u4e00\u62ec\u6307\u5b9a", "\u30d1\u30c7\u30a3\u30f3\u30b0\u500b\u5225\u6307\u5b9a", "\u30d1\u30c7\u30a3\u30f3\u30b0\u4e00\u62ec\u6307\u5b9a", "\u56db\u89d2\u30dc\u30fc\u30c0\u30fc\u6307\u5b9a", "\u30dc\u30fc\u30c0\u30fc\u500b\u5225\u6307\u5b9a"};
        JComboBox<String> cssBoxBox = new JComboBox<String>(cssBoxStr);
        cssBoxBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericMargin(TextView.this.textView, false);
                        break;
                    }
                    case 1: {
                        CSSAction.genericMargin(TextView.this.textView, true);
                        break;
                    }
                    case 2: {
                        CSSAction.genericPadding(TextView.this.textView, false);
                        break;
                    }
                    case 3: {
                        CSSAction.genericPadding(TextView.this.textView, true);
                        break;
                    }
                    case 4: {
                        CSSAction.genericBorder(TextView.this.textView, true);
                        break;
                    }
                    case 5: {
                        CSSAction.genericBorder(TextView.this.textView, false);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssBoxLabel = new JLabel("\u30dc\u30c3\u30af\u30b9\u30e2\u30c7\u30eb", 0);
        cssBoxLabel.setFont(new Font("Monospaced", 0, 10));
        cssBoxPane.add(cssBoxBox, "Center");
        cssBoxPane.add((Component)cssBoxLabel, "South");
        cssBoxPane.setMaximumSize(cssBoxPane.getPreferredSize());
        JPanel cssVisualPane = new JPanel(new BorderLayout(0, 1));
        String[] cssVisualStr = new String[]{"\u5185\u5bb9\u9818\u57df\u5e45", "\u5185\u5bb9\u9818\u57df\u9ad8\u3055", "\u884c\u306e\u9ad8\u3055", "\u5782\u76f4\u4f4d\u7f6e\u6307\u5b9a", "\u30dc\u30c3\u30af\u30b9\u751f\u6210"};
        JComboBox<String> cssVisualBox = new JComboBox<String>(cssVisualStr);
        cssVisualBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericWidth(TextView.this.textView, true);
                        break;
                    }
                    case 1: {
                        CSSAction.genericWidth(TextView.this.textView, false);
                        break;
                    }
                    case 2: {
                        CSSAction.genericLineHeight(TextView.this.textView);
                        break;
                    }
                    case 3: {
                        CSSAction.genericVerticalAlign(TextView.this.textView);
                        break;
                    }
                    case 4: {
                        CSSAction.genericDisplay(TextView.this.textView);
                        break;
                    }
                    case 5: {
                        CSSAction.genericPosition(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssVisualLabel = new JLabel("\u8996\u899a\u8868\u73fe", 0);
        cssVisualLabel.setFont(new Font("Monospaced", 0, 10));
        cssVisualPane.add(cssVisualBox, "Center");
        cssVisualPane.add((Component)cssVisualLabel, "South");
        cssVisualPane.setMaximumSize(cssVisualPane.getPreferredSize());
        JToolBar toolBar = new JToolBar("CSS");
        toolBar.add(cssColorPane);
        toolBar.add(cssFontPane);
        toolBar.add(cssBoxPane);
        toolBar.add(cssVisualPane);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
        return toolBar;
    }

    private JToolBar createCssToolBar2() {
        JPanel cssVisualFormatPane = new JPanel(new BorderLayout(0, 1));
        String[] cssVisualFormatStr = new String[]{"\u914d\u7f6e\u65b9\u6cd5", "\u4f4d\u7f6e\u6307\u5b9a", "\u30d5\u30ed\u30fc\u30c8\u914d\u7f6e", "\u30d5\u30ed\u30fc\u30c8\u5236\u5fa1"};
        JComboBox<String> cssVisualFormatBox = new JComboBox<String>(cssVisualFormatStr);
        cssVisualFormatBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericPosition(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        CSSAction.genericBoxPosition(TextView.this.textView);
                        break;
                    }
                    case 2: {
                        CSSAction.genericFloat(TextView.this.textView);
                        break;
                    }
                    case 3: {
                        CSSAction.genericClear(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssVisualFormatLabel = new JLabel("\u8996\u899a\u6574\u5f62", 0);
        cssVisualFormatLabel.setFont(new Font("Monospaced", 0, 10));
        cssVisualFormatPane.add(cssVisualFormatBox, "Center");
        cssVisualFormatPane.add((Component)cssVisualFormatLabel, "South");
        cssVisualFormatPane.setMaximumSize(cssVisualFormatPane.getPreferredSize());
        JPanel cssVisualEffectPane = new JPanel(new BorderLayout(0, 1));
        String[] cssVisualEffectStr = new String[]{"\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u5236\u5fa1", "\u53ef\u8996\u5236\u5fa1"};
        JComboBox<String> cssVisualEffectBox = new JComboBox<String>(cssVisualEffectStr);
        cssVisualEffectBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericOverflow(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        CSSAction.genericVisibility(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssVisualEffectLabel = new JLabel("\u8996\u899a\u52b9\u679c", 0);
        cssVisualEffectLabel.setFont(new Font("Monospaced", 0, 10));
        cssVisualEffectPane.add(cssVisualEffectBox, "Center");
        cssVisualEffectPane.add((Component)cssVisualEffectLabel, "South");
        cssVisualEffectPane.setMaximumSize(cssVisualEffectPane.getPreferredSize());
        JPanel cssListPane = new JPanel(new BorderLayout(0, 1));
        String[] cssListStr = new String[]{"\u30ea\u30b9\u30c8\u500b\u5225\u6307\u5b9a", "\u30ea\u30b9\u30c8\u4e00\u62ec\u6307\u5b9a"};
        JComboBox<String> cssListBox = new JComboBox<String>(cssListStr);
        cssListBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericList(TextView.this.textView, false);
                        break;
                    }
                    case 1: {
                        CSSAction.genericList(TextView.this.textView, true);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssListLabel = new JLabel("\u30ea\u30b9\u30c8", 0);
        cssListLabel.setFont(new Font("Monospaced", 0, 10));
        cssListPane.add(cssListBox, "Center");
        cssListPane.add((Component)cssListLabel, "South");
        cssListPane.setMaximumSize(cssListPane.getPreferredSize());
        JPanel cssTablePane = new JPanel(new BorderLayout(0, 1));
        String[] cssTableStr = new String[]{"\u30ad\u30e3\u30d7\u30b7\u30e7\u30f3\u4f4d\u7f6e", "\u30c6\u30fc\u30d6\u30eb\u8a2d\u5b9a", "\u7a7a\u30bb\u30eb\u8a2d\u5b9a"};
        JComboBox<String> cssTableBox = new JComboBox<String>(cssTableStr);
        cssTableBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        CSSAction.genericCaptionSide(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        CSSAction.genericTable(TextView.this.textView);
                        break;
                    }
                    case 2: {
                        CSSAction.genericEmptyCell(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel cssTableLabel = new JLabel("\u30c6\u30fc\u30d6\u30eb", 0);
        cssTableLabel.setFont(new Font("Monospaced", 0, 10));
        cssTablePane.add(cssTableBox, "Center");
        cssTablePane.add((Component)cssTableLabel, "South");
        cssTablePane.setMaximumSize(cssTablePane.getPreferredSize());
        JToolBar toolBar = new JToolBar("CSS2");
        toolBar.add(cssVisualFormatPane);
        toolBar.add(cssVisualEffectPane);
        toolBar.add(cssListPane);
        toolBar.add(cssTablePane);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
        return toolBar;
    }

    private JToolBar createRssToolBar() {
        JPanel rssChannelPane = new JPanel(new BorderLayout(0, 1));
        String[] rssChannelStr = new String[]{"\u5fc5\u9808\u8981\u7d20\u8a2d\u5b9a", "\u4efb\u610f\u8981\u7d20\u8a2d\u5b9a", "itunes\u8981\u7d20\u8a2d\u5b9a"};
        JComboBox<String> rssChannelBox = new JComboBox<String>(rssChannelStr);
        rssChannelBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        RSSAction.genericRssChannelBasicText(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        RSSAction.genericRssChannelOptionalText(TextView.this.textView);
                        break;
                    }
                    case 2: {
                        RSSAction.genericRssChannelItunesText(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel rssChannelLabel = new JLabel("\u30c1\u30e3\u30cd\u30eb\u8a2d\u5b9a", 0);
        rssChannelLabel.setFont(new Font("Monospaced", 0, 10));
        rssChannelPane.add(rssChannelBox, "Center");
        rssChannelPane.add((Component)rssChannelLabel, "South");
        rssChannelPane.setMaximumSize(rssChannelPane.getPreferredSize());
        JPanel rssItemPane = new JPanel(new BorderLayout(0, 1));
        String[] rssItemStr = new String[]{"item\u8981\u7d20", "\u4efb\u610f\u8981\u7d20\u8a2d\u5b9a", "itunes\u8981\u7d20\u8a2d\u5b9a"};
        JComboBox<String> rssItemBox = new JComboBox<String>(rssItemStr);
        rssItemBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                TextView.this.comboFlag = false;
                TextView.this.setTextFocus();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TextView.this.comboFlag = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!TextView.this.comboFlag) {
                    return;
                }
                int idx = ((JComboBox)e.getSource()).getSelectedIndex();
                switch (idx) {
                    case 0: {
                        RSSAction.genericRssItemText(TextView.this.textView);
                        break;
                    }
                    case 1: {
                        RSSAction.genericRssItemOptionalText(TextView.this.textView);
                        break;
                    }
                    case 2: {
                        RSSAction.genericRssItemItunesText(TextView.this.textView);
                    }
                }
                TextView.this.setTextFocus();
            }
        });
        JLabel rssItemLabel = new JLabel("\u9805\u76ee\u8a2d\u5b9a", 0);
        rssItemLabel.setFont(new Font("Monospaced", 0, 10));
        rssItemPane.add(rssItemBox, "Center");
        rssItemPane.add((Component)rssItemLabel, "South");
        rssItemPane.setMaximumSize(rssItemPane.getPreferredSize());
        JToolBar toolBar = new JToolBar("RSS");
        toolBar.add(rssChannelPane);
        toolBar.add(rssItemPane);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.setFloatable(false);
        return toolBar;
    }

    private String[] getElementsLabel(HTMLTag[] array) {
        String[] label = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            label[i] = array[i].getLabel();
        }
        return label;
    }

    private HTMLTag getElementsTag(String label, HTMLTag[] array) {
        HTMLTag tag = null;
        for (int i = 0; i < array.length; ++i) {
            if (!label.equals(array[i].getLabel())) continue;
            tag = array[i];
            break;
        }
        return tag;
    }

    public JTextArea getDocumentView() {
        return this.textArea;
    }

    public void insert(String str) {
        Document doc = this.textArea.getDocument();
        int position = this.textArea.getSelectionStart();
        try {
            int caretPosition = position + str.length();
            doc.insertString(position, str, null);
            this.textArea.setCaretPosition(caretPosition);
            this.textArea.requestFocusInWindow();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void insert(String str1, String str2) {
        Document doc = this.textArea.getDocument();
        int startPosition = this.textArea.getSelectionStart();
        int endPosition = this.textArea.getSelectionEnd();
        try {
            int caretPosition = startPosition + str1.length();
            doc.insertString(endPosition, str2, null);
            doc.insertString(startPosition, str1, null);
            this.textArea.setCaretPosition(caretPosition);
            this.textArea.requestFocusInWindow();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setTextFocus() {
        this.textArea.requestFocusInWindow();
    }

    public void windowActivated(WindowEvent e) {
        this.setTextFocus();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        TextView v = (TextView)e.getWindow();
        if (v.changeFlag) {
            int ret = JOptionPane.showConfirmDialog(null, v.getTitle() + " \u3092\u4fdd\u5b58\u3057\u307e\u3059\u304b?", "\u4fdd\u5b58\u78ba\u8a8d", 1);
            if (ret != 2) {
                v.dispose();
                JHime.ViewVector.remove(v);
                if (cnt-- == 1) {
                    Configuration.save();
                    System.exit(0);
                }
            }
        } else {
            v.dispose();
            JHime.ViewVector.remove(v);
            if (cnt-- == 1) {
                Configuration.save();
                System.exit(0);
            }
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public String getUserDir() {
        return this.userDir;
    }

    public void setUserDir(String str) {
        this.userDir = str;
        JHime.USER_DIR = str;
    }
}

