/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class HTMLDialog
extends JDialog
implements WindowListener {
    private TextView view;
    protected String tagString;
    protected boolean resultFlag;

    public HTMLDialog(TextView view) {
        super(view, null, true);
        this.view = view;
    }

    protected void setDialog(TextView view, String title, int width, int height) {
        this.setTitle(title);
        JPanel pane = this.createHTMLDocumentPanel();
        this.getContentPane().add((Component)pane, "Center");
        JButton btn1 = new JButton("\u8a2d\u5b9a");
        JButton btn2 = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        btn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLDialog.this.dispose();
                HTMLDialog.this.resultFlag = true;
            }
        });
        btn2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLDialog.this.dispose();
            }
        });
        pane = new JPanel();
        pane.add(btn1);
        pane.add(btn2);
        this.getContentPane().add((Component)pane, "South");
        this.setDefaultCloseOperation(2);
        Dimension dim = this.getPreferredSize();
        width = dim.width + 50;
        height = dim.height + 50;
        int x = view.getLocationOnScreen().x;
        int y = view.getLocationOnScreen().y;
        x = x + view.getSize().width / 2 - width / 2;
        if (x < 0) {
            x = view.getLocationOnScreen().x;
        }
        this.setBounds(x, y, width, height);
        this.setResizable(false);
        this.setVisible(true);
    }

    protected void gridLayoutComponent(JPanel pane, GridBagLayout layout, GridBagConstraints gc, Component comp, int x, int y, boolean enabled) {
        gc.gridx = x;
        gc.gridy = y;
        layout.setConstraints(comp, gc);
        pane.add(comp);
        comp.setEnabled(enabled);
    }

    protected void enabledSetting(ItemEvent e, Component comp) {
        if (1 == e.getStateChange()) {
            comp.setEnabled(true);
            comp.requestFocusInWindow();
        } else {
            comp.setEnabled(false);
        }
    }

    protected void fileSelect(JTextField comp, String[] filter) {
        JFileChooser fc = new JFileChooser(this.view.getUserDir());
        FileIOFilter fl = new FileIOFilter(filter[0]);
        fc.addChoosableFileFilter(fl);
        for (int i = 1; i < filter.length; ++i) {
            fc.addChoosableFileFilter(new FileIOFilter(filter[i]));
        }
        fc.setFileFilter(fl);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            this.view.setUserDir(fc.getSelectedFile().getParent());
            if (JHime.LINK_FILE) {
                comp.setText(fc.getSelectedFile().getName());
            } else if (JHime.LINK_PATH) {
                comp.setText(fc.getSelectedFile().getPath());
            } else {
                comp.setText(JHime.BASEURL + fc.getSelectedFile().getName());
            }
        }
    }

    protected void fileSelect(JTextField comp, JTextField scomp, String[] filter) {
        JFileChooser fc = new JFileChooser(this.view.getUserDir());
        FileIOFilter fl = new FileIOFilter(filter[0]);
        fc.addChoosableFileFilter(fl);
        for (int i = 1; i < filter.length; ++i) {
            fc.addChoosableFileFilter(new FileIOFilter(filter[i]));
        }
        fc.setFileFilter(fl);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            this.view.setUserDir(fc.getSelectedFile().getParent());
            if (JHime.LINK_FILE) {
                comp.setText(fc.getSelectedFile().getName());
            } else if (JHime.LINK_PATH) {
                comp.setText(fc.getSelectedFile().getPath());
            } else {
                comp.setText(JHime.BASEURL + fc.getSelectedFile().getName());
            }
            scomp.setText(Long.toString(fc.getSelectedFile().length()));
        }
    }

    protected abstract JPanel createHTMLDocumentPanel();

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.resultFlag = false;
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public boolean getResult() {
        return this.resultFlag;
    }

    public String getString() {
        return null;
    }

    public String getStringStart() {
        return null;
    }

    public String getStringEnd() {
        return null;
    }
}

