/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLBasicDialog
extends HTMLDialog {
    private JCheckBox xmlBtn = new JCheckBox("XML\u5ba3\u8a00", true);
    private JCheckBox dtdBtn = new JCheckBox("DTD\u5ba3\u8a00", true);
    private JCheckBox xmlnsBtn = new JCheckBox("xmlns\u5c5e\u6027", true);
    private JCheckBox xmlLangBtn = new JCheckBox("xml:lang\u5c5e\u6027", true);
    private JCheckBox langBtn = new JCheckBox("lang\u5c5e\u6027", true);
    private JLabel versionLabel = new JLabel("version", 4);
    private JTextField xmlVersionField = new JTextField("1.0", 5);
    private JLabel encodingLabel = new JLabel("encoding", 4);
    private String[] xmlEncoding_str = new String[]{"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
    private JComboBox xmlEncodingBox = new JComboBox<String>(this.xmlEncoding_str);
    private String[] dtd_str = new String[]{"XHTML 1.0 Strict", "XHTML 1.0 Transitional", "XHTML 1.0 Frameset", "XHTML 1.1", "HTML 4.01 Strict", "HTML 4.01 Transitional", "HTML 4.01 Frameset"};
    private JComboBox dtdBox = new JComboBox<String>(this.dtd_str);
    private JTextField xmlnsField = new JTextField("http://www.w3.org/1999/xhtml", 25);
    private JTextField xmlLangField = new JTextField("ja", 5);
    private JTextField langField = new JTextField("ja", 5);

    public HTMLBasicDialog(TextView view) {
        super(view);
        this.setDialog(view, "HTML\u6587\u66f8\u5b9a\u7fa9", 500, 300);
    }

    protected JPanel createHTMLDocumentPanel() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        JPanel pane = new JPanel(layout);
        gc.fill = 2;
        gc.insets = new Insets(10, 5, 10, 5);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        this.gridLayoutComponent(pane, layout, gc, this.xmlBtn, 0, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.versionLabel, 1, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.xmlVersionField, 2, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.encodingLabel, 3, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.xmlEncodingBox, 4, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.dtdBtn, 0, 1, true);
        gc.gridwidth = 3;
        this.gridLayoutComponent(pane, layout, gc, this.dtdBox, 1, 1, true);
        gc.gridwidth = 1;
        this.gridLayoutComponent(pane, layout, gc, this.xmlnsBtn, 0, 2, true);
        gc.gridwidth = 4;
        this.gridLayoutComponent(pane, layout, gc, this.xmlnsField, 1, 2, false);
        gc.gridwidth = 1;
        this.gridLayoutComponent(pane, layout, gc, this.xmlLangBtn, 0, 3, true);
        this.gridLayoutComponent(pane, layout, gc, this.xmlLangField, 1, 3, true);
        this.gridLayoutComponent(pane, layout, gc, this.langBtn, 0, 4, true);
        this.gridLayoutComponent(pane, layout, gc, this.langField, 1, 4, true);
        this.xmlBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.encodingLabel);
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.xmlEncodingBox);
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.versionLabel);
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.xmlVersionField);
            }
        });
        this.dtdBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.dtdBox);
            }
        });
        this.xmlLangBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.xmlLangField);
            }
        });
        this.langBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLBasicDialog.this.enabledSetting(e, HTMLBasicDialog.this.langField);
            }
        });
        return pane;
    }

    public String getStringStart() {
        StringBuffer buff = new StringBuffer();
        if (this.xmlBtn.isSelected()) {
            buff.append("<?xml version=\"" + this.xmlVersionField.getText() + "\" encoding=\"" + (String)this.xmlEncodingBox.getSelectedItem() + "\"?>\n");
        }
        if (this.dtdBtn.isSelected()) {
            switch (this.dtdBox.getSelectedIndex()) {
                case 0: {
                    buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
                    break;
                }
                case 1: {
                    buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
                    break;
                }
                case 2: {
                    buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n");
                    break;
                }
                case 3: {
                    buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
                    break;
                }
                case 4: {
                    buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/html4/strict.dtd\">\n");
                    break;
                }
                case 5: {
                    buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                    break;
                }
                case 6: {
                    buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n");
                    buff.append("                      \"http://www.w3.org/TR/html4/frameset.dtd\">\n");
                }
            }
        }
        buff.append("<html");
        if (this.xmlnsBtn.isSelected()) {
            buff.append(" xmlns=\"" + this.xmlnsField.getText() + "\"");
        }
        if (this.xmlLangBtn.isSelected()) {
            buff.append(" xml:lang=\"" + this.xmlLangField.getText() + "\"");
        }
        if (this.langBtn.isSelected()) {
            buff.append(" lang=\"" + this.langField.getText() + "\"");
        }
        buff.append(">\n");
        return buff.toString();
    }

    public String getStringEnd() {
        return "</html>";
    }
}

