//
//  RSSChannelOptionalDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.util.*;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSpinner.DateEditor;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.SpinnerDateModel;

import javax.swing.border.LineBorder;

public class RSSChannelOptionalDialog extends RSSDialog {

	public RSSChannelOptionalDialog (TextView view) {
		super(view);

		setDialog(view, "RSSチャネル 任意要素", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		channelCategoryBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, channelLanguageBtn,			0, 0, true);
		gridLayoutComponent(pane, layout, gc, channelLanguageField,			1, 0, false);
		gridLayoutComponent(pane, layout, gc, channelCopyrightBtn,			0, 1, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, channelCopyrightField,		1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelManagingEditorBtn,		0, 2, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, channelManagingEditorField,	1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelWebMasterBtn,			0, 3, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, channelWebMasterField,		1, 3, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelLastBuildBtn,			0, 4, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, channelLastBuildField,		1, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelCategoryBtn,			0, 5, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelCategoryBox,			1, 5, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelTtlBtn,				0, 6, true);
		gridLayoutComponent(pane, layout, gc, channelTtlField,				1, 6, false);
		gridLayoutComponent(pane, layout, gc, channelImageBtn,				0, 7, true);
		gridLayoutComponent(pane, layout, gc, channelImageUrlLabel,			1, 7, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelImageUrlField,			2, 7, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelImageUrlBtn,			5, 7, false);
		gridLayoutComponent(pane, layout, gc, channelImageTitleLabel,		1, 8, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelImageTitleField,		2, 8, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelImageLinkLabel,		1, 9, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelImageLinkField,		2, 9, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelImageLinkBtn,			5, 9, false);
		gridLayoutComponent(pane, layout, gc, channelImageDescriptionBtn,	1,10, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelImageDescriptionField,	2,10, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelImageWidthBtn,			1,11, false);
		gridLayoutComponent(pane, layout, gc, channelImageWidthField,		2,11, false);
		gridLayoutComponent(pane, layout, gc, channelImageHeightBtn,		1,12, false);
		gridLayoutComponent(pane, layout, gc, channelImageHeightField,		2,12, false);

		channelLanguageBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelLanguageField);
			}
		});
		channelCopyrightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelCopyrightField);
			}
		});
		channelManagingEditorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelManagingEditorField);
			}
		});
		channelWebMasterBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelWebMasterField);
			}
		});
		channelLastBuildBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelLastBuildField);
			}
		});
		channelCategoryBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelCategoryBox);
			}
		});
		channelTtlBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelTtlField);
			}
		});
		channelImageBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelImageHeightBtn);
				enabledSetting(e, channelImageWidthBtn);
				enabledSetting(e, channelImageDescriptionBtn);
				enabledSetting(e, channelImageLinkLabel);
				enabledSetting(e, channelImageLinkBtn);
				enabledSetting(e, channelImageLinkField);
				enabledSetting(e, channelImageTitleLabel);
				enabledSetting(e, channelImageTitleField);
				enabledSetting(e, channelImageUrlLabel);
				enabledSetting(e, channelImageUrlBtn);
				enabledSetting(e, channelImageUrlField);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					channelImageDescriptionField.setEnabled(false);
					channelImageHeightField.setEnabled(false);
					channelImageWidthField.setEnabled(false);
				} else {
					if (channelImageDescriptionBtn.isSelected()) {
						channelImageDescriptionField.setEnabled(true);
					}
					if (channelImageHeightBtn.isSelected()) {
						channelImageHeightField.setEnabled(true);
					}
					if (channelImageWidthBtn.isSelected()) {
						channelImageWidthField.setEnabled(true);
					}
				}
			}
		});
		channelImageDescriptionBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelImageDescriptionField);
			}
		});
		channelImageHeightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelImageHeightField);
			}
		});
		channelImageWidthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelImageWidthField);
			}
		});
		channelImageUrlBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(channelImageUrlField, filter);
			}
		});
		channelImageLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.HTML_GROUP};
				fileSelect(channelImageLinkField, filter);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (channelLanguageBtn.isSelected()) {
			buff.append("<language>" + channelLanguageField.getText() + "</language>\n");
		}
		if (channelCopyrightBtn.isSelected()) {
			buff.append("<copyright>" + channelCopyrightField.getText() + "</copyright>\n");
		}
		if (channelManagingEditorBtn.isSelected()) {
			buff.append("<managingEditor>" + channelManagingEditorField.getText() + "</managingEditor>\n");
		}
		if (channelWebMasterBtn.isSelected()) {
			buff.append("<webMaster>" + channelWebMasterField.getText() + "</webMaster>\n");
		}
		if (channelLastBuildBtn.isSelected()) {
			Date dObj = (Date)channelLastBuildField.getValue();
			String dateStr = getDateTime(dObj);
			buff.append("<lastBuildDate>" + dateStr + "</lastBuildDate>\n");
		}
		if (channelCategoryBtn.isSelected()) {
			if (channelCategoryBox.getSelectedIndex() >= 0) {
				buff.append("<category>" + category_main_str_en[channelCategoryBox.getSelectedIndex()] + "</category>\n");
			} else {
				buff.append("<category>" + channelCategoryBox.getSelectedItem() + "</category>\n");
			}
		}
		if (channelTtlBtn.isSelected()) {
			buff.append("<ttl>" + channelTtlField.getText() + "</ttl>\n");
		}
		if (channelImageBtn.isSelected()) {
			buff.append("<image>\n");
			buff.append("<url>" + channelImageUrlField.getText() + "</url>\n");
			buff.append("<title>" + channelImageTitleField.getText() + "</title>\n");
			buff.append("<link>" + channelImageLinkField.getText() + "</link>\n");
			if (channelImageDescriptionBtn.isSelected()) {
				buff.append("<description>" + channelImageDescriptionField.getText() + "</description>\n");
			}
			if (channelImageWidthBtn.isSelected()) {
				buff.append("<width>" + channelImageWidthField.getText() + "</width>\n");
			}
			if (channelImageHeightBtn.isSelected()) {
				buff.append("<height>" + channelImageHeightField.getText() + "</height>\n");
			}
			buff.append("</image>\n");
		}

		return buff.toString();
	}
}