//
//  RSSChannelDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/05/02.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.util.*;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSpinner.DateEditor;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.swing.SpinnerDateModel;

import javax.swing.border.LineBorder;

public class RSSChannelDialog extends RSSDialog {

	public RSSChannelDialog (TextView view) {
		super(view);

		setDialog(view, "RSSチャネル 必須要素", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		channelDescriptionField.setFont(new Font("Monospaced", Font.PLAIN, JHime.FONT_SIZE));
		channelDescriptionField.setMargin(new Insets(1,5,1,5));
		JScrollPane channelDescriptionPane = new JScrollPane(channelDescriptionField);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, ituneBtn,						0, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelTitleLabel,			0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, channelTitleField,			1, 1, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelLinkLabel,				0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, channelLinkField,				1, 2, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, channelLinkBtn,				3, 2, true);
		gridLayoutComponent(pane, layout, gc, channelDescriptionLabel,		0, 3, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelDescriptionPane,		1, 3, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, channelDescriptionCopyBtn,	0, 4, true);

		ituneBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, channelDescriptionCopyBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					tabPane.setEnabledAt(2, false);
				} else {
					tabPane.setEnabledAt(2, true);
				}
				ituneBtn.requestFocusInWindow();
			}
		});
		channelLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.HTML_GROUP};
				fileSelect(channelLinkField, filter);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		buff.append("<rss");
		if (ituneBtn.isSelected()) {
			buff.append(" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\"");
		}
		buff.append(" version=\"2.0\">\n");
		buff.append("<channel>\n");

		buff.append("<title>" + channelTitleField.getText() + "</title>\n");
		buff.append("<link>" + channelLinkField.getText() + "</link>\n");
		buff.append("<description>" + channelDescriptionField.getText() + "</description>\n");

		buff.append("<generator>JHime</generator>\n");
		buff.append("<docs>http://blogs.law.harvard.edu/tech/rss</docs>\n");

		if (channelDescriptionCopyBtn.isSelected()) {
			buff.append("<itunes:summary>" + channelDescriptionField.getText() + "</itunes:summary>\n");
		}
		buff.append("</channel>\n");
		buff.append("</rss>");

		return buff.toString();
	}
}