//
//  HTMLTableDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLTableDialog extends HTMLDialog {
	private JCheckBox widthBtn = new JCheckBox("width属性");
	private JCheckBox borderBtn = new JCheckBox("border属性");
	private JCheckBox cellspacingBtn = new JCheckBox("cellspacing属性");
	private JCheckBox cellpaddingBtn = new JCheckBox("cellpadding属性");

	private JTextField widthField = new JTextField(10);
	private JTextField borderField = new JTextField(10);
	private JTextField cellspacingField = new JTextField(10);
	private JTextField cellpaddingField = new JTextField(10);

	public HTMLTableDialog (TextView view) {
		super(view);
		setDialog(view, "table要素定義", 300, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, widthBtn,			0, 0, true);
		gridLayoutComponent(pane, layout, gc, widthField,		1, 0, false);
		gridLayoutComponent(pane, layout, gc, borderBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, borderField,		1, 1, false);
		gridLayoutComponent(pane, layout, gc, cellspacingBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, cellspacingField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, cellpaddingBtn,	0, 3, true);
		gridLayoutComponent(pane, layout, gc, cellpaddingField,	1, 3, false);

		widthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, widthField);
			}
		});
		borderBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, borderField);
			}
		});
		cellspacingBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, cellspacingField);
			}
		});
		cellpaddingBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, cellpaddingField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<table");
		if (widthBtn.isSelected()) {
			buff.append(" width=\"" + (String)widthField.getText() + "\"");
		}
		if (borderBtn.isSelected()) {
			buff.append(" border=\"" + (String)widthField.getText() + "\"");
		}
		if (cellspacingBtn.isSelected()) {
			buff.append(" cellspacing=\"" + (String)widthField.getText() + "\"");
		}
		if (cellpaddingBtn.isSelected()) {
			buff.append(" cellpadding=\"" + (String)widthField.getText() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}
	
	public String getStringEnd() {
		return "</table>\n";
	}

}