//
//  HTMLSelectDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/16.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLSelectDialog extends HTMLDialog {
	private JCheckBox nameBtn = new JCheckBox("name属性", true);
	private JCheckBox sizeBtn = new JCheckBox("size属性");
	private JCheckBox multipleBtn = new JCheckBox("multiple属性");
	private JCheckBox disabledBtn = new JCheckBox("disabled属性");

	private JTextField nameField = new JTextField(10);
	private JTextField sizeField = new JTextField(10);
		
	public HTMLSelectDialog (TextView view) {
		super(view);
		setDialog(view, "select要素定義", 300, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, nameBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, nameField,	1, 0, true);
		gridLayoutComponent(pane, layout, gc, sizeBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, sizeField,	1, 1, false);
		gridLayoutComponent(pane, layout, gc, multipleBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, disabledBtn,	0, 3, true);

		nameBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, nameField);
			}
		});
		sizeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, sizeField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<select");
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + nameField.getText() + "\"");
		}
		if (sizeBtn.isSelected()) {
			buff.append(" size=\"" + sizeField.getText() + "\"");
		}
		if (multipleBtn.isSelected()) {
			buff.append(" multiple=\"multiple\"");
		}
		if (disabledBtn.isSelected()) {
			buff.append(" disabled=\"disabled\"");
		}
		buff.append(">\n");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</select>\n";
	}
}