//
//  HTMLScriptDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/12.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLScriptDialog extends HTMLDialog {
	private JLabel typeLabel   = new JLabel("type属性", JLabel.RIGHT);
	private JCheckBox srcBtn = new JCheckBox("src属性", true);
	private JCheckBox charsetBtn = new JCheckBox("charset属性");
	private JCheckBox deferBtn = new JCheckBox("defer属性");

	private String[] type_str = {"text/javascript", "text/ecmascript", "text/jscript",
								 "text/vbscript", "text/tcl"};
	private JComboBox typeBox = new JComboBox(type_str);
	private JTextField srcField = new JTextField(30);
	private JButton srcLinkBtn = new JButton("参照");
	private String[] charset_str = {"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
	private JComboBox charsetBox = new JComboBox(charset_str);

	public HTMLScriptDialog (TextView view) {
		super(view);
		setDialog(view, "script要素定義", 600, 250);
	}

	protected JPanel createHTMLDocumentPanel() {
		typeBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, typeLabel,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, typeBox,		1, 0, true);
		gridLayoutComponent(pane, layout, gc, srcBtn,		0, 1, true);
		gc.fill = GridBagConstraints.NONE;
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, srcField,		1, 1, true);
		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, srcLinkBtn,	3, 1, true);
		gridLayoutComponent(pane, layout, gc, charsetBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, charsetBox,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, deferBtn,		0, 3, true);

		srcLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JAVASCRIPT};
				fileSelect(srcField, filter);
			}
		});
		srcBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, srcLinkBtn);
				enabledSetting(e, srcField);
			}
		});
		charsetBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, charsetBox);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<script");
		buff.append(" type=\"" + (String)typeBox.getSelectedItem() + "\"");
		if (srcBtn.isSelected()) {
			buff.append(" src=\"" + (String)srcField.getText() + "\"");
		}
		if (charsetBtn.isSelected()) {
			buff.append(" charset=\"" + (String)charsetBox.getSelectedItem() + "\"");
		}
		if (deferBtn.isSelected()) {
			buff.append(" defer=\"defer\"");
		}
		buff.append(">\n");

		return buff.toString();
	}
	
	public String getStringEnd() {
		return "</script>\n";
	}

}