//
//  HTMLMimeDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/10.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HTMLMimeDialog extends HTMLDialog {
	private JLabel mimeLabel		= new JLabel("MIME指定", JLabel.RIGHT);
	private JLabel encodingLabel	= new JLabel("エンコーディング", JLabel.RIGHT);

	private String[] mime_str	= {"text/html", "application/xhtml+xml", "application/xml", "text/xml"};
	private JComboBox mimeBox	= new JComboBox(mime_str);
	private String[] encoding_str	= {"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
	private JComboBox encodingBox	= new JComboBox(encoding_str);

	public HTMLMimeDialog (TextView view) {
		super(view);
		setDialog(view, "HTML MIME設定", 400, 150);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, mimeLabel,	 0, 0, true);
		gridLayoutComponent(pane, layout, gc, mimeBox,		 1, 0, true);
		gridLayoutComponent(pane, layout, gc, encodingLabel, 0, 1, true);
		gridLayoutComponent(pane, layout, gc, encodingBox,	 1, 1, true);

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<meta http-equiv=\"Content-Type\"");
		buff.append(" content=\"" + (String)mimeBox.getSelectedItem() + ";");
		buff.append(" charset=" + (String)encodingBox.getSelectedItem() + "\" />\n");

		return buff.toString();
	}
}