//
//  HTMLMetaDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/10.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HTMLMetaDialog extends HTMLDialog {
	private JCheckBox httpEquivBtn = new JCheckBox("http-equiv属性");
	private JCheckBox nameBtn = new JCheckBox("name属性");

	private String[] httpEquiv_str = {"", "Content-Style-Type", "Content-Script-Type", "Content-Type"};
	private JComboBox httpEquivBox = new JComboBox(httpEquiv_str);
	private String[] name_str = {"", "description", "keywords", "author", "copyright", "reply-to", "date",
								 "ROBOTS"};
	private JComboBox nameBox = new JComboBox(name_str);
	private JLabel contentLabel = new JLabel("content属性", JLabel.RIGHT);
	private String[] content_str = {"", "text/css", "text/javascript", "yyyy-mm-ddThh:mm:ss+09:00"};
	private JComboBox contentBox = new JComboBox(content_str);

	public HTMLMetaDialog (TextView view) {
		super(view);
		setDialog(view, "meta要素定義", 400, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		httpEquivBox.setEditable(true);
		nameBox.setEditable(true);
		contentBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, httpEquivBtn,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, httpEquivBox,	1, 0, false);
		gridLayoutComponent(pane, layout, gc, nameBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, nameBox,		1, 1, false);
		gridLayoutComponent(pane, layout, gc, contentLabel,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, contentBox,	1, 2, true);

		httpEquivBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, httpEquivBox);
			}
		});
		nameBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, nameBox);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<meta");
		if (httpEquivBtn.isSelected()) {
			buff.append(" http-equiv=\"" + (String)httpEquivBox.getSelectedItem() + "\"");
		}
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + (String)nameBox.getSelectedItem() + "\"");
		}
		buff.append(" content=\"" + (String)contentBox.getSelectedItem() + "\" />\n");

		return buff.toString();
	}
}