//
//  HTMLLabelDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/16.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLLabelDialog extends HTMLDialog {
	private JCheckBox forBtn = new JCheckBox("for属性");

	private JTextField forField = new JTextField(15);

	public HTMLLabelDialog (TextView view) {
		super(view);
		setDialog(view, "label要素定義", 300, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, forBtn,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, forField,	1, 0, false);

		forBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, forField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<label");
		if (forBtn.isSelected()) {
			buff.append(" for=\"" + forField.getText() + "\"");
		}
		buff.append(">");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</label>";
	}
}