//
//  HTMLInsDelDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/13.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLInsDelDialog extends HTMLDialog {
	private JCheckBox citeBtn = new JCheckBox("cite属性");
	private JTextField citeField = new JTextField(30);
	private JCheckBox datetimeBtn = new JCheckBox("datetime属性");
	private JTextField datetimeField = new JTextField("9999-99-99T99:99:99+0900", 20);

	private boolean insFlag;

	public HTMLInsDelDialog (TextView view, String tagName) {
		super(view);

		String title;
		if (tagName.equals("ins")) {
			insFlag = true;
			title = "ins要素定義";
		} else {
			insFlag = false;
			title = "del要素定義";
		}
		setDialog(view, title, 500, 150);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, citeBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, citeField,	1, 0, false);
		gridLayoutComponent(pane, layout, gc, datetimeBtn,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, datetimeField,	1, 1, false);

		citeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, citeField);
			}
		});
		datetimeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, datetimeField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		if (insFlag) {
			buff.append("<ins");
		} else {
			buff.append("<del");
		}
		if (citeBtn.isSelected()) {
			buff.append(" cite=\"" + (String)citeField.getText() + "\"");
		}
		if (datetimeBtn.isSelected()) {
			buff.append(" datetime=\"" + (String)citeField.getText() + "\"");
		}
		buff.append(">");

		return buff.toString();
	}
	
	public String getStringEnd() {
		if (insFlag) {
			return "</ins>";
		} else {
			return "</del>";
		}
	}

}