//
//  HTMLImgDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLImgDialog extends HTMLDialog {
	private JLabel srcLabel = new JLabel("src属性", JLabel.RIGHT);
	private JLabel altLabel = new JLabel("alt属性", JLabel.RIGHT);
	private JCheckBox heightBtn = new JCheckBox("height属性", true);
	private JCheckBox widthBtn = new JCheckBox("width属性", true);

	private JTextField srcField = new JTextField(30);
	private JButton srcBtn = new JButton("参照");
	private JTextField altField = new JTextField(30);
	private JTextField heightField = new JTextField(10);
	private JTextField widthField = new JTextField(10);

	public HTMLImgDialog (TextView view) {
		super(view);
		setDialog(view, "img要素定義", 600, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, srcLabel,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, srcField,		1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, srcBtn,		3, 0, true);
		gridLayoutComponent(pane, layout, gc, altLabel,		0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, altField,		1, 1, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, heightBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, heightField,	1, 2, true);
		gridLayoutComponent(pane, layout, gc, widthBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, widthField,	1, 3, true);

		srcBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(srcField, filter);
			}
		});
		heightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, heightField);
			}
		});
		widthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, widthField);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("<img");
		buff.append(" src=\"" + (String)srcField.getText() + "\"");
		buff.append(" alt=\"" + (String)altField.getText() + "\"");
		if (heightBtn.isSelected()) {
			buff.append(" height=\"" + (String)heightField.getText() + "\"");
		}
		if (widthBtn.isSelected()) {
			buff.append(" width=\"" + (String)widthField.getText() + "\"");
		}
		buff.append(" />");

		return buff.toString();
	}
}