//
//  HTMLBlockquoteDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/13.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLBlockquoteDialog extends HTMLDialog {
	private JCheckBox citeBtn = new JCheckBox("cite属性");
	private JTextField citeField = new JTextField(30);

	public HTMLBlockquoteDialog (TextView view) {
		super(view);
		setDialog(view, "blockquote要素定義", 500, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, citeBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, citeField,	1, 0, false);

		citeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, citeField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<blockquote");
		if (citeBtn.isSelected()) {
			buff.append(" cite=\"" + (String)citeField.getText() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}
	
	public String getStringEnd() {
		return "</blockquote>\n";
	}

}