//
//  HTMLADialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLADialog extends HTMLDialog {
	private JCheckBox idBtn = new JCheckBox("id属性");
	private JCheckBox nameBtn = new JCheckBox("name属性");
	private JCheckBox hrefBtn = new JCheckBox("href属性");

	private JTextField idField = new JTextField(30);
	private JTextField nameField = new JTextField(30);
	private JTextField hrefField = new JTextField(30);
	private JButton hrefLinkBtn = new JButton("参照");

	public HTMLADialog (TextView view) {
		super(view);
		setDialog(view, "a要素定義", 600, 200);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, idBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, idField,		1, 0, false);
		gridLayoutComponent(pane, layout, gc, nameBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, nameField,	1, 1, false);
		gridLayoutComponent(pane, layout, gc, hrefBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, hrefField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, hrefLinkBtn,	2, 2, false);

		idBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, idField);
			}
		});
		nameBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, nameField);
			}
		});
		hrefBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, hrefLinkBtn);
				enabledSetting(e, hrefField);
			}
		});
		hrefLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.HTML_GROUP, FileIOFilter.JPEG_GROUP,
								   FileIOFilter.MOV_GROUP, FileIOFilter.AUDIO_GROUP};
				fileSelect(hrefField, filter);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("<a");
		if (idBtn.isSelected()) {
			buff.append(" id=\"" + (String)idField.getText() + "\"");
		}
		if (nameBtn.isSelected()) {
			buff.append(" name=\"" + (String)nameField.getText() + "\"");
		}
		if (hrefBtn.isSelected()) {
			buff.append(" href=\"" + (String)hrefField.getText() + "\"");
		}
		buff.append(">");

		return buff.toString();
	}
	
	public String getStringEnd() {
		return "</a>";
	}

}