//
//  FileIO.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/11.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.io.*;
import javax.swing.filechooser.FileFilter;

public class FileIOFilter extends FileFilter {
	public final static String HTML = "html";
	public final static String CSS = "css";
	public final static String XML = "xml";
	public final static String TEXT = "text";
	public final static String JPEG = "jpeg";
	public final static String PNG = "png";
	public final static String GIF = "gif";
	public final static String MOV = "mov";
	public final static String MPEG = "mpeg";
	public final static String JAVASCRIPT = "javascript";

	public final static String HTML_GROUP = "html_g";
	public final static String JPEG_GROUP = "hpeg_g";
	public final static String MOV_GROUP  = "mov_g";
	public final static String AUDIO_GROUP  = "audio_g";
	public final static String ITUNES_GROUP  = "itunes_g";


	private String type;

	public FileIOFilter(String type) {
		super();

		this.type = type;
	}
	
	public boolean accept(File file) {
		if (file.isDirectory()) {
			return true;
		}

		boolean retFlag = false;
		String filename = file.getName().toLowerCase();
		if (type.equals(HTML)) {
			retFlag = filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".xhtml");
		} else if (type.equals(CSS)) {
			retFlag = filename.endsWith(".css");
		} else if (type.equals(XML)) {
			retFlag = filename.endsWith(".xml") || filename.endsWith(".xsl");
		} else if (type.equals(TEXT)) {
			retFlag = filename.endsWith(".txt") || filename.endsWith(".text");
		} else if (type.equals(JPEG)) {
			retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg");
		} else if (type.equals(PNG)) {
			retFlag = filename.endsWith(".png");
		} else if (type.equals(GIF)) {
			retFlag = filename.endsWith(".gif");
		} else if (type.equals(MOV)) {
			retFlag = filename.endsWith(".mov");
		} else if (type.equals(MPEG)) {
			retFlag = filename.endsWith(".mpeg") || filename.endsWith(".mpg");
		} else if (type.equals(JAVASCRIPT)) {
			retFlag = filename.endsWith(".js");

		} else if (type.equals(HTML_GROUP)) {
			retFlag = filename.endsWith(".html") || filename.endsWith(".htm") ||
					  filename.endsWith(".xhtml") || filename.endsWith(".xml");
		} else if (type.equals(JPEG_GROUP)) {
			retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg") ||
					  filename.endsWith(".gif") || filename.endsWith(".png");
		} else if (type.equals(MOV_GROUP)) {
			retFlag = filename.endsWith(".mov") ||
					  filename.endsWith(".mpeg") || filename.endsWith(".mpg");
		} else if (type.equals(AUDIO_GROUP)) {
			retFlag = filename.endsWith(".mp3") || filename.endsWith(".mid") ||
					  filename.endsWith(".aif") || filename.endsWith(".aiff") ||
					  filename.endsWith(".wav") || filename.endsWith(".aac");
		} else if (type.equals(ITUNES_GROUP)) {
			retFlag = filename.endsWith(".mp3") || filename.endsWith(".m4a") ||
					  filename.endsWith(".mp4") || filename.endsWith(".m4v") ||
					  filename.endsWith(".mov") || filename.endsWith(".pdf");
		}

		return retFlag;
	}

	public String getDescription () {
		String str = null;

		if (type.equals(HTML)) {
			str = "HTMLファイル (*.html, *.htm, *.xhtml)";
		} else if (type.equals(CSS)) {
			str = "CSSファイル (*.css)";
		} else if (type.equals(XML)) {
			str = "XMLファイル (*.xml, *.xsl)";
		} else if (type.equals(TEXT)) {
			str = "TEXTファイル (*.txt, *.text)";
		} else if (type.equals(JPEG)) {
			str = "JPEGファイル (*.jpg, *.jpeg)";
		} else if (type.equals(PNG)) {
			str = "PNGファイル (*.png)";
		} else if (type.equals(GIF)) {
			str = "GIFファイル (*.gif)";
		} else if (type.equals(MOV)) {
			str = "MOVファイル (*.mov)";
		} else if (type.equals(MPEG)) {
			str = "MPEGファイル (*.mpg, *.mpeg)";
		} else if (type.equals(JAVASCRIPT)) {
			str = "JavaScriptファイル (*.js)";

		} else if (type.equals(HTML_GROUP)) {
			str = "HTML,XMLファイル (*.html, *.xml, *.htm, *.xhtml)";
		} else if (type.equals(JPEG_GROUP)) {
			str = "画像ファイル (*.jpg, *.jpeg, *.png, *.gif)";
		} else if (type.equals(MOV_GROUP)) {
			str = "動画ファイル (*.mov, *.mpg, *.mpeg)";
		} else if (type.equals(AUDIO_GROUP)) {
			str = "音声ファイル (*.mp3, *.mid, *.aif, *.aiff, *.wav, *.aac)";
		} else if (type.equals(ITUNES_GROUP)) {
			str = "Podcastファイル (*.mp3, *.m4a, *.mp4, *.m4v, *.mov, *.pdf)";
		}

		return str;
	}
}
