//
//  Configuration.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/22.
//  Copyright 2008 HIROTAKA_YAMASHITA. All rights reserved.
//

import java.io.*;
import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.SAXException;

import org.w3c.dom.*;

public final class Configuration {
	public static void load() {
		try {
			JHime.TAB_SIZE = 4;
			JHime.FONT_SIZE = 11;
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();

			String path = "JHime.xml";
			if (JHime.USER_PATH != null) {
				path = JHime.USER_PATH + "/" + path;
			}
			Document doc = db.parse(new FileInputStream(path));
			Element root = doc.getDocumentElement();
			if (root.getTagName().equals("jhime")) {
				NodeList nodeList = root.getChildNodes();
				for (int i = 0; i < nodeList.getLength(); i++) {
					Node node = nodeList.item(i);
					if (node.getNodeType() != Node.ELEMENT_NODE) continue;
					String tagName = ((Element)node).getTagName();
					String value   = ((Element)node).getAttribute("value");
					if (tagName.equals("tabsize")) {
						JHime.TAB_SIZE = Integer.parseInt(value);
					} else if (tagName.equals("fontsize")) {
						JHime.FONT_SIZE = Integer.parseInt(value);
					} else if (tagName.equals("csstabcount")) {
						JHime.CSS_TAB_COUNT = Integer.parseInt(value);
					} else if (tagName.equals("baseurl")) {
						JHime.BASEURL = value;
					} else if (tagName.equals("linkfile")) {
						if (value.toUpperCase().equals("TRUE")) {
							JHime.LINK_FILE = true;
						} else {
							JHime.LINK_FILE = false;
						}
					} else if (tagName.equals("linkpath")) {
						if (value.toUpperCase().equals("TRUE")) {
							JHime.LINK_PATH = true;
						} else {
							JHime.LINK_PATH = false;
						}
					} else if (tagName.equals("linkurl")) {
						if (value.toUpperCase().equals("TRUE")) {
							JHime.LINK_URL = true;
						} else {
							JHime.LINK_URL = false;
						}
					}
				}
			}
		} catch (Exception e) { }
	}

	public static void save() {
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();

			Document doc = db.newDocument();
			Element root = doc.createElement("jhime");
			doc.appendChild(root);

			Element tabSize = doc.createElement("tabsize");
			tabSize.setAttribute("value", Integer.toString(JHime.TAB_SIZE));
			root.appendChild(tabSize);

			Element fontSize = doc.createElement("fontsize");
			fontSize.setAttribute("value", Integer.toString(JHime.FONT_SIZE));
			root.appendChild(fontSize);

			Element cssTabCount = doc.createElement("csstabcount");
			cssTabCount.setAttribute("value", Integer.toString(JHime.CSS_TAB_COUNT));
			root.appendChild(cssTabCount);

			Element baseUrl = doc.createElement("baseurl");
			baseUrl.setAttribute("value", JHime.BASEURL);
			root.appendChild(baseUrl);

			Element linkFile = doc.createElement("linkfile");
			if (JHime.LINK_FILE) {
				linkFile.setAttribute("value", "TRUE");
			} else {
				linkFile.setAttribute("value", "FALSE");
			}
			root.appendChild(linkFile);

			Element linkPath = doc.createElement("linkpath");
			if (JHime.LINK_PATH) {
				linkPath.setAttribute("value", "TRUE");
			} else {
				linkPath.setAttribute("value", "FALSE");
			}
			root.appendChild(linkPath);

			Element linkUrl = doc.createElement("linkurl");
			if (JHime.LINK_URL) {
				linkUrl.setAttribute("value", "TRUE");
			} else {
				linkUrl.setAttribute("value", "FALSE");
			}
			root.appendChild(linkUrl);


			TransformerFactory tff = TransformerFactory.newInstance();
			Transformer tf = tff.newTransformer();
			tf.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			tf.setOutputProperty(OutputKeys.INDENT, "yes");
			String path = "JHime.xml";
			if (JHime.USER_PATH != null) {
				path = JHime.USER_PATH + "/" + path;
			}
			tf.transform(new DOMSource(doc), new StreamResult(path));
		} catch (Exception e) { }
		
	}
}
