//
//  CSSTextDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/25.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSTextDialog extends HTMLDialog {
	private JCheckBox textIndentBtn = new JCheckBox("text-indent");
	private JCheckBox textAlignBtn = new JCheckBox("text-align");
	private JCheckBox textDecorationBtn = new JCheckBox("text-decoration");
	private JCheckBox textWhiteSpaceBtn = new JCheckBox("white-space");

	private JRadioButton textIndentLengthBtn  = new JRadioButton("長さ・%値", true);
	private JRadioButton textIndentInheritBtn = new JRadioButton("inherit");
	private JTextField textIndentLengthField = new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox textIndentLengthBox = new JComboBox(length_str);
	private String[] textalign_str = {
		"left", "right", "center", "justify", "inherit"
	};
	private JComboBox textAlignBox = new JComboBox(textalign_str);
	private JRadioButton textDecorationNoneBtn = new JRadioButton("none", true);
	private JRadioButton textDecorationSetBtn = new JRadioButton("修飾");
	private JRadioButton textDecorationInheritBtn = new JRadioButton("inherit");
	private JCheckBox textDecorationUnderlineBtn = new JCheckBox("underline");
	private JCheckBox textDecorationOverlineBtn = new JCheckBox("overline");
	private JCheckBox textDecorationLineThroughBtn = new JCheckBox("line-through");
	private JCheckBox textDecorationBlinkBtn = new JCheckBox("blink");
	private String[] textwhitespace_str = {
		"normal", "pre", "nowrap", "pre-wrap", "pre-line", "inherit"
	};
	private JComboBox textWhiteSpaceBox = new JComboBox(textwhitespace_str);


	public CSSTextDialog (TextView view) {
		super(view);

		setDialog(view, "テキスト設定", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup1 = new ButtonGroup();
		btnGroup1.add(textIndentLengthBtn);
		btnGroup1.add(textIndentInheritBtn);
		ButtonGroup btnGroup2 = new ButtonGroup();
		btnGroup2.add(textDecorationNoneBtn);
		btnGroup2.add(textDecorationSetBtn);
		btnGroup2.add(textDecorationInheritBtn);

		JPanel pan = new JPanel();
		pan.add(textDecorationUnderlineBtn);
		pan.add(textDecorationOverlineBtn);
		pan.add(textDecorationLineThroughBtn);
		pan.add(textDecorationBlinkBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		textDecorationUnderlineBtn.setEnabled(false);
		textDecorationOverlineBtn.setEnabled(false);
		textDecorationLineThroughBtn.setEnabled(false);
		textDecorationBlinkBtn.setEnabled(false);

		gridLayoutComponent(pane, layout, gc, textIndentBtn,			0, 0, true);
		gridLayoutComponent(pane, layout, gc, textIndentLengthBtn,		1, 0, false);
		gridLayoutComponent(pane, layout, gc, textIndentLengthField,	2, 0, false);
		gridLayoutComponent(pane, layout, gc, textIndentLengthBox,		3, 0, false);
		gridLayoutComponent(pane, layout, gc, textIndentInheritBtn,		1, 1, false);
		gridLayoutComponent(pane, layout, gc, textAlignBtn,				0, 2, true);
		gridLayoutComponent(pane, layout, gc, textAlignBox,				1, 2, false);
		gridLayoutComponent(pane, layout, gc, textDecorationBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, textDecorationNoneBtn,	1, 3, false);
		gridLayoutComponent(pane, layout, gc, textDecorationSetBtn,		1, 4, false);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, pan,						2, 4, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, textDecorationInheritBtn,	1, 5, false);
		gridLayoutComponent(pane, layout, gc, textWhiteSpaceBtn,		0, 6, true);
		gridLayoutComponent(pane, layout, gc, textWhiteSpaceBox,		1, 6, false);

		textIndentBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textIndentLengthBtn);
				enabledSetting(e, textIndentInheritBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					textIndentLengthField.setEnabled(false);
					textIndentLengthBox.setEnabled(false);
				} else {
					if (textIndentLengthBtn.isSelected()) {
						textIndentLengthField.setEnabled(true);
						textIndentLengthBox.setEnabled(true);
					}
				}
			}
		});
		textIndentLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textIndentLengthBox);
				enabledSetting(e, textIndentLengthField);
			}
		});
		textAlignBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textAlignBox);
			}
		});
		textDecorationBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textDecorationInheritBtn);
				enabledSetting(e, textDecorationSetBtn);
				enabledSetting(e, textDecorationNoneBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					textDecorationBlinkBtn.setEnabled(false);
					textDecorationLineThroughBtn.setEnabled(false);
					textDecorationOverlineBtn.setEnabled(false);
					textDecorationUnderlineBtn.setEnabled(false);
				} else {
					if (textDecorationSetBtn.isSelected()) {
						textDecorationBlinkBtn.setEnabled(true);
						textDecorationLineThroughBtn.setEnabled(true);
						textDecorationOverlineBtn.setEnabled(true);
						textDecorationUnderlineBtn.setEnabled(true);
					}
				}
			}
		});
		textDecorationSetBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textDecorationBlinkBtn);
				enabledSetting(e, textDecorationLineThroughBtn);
				enabledSetting(e, textDecorationOverlineBtn);
				enabledSetting(e, textDecorationUnderlineBtn);
			}
		});
		textWhiteSpaceBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, textWhiteSpaceBox);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (textIndentBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("text-indent: ");
			if (textIndentInheritBtn.isSelected()) {
				buff.append("inherit");
			} else {
				buff.append(textIndentLengthField.getText());
				buff.append(textIndentLengthBox.getSelectedItem());
			}
			buff.append(";\n");
		}
		if (textAlignBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("text-align: ");
			buff.append(textAlignBox.getSelectedItem());
			buff.append(";\n");
		}
		if (textDecorationBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("text-decoration:");
			if (textDecorationNoneBtn.isSelected()) {
				buff.append(" none");
			} else if (textDecorationInheritBtn.isSelected()) {
				buff.append(" inherit");
			} else {
				if (textDecorationUnderlineBtn.isSelected()) {
					buff.append(" underline");
				}
				if (textDecorationOverlineBtn.isSelected()) {
					buff.append(" overline");
				}
				if (textDecorationLineThroughBtn.isSelected()) {
					buff.append(" line-through");
				}
				if (textDecorationBlinkBtn.isSelected()) {
					buff.append(" blink");
				}
			}
			buff.append(";\n");
		}
		if (textWhiteSpaceBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("white-space: ");
			buff.append(textWhiteSpaceBox.getSelectedItem());
			buff.append(";\n");
		}

		return buff.toString();
	}
}