//
//  CSSSelectorDialog.java
//  JHime
//
//  Created by HIROTAKA_YAMASHITA on 08/04/23.
//  Copyright 2008 HIROTAKA_YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSSelectorDialog extends HTMLDialog {
	private JCheckBox combiBtn			   = new JCheckBox("セレクタ結合子");
	private JCheckBox typeBtn			   = new JCheckBox("タイプセレクタ");
	private JCheckBox classBtn			   = new JCheckBox("クラスセレクタ");
	private JCheckBox idBtn				   = new JCheckBox("IDセレクタ");
	private JCheckBox attrBtn			   = new JCheckBox("属性セレクタ");
	private JCheckBox linkPseudoBtn		   = new JCheckBox("link疑似クラス");
	private JCheckBox visitedPseudoBtn	   = new JCheckBox("visited疑似クラス");
	private JCheckBox activePseudoBtn	   = new JCheckBox("active疑似クラス");
	private JCheckBox hoverPseudoBtn	   = new JCheckBox("hover疑似クラス");
	private JCheckBox focusPseudoBtn	   = new JCheckBox("focus疑似クラス");
	private JCheckBox firstChildPseudoBtn  = new JCheckBox("first-child疑似クラス");
	private JCheckBox firstLinePseudoBtn   = new JCheckBox("first-line疑似要素");
	private JCheckBox firstLetterPseudoBtn = new JCheckBox("first-letter疑似要素");
	private JCheckBox beforePseudoBtn	   = new JCheckBox("before疑似要素");
	private JCheckBox afterPseudoBtn	   = new JCheckBox("after疑似要素");

	private JRadioButton combiGroupBtn = new JRadioButton("グループ(,)", true);
	private JRadioButton combiDescendantBtn = new JRadioButton("子孫( )");
	private JRadioButton combiChildBtn = new JRadioButton("子(>)");
	private JRadioButton combiAdjacentBtn = new JRadioButton("隣接(+)");
	private String[] type_str = {
		"*",
		"a", "abbr", "acronym", "blockquote", "body", "br", "caption", "cite", "code",
		"dd", "del", "dfn", "div", "dl", "dt", "em", "fieldset", "form",
		"h1", "h2", "h3", "h4", "h5", "h6", "hr", "img", "input", "ins", "kbd",
		"label", "legend", "li", "noscript", "object", "ol", "option", "p", "pre",
		"q", "samp", "script", "select", "span", "strong", "sub", "sup",
		"table", "td", "th", "tr", "ul", "var", 
	};
	private JComboBox typeBox			= new JComboBox(type_str);
	private JTextField classField		= new JTextField(10);
	private JTextField idField			= new JTextField(10);
	private JLabel attrNameLabel		= new JLabel("属性名", JLabel.RIGHT);
	private JTextField attrNameField	= new JTextField(20);
	private JCheckBox attrValueBtn		= new JCheckBox("属性値");
	private JTextField attrValueField	= new JTextField(20);
	private JRadioButton attrEqualBtn	= new JRadioButton("=", true);
	private JRadioButton attrSpaceBtn	= new JRadioButton("~=");
	private JRadioButton attrHyphenBtn	= new JRadioButton("|=");
	

	public CSSSelectorDialog (TextView view) {
		super(view);
		setDialog(view, "セレクタ設定", 100, 100);
	}


	private JPanel createSelectorPanel() {
		ButtonGroup combiGroup = new ButtonGroup();
		combiGroup.add(combiGroupBtn);
		combiGroup.add(combiDescendantBtn);
		combiGroup.add(combiChildBtn);
		combiGroup.add(combiAdjacentBtn);
		JPanel combiPane = new JPanel();
		combiPane.setBorder(LineBorder.createGrayLineBorder());
		combiPane.add(combiGroupBtn);
		combiPane.add(combiDescendantBtn);
		combiPane.add(combiChildBtn);
		combiPane.add(combiAdjacentBtn);
		combiGroupBtn.setEnabled(false);
		combiDescendantBtn.setEnabled(false);
		combiChildBtn.setEnabled(false);
		combiAdjacentBtn.setEnabled(false);

		ButtonGroup attrGroup = new ButtonGroup();
		attrGroup.add(attrEqualBtn);
		attrGroup.add(attrSpaceBtn);
		attrGroup.add(attrHyphenBtn);
		JPanel attrPane = new JPanel();
		attrPane.setBorder(LineBorder.createGrayLineBorder());
		attrPane.add(attrEqualBtn);
		attrPane.add(attrSpaceBtn);
		attrPane.add(attrHyphenBtn);
		attrEqualBtn.setEnabled(false);
		attrSpaceBtn.setEnabled(false);
		attrHyphenBtn.setEnabled(false);

		typeBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, combiBtn,				0, 0, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, combiPane,			1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, typeBtn,				0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, typeBox,				1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, classBtn,				0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, classField,			1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, idBtn,				0, 3, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, idField,				1, 3, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, attrBtn,				0, 4, true);
		gridLayoutComponent(pane, layout, gc, attrNameLabel,		1, 4, false);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, attrNameField,		2, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, attrValueBtn,			1, 5, false);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, attrValueField,		2, 5, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, attrPane,				2, 6, false);

		combiBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, combiGroupBtn);
				enabledSetting(e, combiDescendantBtn);
				enabledSetting(e, combiChildBtn);
				enabledSetting(e, combiAdjacentBtn);
			}
		});
		typeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, typeBox);
			}
		});
		classBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, classField);
			}
		});
		idBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, idField);
			}
		});
		attrBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					attrEqualBtn.setEnabled(false);
					attrSpaceBtn.setEnabled(false);
					attrHyphenBtn.setEnabled(false);
					attrValueField.setEnabled(false);
				} else if (attrValueBtn.isSelected()) {
					attrEqualBtn.setEnabled(true);
					attrSpaceBtn.setEnabled(true);
					attrHyphenBtn.setEnabled(true);
					attrValueField.setEnabled(true);
				}
				enabledSetting(e, attrValueBtn);
				enabledSetting(e, attrNameLabel);
				enabledSetting(e, attrNameField);
			}
		});
		attrValueBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, attrEqualBtn);
				enabledSetting(e, attrSpaceBtn);
				enabledSetting(e, attrHyphenBtn);
				enabledSetting(e, attrValueField);
			}
		});

		return pane;
	}

	private JPanel createPseudoPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(8,5,8,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, linkPseudoBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, visitedPseudoBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, activePseudoBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, hoverPseudoBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, focusPseudoBtn,		0, 5, true);
		gridLayoutComponent(pane, layout, gc, firstChildPseudoBtn,	0, 6, true);

		return pane;
	}

	private JPanel createPseudoElementPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(15,5,15,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, firstLinePseudoBtn,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, firstLetterPseudoBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, beforePseudoBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, afterPseudoBtn,		0, 4, true);

		return pane;
	}

	protected JPanel createHTMLDocumentPanel() {
		JPanel pane = new JPanel();
		JTabbedPane tabPane = new JTabbedPane();
		tabPane.add("セレクタ", this.createSelectorPanel());
		tabPane.add("疑似クラス", this.createPseudoPanel());
		tabPane.add("疑似要素", this.createPseudoElementPanel());
		pane.add(tabPane);

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (combiBtn.isSelected()) {
			if (combiGroupBtn.isSelected()) {
				buff.append(",");
			} else if (combiDescendantBtn.isSelected()) {
				buff.append(" ");
			} else if (combiChildBtn.isSelected()) {
				buff.append(">");
			} else if (combiAdjacentBtn.isSelected()) {
				buff.append("+");
			}
		}
		if (typeBtn.isSelected()) {
			buff.append((String)typeBox.getSelectedItem());
		}
		if (classBtn.isSelected()) {
			buff.append("." + classField.getText());
		}
		if (idBtn.isSelected()) {
			buff.append("#" + idField.getText());
		}
		if (attrBtn.isSelected()) {
			buff.append("[" + attrNameField.getText());
			if (attrValueBtn.isSelected()) {
				if (attrEqualBtn.isSelected()) {
					buff.append("=");
				} else if (attrSpaceBtn.isSelected()) {
					buff.append("~=");
				} else if (attrHyphenBtn.isSelected()) {
					buff.append("|=");
				}
				buff.append("\"" + attrValueField.getText() + "\"");
			}
			buff.append("]");
		}
		if (linkPseudoBtn.isSelected()) {
			buff.append(":link");
		}
		if (visitedPseudoBtn.isSelected()) {
			buff.append(":visited");
		}
		if (activePseudoBtn.isSelected()) {
			buff.append(":active");
		}
		if (hoverPseudoBtn.isSelected()) {
			buff.append(":hover");
		}
		if (focusPseudoBtn.isSelected()) {
			buff.append(":focus");
		}
		if (firstChildPseudoBtn.isSelected()) {
			buff.append(":first-child");
		}
		if (firstLinePseudoBtn.isSelected()) {
			buff.append(":first-line");
		}
		if (firstLetterPseudoBtn.isSelected()) {
			buff.append(":first-letter");
		}
		if (beforePseudoBtn.isSelected()) {
			buff.append(":before");
		}
		if (afterPseudoBtn.isSelected()) {
			buff.append(":after");
		}

		return buff.toString();
	}
}