//
//  CSSPositionDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/26.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSPositionDialog extends HTMLDialog {
	private JLabel positionLabel = new JLabel("配置方法");
	private String[] position_str = {
		"static", "relative", "absolute", "fixed", "inherit",
	};
	private JComboBox positionBox = new JComboBox(position_str);


	public CSSPositionDialog (TextView view) {
		super(view);
		setDialog(view, "positionプロパティ", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, positionLabel,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, positionBox,	1, 0, true);

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
			buff.append("\t");
		}
		buff.append("position: ");
		buff.append(positionBox.getSelectedItem());
		buff.append(";\n");

		return buff.toString();
	}
}