//
//  CSSPaddingDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/25.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSPaddingDialog extends HTMLDialog {

	class PaddingLength {
		private JRadioButton lengthBtn  = new JRadioButton("長さ・%値", true);
		private JRadioButton inheritBtn	= new JRadioButton("inherit");

		private JTextField lengthField = new JTextField(10);
		private String[] length_str = {
			"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
		};
		private JComboBox lengthBox		= new JComboBox(length_str);

		JPanel getLengthPanel() {
			ButtonGroup btnGroup = new ButtonGroup();
			btnGroup.add(lengthBtn);
			btnGroup.add(inheritBtn);

			GridBagLayout layout = new GridBagLayout();
			GridBagConstraints gc = new GridBagConstraints();
			JPanel pane = new JPanel(layout);

			gc.fill = GridBagConstraints.HORIZONTAL;
			gc.insets = new Insets(5,5,5,5);
			gc.gridwidth = 1;
			gc.gridheight = 1;

			gridLayoutComponent(pane, layout, gc, lengthBtn,	0, 0, true);
			gridLayoutComponent(pane, layout, gc, lengthField,	1, 0, true);
			gridLayoutComponent(pane, layout, gc, lengthBox,	2, 0, true);
			gridLayoutComponent(pane, layout, gc, inheritBtn,	3, 0, true);

			lengthBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, lengthBox);
					enabledSetting(e, lengthField);
				}
			});

			return pane;
		}

		boolean isLengthButton() {
			return lengthBtn.isSelected();
		}
		boolean isInheritButton() {
			return inheritBtn.isSelected();
		}
		String getLengthField() {
			return lengthField.getText();
		}
		String getLengthBox() {
			return (String)lengthBox.getSelectedItem();
		}
		void setAllEnabled(boolean flag) {
			lengthBtn.setEnabled(flag);
			lengthField.setEnabled(flag);
			lengthBox.setEnabled(flag);
			inheritBtn.setEnabled(flag);
		}
		void setButtonEnabled(boolean flag) {
			lengthBtn.setEnabled(flag);
			inheritBtn.setEnabled(flag);
		}
		void setFieldEnabled(boolean flag) {
			lengthField.setEnabled(flag);
			lengthBox.setEnabled(flag);
		}
	}


	private JCheckBox paddingTopBtn = new JCheckBox("padding-top");
	private JCheckBox paddingRightBtn = new JCheckBox("padding-right");
	private JCheckBox paddingBottomBtn = new JCheckBox("padding-bottom");
	private JCheckBox paddingLeftBtn = new JCheckBox("padding-left");

	private PaddingLength paddingTop    = new PaddingLength();
	private PaddingLength paddingBottom = new PaddingLength();
	private PaddingLength paddingRight  = new PaddingLength();
	private PaddingLength paddingLeft	  = new PaddingLength();


	private JCheckBox fontFamilyBtn = new JCheckBox("font-family");
	private JCheckBox fontStyleBtn = new JCheckBox("font-style");
	private JCheckBox fontWeightBtn = new JCheckBox("font-weight");
	private JCheckBox fontSizeBtn = new JCheckBox("font-size");

	private JCheckBox fontFamilyBoxBtn1 = new JCheckBox();
	private JCheckBox fontFamilyBoxBtn2 = new JCheckBox();
	private String[] fontfamily_str = {
		"serif", "sans-serif", "cursive", "fantasy", "monospace", "inherit"
	};
	private JTextField fontFamilyField1 = new JTextField(10);
	private JTextField fontFamilyField2 = new JTextField(10);
	private JComboBox fontFamilyBox = new JComboBox(fontfamily_str);

	private String[] fontstyle_str = {
		"normal", "italic", "oblique", "inherit"
	};
	private JComboBox fontStyleBox = new JComboBox(fontstyle_str);

	private String[] fontweight_str = {
		"normal", "bold", "bolder", "lighter", "100", "200", "300", "400",
		"500", "600", "700", "800", "900", "inherit"
	};
	private JComboBox fontWeightBox = new JComboBox(fontweight_str);

	private JRadioButton fontSizeKeywordBtn	  = new JRadioButton("キーワード", true);
	private JRadioButton fontSizeLengthBtn	  = new JRadioButton("長さ・%値");
	private String[] fontsize_str = {
		"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large",
		"larger", "smaller", "inherit"
	};
	private JComboBox fontSizeKeywordBox = new JComboBox(fontsize_str);
	private JTextField fontSizeLengthField = new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox fontSizeLengthBox		= new JComboBox(length_str);

	private boolean setFlag;

	public CSSPaddingDialog (TextView view, boolean flag) {
		super(view);

		String title;
		if (flag) {
			title = "パディング一括設定";
		} else {
			title = "パディング個別設定";
		}
		setDialog(view, title, 100, 100);
		setFlag = flag;
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, paddingTopBtn,						0, 0, true);
		gridLayoutComponent(pane, layout, gc, paddingTop.getLengthPanel(),		1, 0, true);
		gridLayoutComponent(pane, layout, gc, paddingRightBtn,					0, 1, true);
		gridLayoutComponent(pane, layout, gc, paddingRight.getLengthPanel(),		1, 1, true);
		gridLayoutComponent(pane, layout, gc, paddingBottomBtn,					0, 2, true);
		gridLayoutComponent(pane, layout, gc, paddingBottom.getLengthPanel(),	1, 2, true);
		gridLayoutComponent(pane, layout, gc, paddingLeftBtn,					0, 3, true);
		gridLayoutComponent(pane, layout, gc, paddingLeft.getLengthPanel(),		1, 3, true);

		paddingTop.setAllEnabled(false);
		paddingRight.setAllEnabled(false);
		paddingBottom.setAllEnabled(false);
		paddingLeft.setAllEnabled(false);

		paddingTopBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					paddingTop.setAllEnabled(false);
				} else {
					paddingTop.setButtonEnabled(true);
					if (paddingTop.isLengthButton()) {
						paddingTop.setFieldEnabled(true);
					}
				}
			}
		});
		paddingRightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					paddingRight.setAllEnabled(false);
				} else {
					paddingRight.setButtonEnabled(true);
					if (paddingRight.isLengthButton()) {
						paddingRight.setFieldEnabled(true);
					}
				}
			}
		});
		paddingBottomBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					paddingBottom.setAllEnabled(false);
				} else {
					paddingBottom.setButtonEnabled(true);
					if (paddingBottom.isLengthButton()) {
						paddingBottom.setFieldEnabled(true);
					}
				}
			}
		});
		paddingLeftBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					paddingLeft.setAllEnabled(false);
				} else {
					paddingLeft.setButtonEnabled(true);
					if (paddingLeft.isLengthButton()) {
						paddingLeft.setFieldEnabled(true);
					}
				}
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (setFlag) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("padding:");
		}
		if (paddingTopBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("padding-top:");
			}
			if (paddingTop.isLengthButton()) {
				buff.append(" " + paddingTop.getLengthField());
				buff.append(paddingTop.getLengthBox());
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (paddingRightBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("padding-right:");
			}
			if (paddingRight.isLengthButton()) {
				buff.append(" " + paddingRight.getLengthField());
				buff.append(paddingRight.getLengthBox());
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (paddingBottomBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("padding-bottom:");
			}
			if (paddingBottom.isLengthButton()) {
				buff.append(" " + paddingBottom.getLengthField());
				buff.append(paddingBottom.getLengthBox());
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (paddingLeftBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("padding-left:");
			}
			if (paddingLeft.isLengthButton()) {
				buff.append(" " + paddingLeft.getLengthField());
				buff.append(paddingLeft.getLengthBox());
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (setFlag) {
			buff.append(";\n");
		}

		return buff.toString();
	}
}