//
//  CSSListDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/26.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSListDialog extends HTMLDialog {
	private JCheckBox styleBtn	  = new JCheckBox("マーカー種類");
	private JCheckBox imageBtn	  = new JCheckBox("マーカー画像");
	private JCheckBox positionBtn = new JCheckBox("マーカー位置");

	private String[] style_str = {
		"disc", "circle", "square", "decimal", "decimal-leading-zero",
		"lower-roman", "upper-roman", "lower-greek", "lower-latin", "upper-latin",
		"armenian", "georgian", "lower-alpha", "upper-alpha", "none", "inherit",
	};
	private JComboBox styleBox = new JComboBox(style_str);

	private JRadioButton imageUriBtn	 = new JRadioButton("URI", true);
	private JRadioButton imageNoneBtn	 = new JRadioButton("none");
	private JRadioButton imageInheritBtn = new JRadioButton("inherit");
	private JTextField imageUriField = new JTextField(30);
	private JButton imageUriLinkBtn = new JButton("参照");

	private String[] position_str = {
		"inside", "outside", "inherit",
	};
	private JComboBox positionBox = new JComboBox(position_str);

	private boolean listFlag;

	public CSSListDialog (TextView view, boolean flag) {
		super(view);
		listFlag = flag;
		String title;
		if (listFlag) {
			title = "listプロパティ";
		} else {
			title = "リスト個別設定";
		}
		setDialog(view, title, 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(imageUriBtn);
		btnGroup.add(imageNoneBtn);
		btnGroup.add(imageInheritBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, styleBtn,			0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, styleBox,			1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, imageBtn,			0, 1, true);
		gridLayoutComponent(pane, layout, gc, imageUriBtn,		1, 1, false);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, imageUriField,	2, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, imageUriLinkBtn,	5, 1, false);
		gridLayoutComponent(pane, layout, gc, imageNoneBtn,		1, 2, false);
		gridLayoutComponent(pane, layout, gc, imageInheritBtn,	1, 3, false);
		gridLayoutComponent(pane, layout, gc, positionBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, positionBox,		1, 4, false);

		styleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, styleBox);
			}
		});
		imageBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, imageInheritBtn);
				enabledSetting(e, imageNoneBtn);
				enabledSetting(e, imageUriBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					imageUriField.setEnabled(false);
					imageUriLinkBtn.setEnabled(false);
				} else if (imageUriBtn.isSelected()) {
					imageUriLinkBtn.setEnabled(true);
					imageUriField.setEnabled(true);
				}
			}
		});
		imageUriBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, imageUriLinkBtn);
				enabledSetting(e, imageUriField);
			}
		});
		imageUriLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(imageUriField, filter);
			}
		});
		positionBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionBox);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (listFlag && (styleBtn.isSelected() | imageBtn.isSelected() | positionBtn.isSelected())) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("list:");
		}
		if (styleBtn.isSelected()) {
			if (!listFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("list-style-type:");
			}
			buff.append(" " + styleBox.getSelectedItem());
			if (!listFlag) {
				buff.append(";\n");
			}
		}
		if (imageBtn.isSelected()) {
			if (!listFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("list-style-image:");
			}
			if (imageUriBtn.isSelected()) {
				buff.append(" url(" + imageUriField.getText() + ")");
			} else if (imageNoneBtn.isSelected()) {
				buff.append(" none");
			} else {
				buff.append(" inherit");
			}
			if (!listFlag) {
				buff.append(";\n");
			}
		}
		if (positionBtn.isSelected()) {
			if (!listFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("list-style-position:");
			}
			buff.append(" " + positionBox.getSelectedItem());
			if (!listFlag) {
				buff.append(";\n");
			}
		}
		if (listFlag && (styleBtn.isSelected() | imageBtn.isSelected() | positionBtn.isSelected())) {
			buff.append(";\n");
		}

		return buff.toString();
	}
}