//
//  CSSFontDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/25.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSFontDialog extends HTMLDialog {
	private JCheckBox fontFamilyBtn = new JCheckBox("font-family");
	private JCheckBox fontStyleBtn = new JCheckBox("font-style");
	private JCheckBox fontWeightBtn = new JCheckBox("font-weight");
	private JCheckBox fontSizeBtn = new JCheckBox("font-size");

	private JCheckBox fontFamilyBoxBtn1 = new JCheckBox();
	private JCheckBox fontFamilyBoxBtn2 = new JCheckBox();
	private String[] fontfamily_str = {
		"serif", "sans-serif", "cursive", "fantasy", "monospace", "inherit"
	};
	private JTextField fontFamilyField1 = new JTextField(10);
	private JTextField fontFamilyField2 = new JTextField(10);
	private JComboBox fontFamilyBox = new JComboBox(fontfamily_str);

	private String[] fontstyle_str = {
		"normal", "italic", "oblique", "inherit"
	};
	private JComboBox fontStyleBox = new JComboBox(fontstyle_str);

	private String[] fontweight_str = {
		"normal", "bold", "bolder", "lighter", "100", "200", "300", "400",
		"500", "600", "700", "800", "900", "inherit"
	};
	private JComboBox fontWeightBox = new JComboBox(fontweight_str);

	private JRadioButton fontSizeKeywordBtn	  = new JRadioButton("キーワード", true);
	private JRadioButton fontSizeLengthBtn	  = new JRadioButton("長さ・%値");
	private String[] fontsize_str = {
		"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large",
		"larger", "smaller", "inherit"
	};
	private JComboBox fontSizeKeywordBox = new JComboBox(fontsize_str);
	private JTextField fontSizeLengthField = new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox fontSizeLengthBox		= new JComboBox(length_str);

	private boolean setFlag;

	public CSSFontDialog (TextView view, boolean flag) {
		super(view);

		String title;
		if (flag) {
			title = "フォント一括設定";
		} else {
			title = "フォント個別設定";
		}
		setDialog(view, title, 100, 100);
		setFlag = flag;
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(fontSizeKeywordBtn);
		btnGroup.add(fontSizeLengthBtn);

		JPanel pan = new JPanel();
		pan.add(fontFamilyBoxBtn1);
		pan.add(fontFamilyField1);
		pan.add(fontFamilyBoxBtn2);
		pan.add(fontFamilyField2);
		pan.add(fontFamilyBox);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		fontFamilyBoxBtn1.setEnabled(false);
		fontFamilyBoxBtn2.setEnabled(false);
		fontFamilyField1.setEnabled(false);
		fontFamilyField2.setEnabled(false);
		fontFamilyBox.setEnabled(false);

		gridLayoutComponent(pane, layout, gc, fontFamilyBtn,	0, 0, true);
		gc.gridwidth = 5;
		gridLayoutComponent(pane, layout, gc, pan,	1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, fontStyleBtn,		0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, fontStyleBox,		1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, fontWeightBtn,	0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, fontWeightBox,	1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, fontSizeBtn,			0, 3, true);
		gridLayoutComponent(pane, layout, gc, fontSizeKeywordBtn,	1, 3, false);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, fontSizeKeywordBox,	2, 3, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, fontSizeLengthBtn,	1, 4, false);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, fontSizeLengthField,	2, 4, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, fontSizeLengthBox,	4, 4, false);

		fontFamilyBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontFamilyBox);
				enabledSetting(e, fontFamilyBoxBtn2);
				enabledSetting(e, fontFamilyBoxBtn1);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					fontFamilyField1.setEnabled(false);
					fontFamilyField2.setEnabled(false);
				} else {
					if (fontFamilyBoxBtn1.isSelected()) {
						fontFamilyField1.setEnabled(true);
					}
					if (fontFamilyBoxBtn2.isSelected()) {
						fontFamilyField2.setEnabled(true);
					}
				}
			}
		});
		fontFamilyBoxBtn1.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontFamilyField1);
			}
		});
		fontFamilyBoxBtn2.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontFamilyField2);
			}
		});
		fontStyleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontStyleBox);
			}
		});
		fontWeightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontWeightBox);
			}
		});
		fontSizeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontSizeLengthBtn);
				enabledSetting(e, fontSizeKeywordBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					fontSizeKeywordBox.setEnabled(false);
					fontSizeLengthField.setEnabled(false);
					fontSizeLengthBox.setEnabled(false);
				} else {
					if (fontSizeKeywordBtn.isSelected()) {
						fontSizeKeywordBox.setEnabled(true);
					} else {
						fontSizeLengthField.setEnabled(true);
						fontSizeLengthBox.setEnabled(true);
					}
				}
			}
		});
		fontSizeKeywordBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontSizeKeywordBox);
			}
		});
		fontSizeLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, fontSizeLengthBox);
				enabledSetting(e, fontSizeLengthField);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (setFlag) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("font:");
		}
		if (fontFamilyBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("font-family:");
			}
			if (fontFamilyBoxBtn1.isSelected()) {
				buff.append(" " + fontFamilyField1.getText() + ",");
			}
			if (fontFamilyBoxBtn2.isSelected()) {
				buff.append(" " + fontFamilyField2.getText() + ",");
			}
			 buff.append(" " + fontFamilyBox.getSelectedItem());
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (fontStyleBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("font-style:");
			}
			buff.append(" " + fontStyleBox.getSelectedItem());
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (fontWeightBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("font-weight:");
			}
			buff.append(" " + fontWeightBox.getSelectedItem());
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (fontSizeBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("font-size:");
			}
			if (fontSizeKeywordBtn.isSelected()) {
				buff.append(" " + fontSizeKeywordBox.getSelectedItem());
			} else {
				buff.append(" " + fontSizeLengthField.getText());
				buff.append(fontSizeLengthBox.getSelectedItem());
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (setFlag) {
			buff.append(";\n");
		}

		return buff.toString();
	}
}