//
//  CSSEmptyCellDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/28.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSEmptyCellDialog extends HTMLDialog {
	private JLabel emptyCellLabel   = new JLabel("空セル表示設定");

	private String[] emptycell_str = {
		"show", "hide", "inherit"
	};
	private JComboBox emptyCellBox = new JComboBox(emptycell_str);


	public CSSEmptyCellDialog (TextView view) {
		super(view);
		setDialog(view, "empty-cellsプロパティ", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, emptyCellLabel,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, emptyCellBox,			1, 0, true);


		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
			buff.append("\t");
		}
		buff.append("empty-cells: ");
		buff.append(emptyCellBox.getSelectedItem());
		buff.append(";\n");

		return buff.toString();
	}
}