//
//  CSSColorDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/24.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CSSColorDialog extends HTMLDialog {
	private JLabel typeLabel = new JLabel("形式", JLabel.RIGHT);
	private JRadioButton colorBtn = new JRadioButton("色指定", true);
	private JRadioButton inheritBtn = new JRadioButton("inherit");

	private CSSColorComponent colorItem;

	public CSSColorDialog (TextView view) {
		super(view);
		setDialog(view, "colorプロパティ", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		colorItem = new CSSColorComponent(this);

		ButtonGroup colorGroup = new ButtonGroup();
		colorGroup.add(colorBtn);
		colorGroup.add(inheritBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, colorBtn,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, colorItem.colorBox,		1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, colorItem.colorLinkBtn,	3, 0, true);
		gridLayoutComponent(pane, layout, gc, colorItem.typeBox,	4, 0, true);
		gridLayoutComponent(pane, layout, gc, inheritBtn,	0, 1, true);

		colorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, colorItem.typeBox);
				enabledSetting(e, colorItem.colorLinkBtn);
				enabledSetting(e, colorItem.colorBox);
			}
		});

		return pane;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
			buff.append("\t");
		}
		buff.append("color: ");
		if (colorBtn.isSelected()) {
			buff.append(colorItem.getColor());
		} else {
			buff.append("inherit");
		}
		buff.append(";\n");

		return buff.toString();
	}
}