//
//  CSSColorComponent.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/24.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.Color;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class CSSColorComponent implements ActionListener {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private String[] color_str = {
		"",
		"black", "silver", "gray", "navy", "blue", "aqua", "teal",
		"purple", "fuchsia", "white", "lime", "green", "maroon",
		"red", "orange", "yellow", "olive"
	};
	public JComboBox colorBox = new JComboBox(color_str);
	public JButton colorLinkBtn = new JButton("色参照");

	private String[] type_str = {
		"#rrggbb形式", "#rgb形式", "rgb(r, g, b)形式", "rgb(r%, g%, b%)形式"
	};
	public JComboBox typeBox = new JComboBox(type_str);

	private JDialog dlg;

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSColorComponent(JDialog dlg) {
		colorBox.setEditable(true);
		colorLinkBtn.addActionListener(this);
		this.dlg = dlg;
	}

//================================================================================
//	private メソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	hex形式(#RRGGBB)色コード取得
	//--------------------------------------------------------------------------------
	private String getHexColorCode(Color cl) {
		int i;
		String red	 = "0" + Integer.toHexString(cl.getRed());
		String green = "0" + Integer.toHexString(cl.getGreen());
		String blue  = "0" + Integer.toHexString(cl.getBlue());
		StringBuffer buff = new StringBuffer();

		buff.append("#");
		i = red.length() - 2;
		buff.append(red.substring(i));
		i = green.length() - 2;
		buff.append(green.substring(i));
		i = blue.length() - 2;
		buff.append(blue.substring(i));

		return buff.toString();
	}

	//--------------------------------------------------------------------------------
	//	hex形式(#RGB)色コード取得
	//--------------------------------------------------------------------------------
	private String getRgbColorCode(Color cl) {
		int i;
		String red	 = "0" + Integer.toHexString(cl.getRed());
		String green = "0" + Integer.toHexString(cl.getGreen());
		String blue  = "0" + Integer.toHexString(cl.getBlue());
		StringBuffer buff = new StringBuffer();

		buff.append("#");
		i = red.length() - 2;
		buff.append(red.charAt(i));
		i = green.length() - 2;
		buff.append(green.charAt(i));
		i = blue.length() - 2;
		buff.append(blue.charAt(i));

		return buff.toString();
	}

	//--------------------------------------------------------------------------------
	//	decimal形式(R,G,B)色コード取得
	//--------------------------------------------------------------------------------
	private String getRgb10ColorCode(Color cl) {
		String red	 = Integer.toString(cl.getRed());
		String green = Integer.toString(cl.getGreen());
		String blue  = Integer.toString(cl.getBlue());
		StringBuffer buff = new StringBuffer();

		buff.append("rgb(");
		buff.append(red + ",");
		buff.append(green + ",");
		buff.append(blue + ")");

		return buff.toString();
	}

	//--------------------------------------------------------------------------------
	//	decimal形式(R%,G%,B%)色コード取得
	//--------------------------------------------------------------------------------
	private String getRgbPercentColorCode(Color cl) {
		String red	 = Integer.toString(cl.getRed() * 100 / 255);
		String green = Integer.toString(cl.getGreen() * 100 / 255);
		String blue  = Integer.toString(cl.getBlue() * 100 / 255);
		StringBuffer buff = new StringBuffer();

		buff.append("rgb(");
		buff.append(red + "%,");
		buff.append(green + "%,");
		buff.append(blue + "%)");

		return buff.toString();
	}

	//--------------------------------------------------------------------------------
	//	decimal形式(R,G,B)色コード取得
	//--------------------------------------------------------------------------------
	private String createColorCode(Color cl) {
		String ret = null;

		switch(typeBox.getSelectedIndex()) {
			case 0:	//#rrggbb
				ret = getHexColorCode(cl);
				break;
			case 1:	//#rgb
				ret = getRgbColorCode(cl);
				break;
			case 2:	//rgb(r,g,b)
				ret = getRgb10ColorCode(cl);
				break;
			case 3:	//rgv(r%,g%,b%)
				ret = getRgbPercentColorCode(cl);
				break;
		}

		return ret;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	形式(文字列)取得
	//--------------------------------------------------------------------------------
	public String getColor() {
		return (String)colorBox.getSelectedItem();
	}

	//--------------------------------------------------------------------------------
	//	ACTIONリスナー
	//--------------------------------------------------------------------------------
	public void actionPerformed(ActionEvent e) {
		JColorChooser dlg = new JColorChooser();
		Color ret = dlg.showDialog(this.dlg, "色参照", Color.black);
		if (ret != null) {
			colorBox.setSelectedItem(createColorCode(ret));
		}
	}

}
