//
//  CSSClearDialog.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/26.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSClearDialog extends HTMLDialog {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JLabel clearLabel = new JLabel("制御方法");
	private String[] clear_str = {
		"none", "left", "right", "both", "inherit",		
	};
	private JComboBox clearBox = new JComboBox(clear_str);

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSClearDialog (TextView view) {
		super(view);
		setDialog(view, "clearプロパティ", 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, clearLabel,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, clearBox,	1, 0, true);

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
			buff.append("\t");
		}
		buff.append("clear: ");
		buff.append(clearBox.getSelectedItem());
		buff.append(";\n");

		return buff.toString();
	}
}