//
//  CSSBorderDialog.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/25.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSBorderDialog extends HTMLDialog {
//================================================================================
//	内部クラス
//================================================================================
	//--------------------------------------------------------------------------------
	//	borderパネル生成
	//--------------------------------------------------------------------------------
	class BorderPanel {
		//メンバ変数 (private)
		private JCheckBox widthBtn = new JCheckBox("幅");
		private JCheckBox styleBtn = new JCheckBox("形状");
		private JCheckBox colorBtn = new JCheckBox("色");

		private JRadioButton widthKeywordBtn	= new JRadioButton("キーワード", true);
		private JRadioButton widthLengthBtn		= new JRadioButton("長さ");
		private JRadioButton widthInheritBtn	= new JRadioButton("inherit");
		private String[] widthkeyword_str = {"thin", "medium", "thick"};
		private JComboBox widthKeywordBox		= new JComboBox(widthkeyword_str);
		private JTextField widthLengthField		= new JTextField(5);
		private String[] widthlength_str = {
			"em", "ex", "px", "in", "cm", "mm", "pt", "pc"
		};
		private JComboBox widthLengthBox		= new JComboBox(widthlength_str);

		private String[] style_str = {
			"none", "hidden", "dotted", "dashed", "solid",
			"double", "groove", "ridge", "inset", "outset", "inherit"
		};
		private JComboBox styleBox = new JComboBox(style_str);

		private JRadioButton colorColorBtn		 = new JRadioButton("色指定", true);
		private JRadioButton colorTransparentBtn = new JRadioButton("transparent");
		private JRadioButton colorInheritBtn	 = new JRadioButton("inherit");
		private CSSColorComponent colorItem;

		//コンストラクタ
		BorderPanel(JDialog dlg) {
			colorItem = new CSSColorComponent(dlg);
		}

		//パネル生成
		JPanel getPanel() {
			ButtonGroup btnGroup1 = new ButtonGroup();
			btnGroup1.add(widthKeywordBtn);
			btnGroup1.add(widthLengthBtn);
			btnGroup1.add(widthInheritBtn);
			ButtonGroup btnGroup2 = new ButtonGroup();
			btnGroup2.add(colorColorBtn);
			btnGroup2.add(colorTransparentBtn);
			btnGroup2.add(colorInheritBtn);

			GridBagLayout layout = new GridBagLayout();
			GridBagConstraints gc = new GridBagConstraints();
			JPanel pane = new JPanel(layout);

			gc.fill = GridBagConstraints.HORIZONTAL;
			gc.insets = new Insets(5,5,5,5);
			gc.gridwidth = 1;
			gc.gridheight = 1;

			gridLayoutComponent(pane, layout, gc, widthBtn,					0, 0, true);
			gridLayoutComponent(pane, layout, gc, widthKeywordBtn,			1, 0, false);
			gridLayoutComponent(pane, layout, gc, widthKeywordBox,			2, 0, false);
			gridLayoutComponent(pane, layout, gc, widthLengthBtn,			1, 1, false);
			gridLayoutComponent(pane, layout, gc, widthLengthField,			2, 1, false);
			gridLayoutComponent(pane, layout, gc, widthLengthBox,			3, 1, false);
			gridLayoutComponent(pane, layout, gc, widthInheritBtn,			1, 2, false);
			gridLayoutComponent(pane, layout, gc, styleBtn,					0, 3, true);
			gridLayoutComponent(pane, layout, gc, styleBox,					1, 3, false);
			gridLayoutComponent(pane, layout, gc, colorBtn,					0, 4, true);
			gridLayoutComponent(pane, layout, gc, colorColorBtn,			1, 4, false);
			gridLayoutComponent(pane, layout, gc, colorItem.colorBox,		2, 4, false);
			gridLayoutComponent(pane, layout, gc, colorItem.colorLinkBtn,	3, 4, false);
			gridLayoutComponent(pane, layout, gc, colorItem.typeBox,		4, 4, false);
			gridLayoutComponent(pane, layout, gc, colorTransparentBtn,		1, 5, false);
			gridLayoutComponent(pane, layout, gc, colorInheritBtn,			1, 6, false);

			widthBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, widthInheritBtn);
					enabledSetting(e, widthLengthBtn);
					enabledSetting(e, widthKeywordBtn);
					if (ItemEvent.SELECTED != e.getStateChange()) {
						widthKeywordBox.setEnabled(false);
						widthLengthBox.setEnabled(false);
						widthLengthField.setEnabled(false);
					} else {
						if (widthKeywordBtn.isSelected()) {
							widthKeywordBox.setEnabled(true);
						} else if (widthLengthBtn.isSelected()) {
							widthLengthBox.setEnabled(true);
							widthLengthField.setEnabled(true);
						}
					}
				}
			});
			widthKeywordBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, widthKeywordBox);
				}
			});
			widthLengthBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, widthLengthBox);
					enabledSetting(e, widthLengthField);
				}
			});
			styleBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, styleBox);
				}
			});
			colorBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, colorInheritBtn);
					enabledSetting(e, colorTransparentBtn);
					enabledSetting(e, colorColorBtn);
					if (ItemEvent.SELECTED != e.getStateChange()) {
						colorItem.colorBox.setEnabled(false);
						colorItem.colorLinkBtn.setEnabled(false);
						colorItem.typeBox.setEnabled(false);
					} else {
						if (colorColorBtn.isSelected()) {
							colorItem.colorBox.setEnabled(true);
							colorItem.colorLinkBtn.setEnabled(true);
							colorItem.typeBox.setEnabled(true);
						}
					}
				}
			});
			colorColorBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, colorItem.typeBox);
					enabledSetting(e, colorItem.colorLinkBtn);
					enabledSetting(e, colorItem.colorBox);
				}
			});

			return pane;
		}

		//width指定状態取得
		boolean isWidthButton() {
			return widthBtn.isSelected();
		}

		//style指定状態取得
		boolean isStyleButton() {
			return styleBtn.isSelected();
		}

		//color指定状態取得
		boolean isColorButton() {
			return colorBtn.isSelected();
		}

		//パネル結果文字列取得
		String getWidthString() {
			StringBuffer buff = new StringBuffer();

			if (widthKeywordBtn.isSelected()) {
				buff.append(widthKeywordBox.getSelectedItem());
			} else if (widthLengthBtn.isSelected()) {
				buff.append(widthLengthField.getText());
				buff.append(widthLengthBox.getSelectedItem());
			} else {
				buff.append("inherit");
			}

			return buff.toString();
		}

		//スタイル指定文字列取得
		String getStyleString() {
			StringBuffer buff = new StringBuffer();

			buff.append(styleBox.getSelectedItem());

			return buff.toString();
		}

		//色指定文字列取得
		String getColorString() {
			StringBuffer buff = new StringBuffer();

			if (colorColorBtn.isSelected()) {
				buff.append(colorItem.colorBox.getSelectedItem());
			} else if (colorTransparentBtn.isSelected()) {
				buff.append("transparent");
			} else {
				buff.append("inherit");
			}

			return buff.toString();
		}
	}


//================================================================================
//	メンバ変数 (private)
//================================================================================
	private BorderPanel topPane, bottomPane, rightPane, leftPane;
		
	private boolean setFlag;

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSBorderDialog (TextView view, boolean flag) {
		super(view);

		String title;
		if (flag) {
			title = "四角ボーダー設定";
		} else {
			title = "ボーダー個別設定";
		}
		setFlag = flag;
		setDialog(view, title, 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		JPanel pane = new JPanel();

		if (setFlag) {
			topPane = new BorderPanel(this);
			pane.add(topPane.getPanel());
		} else {
			topPane = new BorderPanel(this);
			rightPane = new BorderPanel(this);
			bottomPane = new BorderPanel(this);
			leftPane = new BorderPanel(this);

			JTabbedPane tabPane = new JTabbedPane();
			tabPane.add("border-top", topPane.getPanel());
			tabPane.add("border-right", rightPane.getPanel());
			tabPane.add("border-bottom", bottomPane.getPanel());
			tabPane.add("border-left", leftPane.getPanel());
			pane.add(tabPane);
		}

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (setFlag) {
			if (topPane.isWidthButton() | topPane.isStyleButton()
						| topPane.isColorButton()) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("border:");
				if (topPane.isWidthButton()) {
					buff.append(" " + topPane.getWidthString());
				}
				if (topPane.isStyleButton()) {
					buff.append(" " + topPane.getStyleString());
				}
				if (topPane.isColorButton()) {
					buff.append(" " + topPane.getColorString());
				}
				buff.append(";\n");
			}
		} else {
			if (topPane.isWidthButton() | topPane.isStyleButton()
						| topPane.isColorButton()) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("border-top:");
				if (topPane.isWidthButton()) {
					buff.append(" " + topPane.getWidthString());
				}
				if (topPane.isStyleButton()) {
					buff.append(" " + topPane.getStyleString());
				}
				if (topPane.isColorButton()) {
					buff.append(" " + topPane.getColorString());
				}
				buff.append(";\n");
			}
			if (rightPane.isWidthButton() | rightPane.isStyleButton()
						| rightPane.isColorButton()) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("border-right:");
				if (rightPane.isWidthButton()) {
					buff.append(" " + rightPane.getWidthString());
				}
				if (rightPane.isStyleButton()) {
					buff.append(" " + rightPane.getStyleString());
				}
				if (rightPane.isColorButton()) {
					buff.append(" " + rightPane.getColorString());
				}
				buff.append(";\n");
			}
			if (bottomPane.isWidthButton() | bottomPane.isStyleButton()
						| bottomPane.isColorButton()) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("border-bottom:");
				if (bottomPane.isWidthButton()) {
					buff.append(" " + bottomPane.getWidthString());
				}
				if (bottomPane.isStyleButton()) {
					buff.append(" " + bottomPane.getStyleString());
				}
				if (bottomPane.isColorButton()) {
					buff.append(" " + bottomPane.getColorString());
				}
				buff.append(";\n");
			}
			if (leftPane.isWidthButton() | leftPane.isStyleButton()
						| leftPane.isColorButton()) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("border-left:");
				if (leftPane.isWidthButton()) {
					buff.append(" " + leftPane.getWidthString());
				}
				if (leftPane.isStyleButton()) {
					buff.append(" " + leftPane.getStyleString());
				}
				if (leftPane.isColorButton()) {
					buff.append(" " + leftPane.getColorString());
				}
				buff.append(";\n");
			}
		}

		return buff.toString();
	}
}