//
//  CSSBackgroundDialog.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/24.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSBackgroundDialog extends HTMLDialog {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JRadioButton colorBtn			  = new JRadioButton("指定なし", true);
	private JRadioButton colorTransparentBtn  = new JRadioButton("transparent");
	private JRadioButton colorColorBtn		  = new JRadioButton("色指定");
	private JRadioButton colorInheritBtn	  = new JRadioButton("inherit");
	private CSSColorComponent colorItem;

	private JRadioButton imageBtn			  = new JRadioButton("指定なし", true);
	private JRadioButton imageNoneBtn		  = new JRadioButton("none");
	private JRadioButton imageUriBtn		  = new JRadioButton("URI");
	private JTextField imageUriField		  = new JTextField(30);
	private JButton imageUriLinkBtn			  = new JButton("参照");
	private JRadioButton imageInheritBtn	  = new JRadioButton("inherit");
	
	private JRadioButton repeatBtn			  = new JRadioButton("指定なし", true);
	private JRadioButton repeatXYBtn		  = new JRadioButton("repeat");
	private JRadioButton repeatXBtn			  = new JRadioButton("repeat-x");
	private JRadioButton repeatYBtn			  = new JRadioButton("repeat-y");
	private JRadioButton repeatNoBtn		  = new JRadioButton("no-repeat");
	private JRadioButton repeatInheritBtn	  = new JRadioButton("inherit");

	private JRadioButton attachmentBtn		  = new JRadioButton("指定なし", true);
	private JRadioButton attachmentScrollBtn  = new JRadioButton("scroll");
	private JRadioButton attachmentFixedBtn   = new JRadioButton("fixed");
	private JRadioButton attachmentInheritBtn = new JRadioButton("inherit");

	private JRadioButton positionBtn				= new JRadioButton("指定なし", true);
	private JRadioButton positionPositionBtn		= new JRadioButton("位置指定");
	private JRadioButton positionInheritBtn			= new JRadioButton("inherit");
	private JLabel positionFirstLabel				= new JLabel("位置(1)", JLabel.RIGHT);
	private JRadioButton positionFirstLengthBtn		= new JRadioButton("長さ・％値", true);
	private JTextField positionFirstLengthField		= new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox positionFirstLengthBox		= new JComboBox(length_str);
	private JRadioButton positionFirstKeywordBtn	= new JRadioButton("キーワード");
	private String[] keyword_str = {
		"top", "right", "bottom", "left", "center"
	};
	private JComboBox positionFirstKeywordBox		= new JComboBox(keyword_str);
	private JCheckBox positionSecondLabel			= new JCheckBox("位置(2)");
	private JRadioButton positionSecondLengthBtn	= new JRadioButton("長さ・％値", true);
	private JTextField positionSecondLengthField	= new JTextField(10);
	private JComboBox positionSecondLengthBox		= new JComboBox(length_str);
	private JRadioButton positionSecondKeywordBtn	= new JRadioButton("キーワード");
	private JComboBox positionSecondKeywordBox		= new JComboBox(keyword_str);

	private boolean setFlag;

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSBackgroundDialog (TextView view, boolean flag) {
		super(view);

		String title;
		if (flag) {
			title = "背景一括設定";
		} else {
			title = "背景個別設定";
		}
		setDialog(view, title, 100, 100);
		setFlag = flag;
	}

//================================================================================
//	privateメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	background-color指定パネル生成
	//--------------------------------------------------------------------------------
	private JPanel createColorPanel() {
		ButtonGroup colorGroup = new ButtonGroup();
		colorGroup.add(colorBtn);
		colorGroup.add(colorTransparentBtn);
		colorGroup.add(colorColorBtn);
		colorGroup.add(colorInheritBtn);
		
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, colorBtn,					0, 0, true);
		gridLayoutComponent(pane, layout, gc, colorTransparentBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, colorColorBtn,			0, 2, true);
		gridLayoutComponent(pane, layout, gc, colorItem.colorBox,		1, 2, false);
		gridLayoutComponent(pane, layout, gc, colorItem.colorLinkBtn,	2, 2, false);
		gridLayoutComponent(pane, layout, gc, colorItem.typeBox,		3, 2, false);
		gridLayoutComponent(pane, layout, gc, colorInheritBtn,			0, 3, true);

		colorColorBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, colorItem.typeBox);
				enabledSetting(e, colorItem.colorLinkBtn);
				enabledSetting(e, colorItem.colorBox);
			}
		});

		return pane;
	}

	//--------------------------------------------------------------------------------
	//	image指定パネル生成
	//--------------------------------------------------------------------------------
	private JPanel createImagePanel() {
		ButtonGroup imageGroup = new ButtonGroup();
		imageGroup.add(imageBtn);
		imageGroup.add(imageNoneBtn);
		imageGroup.add(imageUriBtn);
		imageGroup.add(imageInheritBtn);
		
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, imageBtn,			0, 0, true);
		gridLayoutComponent(pane, layout, gc, imageNoneBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, imageUriBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, imageUriField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, imageUriLinkBtn,	2, 2, false);
		gridLayoutComponent(pane, layout, gc, imageInheritBtn,	0, 3, true);

		imageUriBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, imageUriLinkBtn);
				enabledSetting(e, imageUriField);
			}
		});
		imageUriLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.JPEG_GROUP};
				fileSelect(imageUriField, filter);
			}
		});

		return pane;
	}

	//--------------------------------------------------------------------------------
	//	repeat指定パネル生成
	//--------------------------------------------------------------------------------
	private JPanel createRepeatPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(repeatBtn);
		btnGroup.add(repeatXYBtn);
		btnGroup.add(repeatXBtn);
		btnGroup.add(repeatYBtn);
		btnGroup.add(repeatNoBtn);
		btnGroup.add(repeatInheritBtn);
		
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, repeatBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, repeatXYBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, repeatXBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, repeatYBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, repeatNoBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, repeatInheritBtn,	0, 5, true);

		return pane;
	}

	//--------------------------------------------------------------------------------
	//	attachement指定パネル生成
	//--------------------------------------------------------------------------------
	private JPanel createAttachmentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(attachmentBtn);
		btnGroup.add(attachmentScrollBtn);
		btnGroup.add(attachmentFixedBtn);
		btnGroup.add(attachmentInheritBtn);
		
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, attachmentBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, attachmentScrollBtn,	0, 1, true);
		gridLayoutComponent(pane, layout, gc, attachmentFixedBtn,	0, 2, true);
		gridLayoutComponent(pane, layout, gc, attachmentInheritBtn,	0, 3, true);

		return pane;
	}

	//--------------------------------------------------------------------------------
	//	position指定パネル生成
	//--------------------------------------------------------------------------------
	private JPanel createPositionPanel() {
		ButtonGroup btnGroup1 = new ButtonGroup();
		btnGroup1.add(positionBtn);
		btnGroup1.add(positionPositionBtn);
		btnGroup1.add(positionInheritBtn);
		ButtonGroup btnGroup2 = new ButtonGroup();
		btnGroup2.add(positionFirstLengthBtn);
		btnGroup2.add(positionFirstKeywordBtn);
		ButtonGroup btnGroup3 = new ButtonGroup();
		btnGroup3.add(positionSecondLengthBtn);
		btnGroup3.add(positionSecondKeywordBtn);
		
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, positionBtn,					0, 0, true);
		gridLayoutComponent(pane, layout, gc, positionPositionBtn,			0, 1, true);
		gridLayoutComponent(pane, layout, gc, positionFirstLabel,			1, 1, false);
		gridLayoutComponent(pane, layout, gc, positionFirstLengthBtn,		2, 1, false);
		gridLayoutComponent(pane, layout, gc, positionFirstLengthField,		3, 1, false);
		gridLayoutComponent(pane, layout, gc, positionFirstLengthBox,		4, 1, false);
		gridLayoutComponent(pane, layout, gc, positionFirstKeywordBtn,		2, 2, false);
		gridLayoutComponent(pane, layout, gc, positionFirstKeywordBox,		3, 2, false);
		gridLayoutComponent(pane, layout, gc, positionSecondLabel,			1, 3, false);
		gridLayoutComponent(pane, layout, gc, positionSecondLengthBtn,		2, 3, false);
		gridLayoutComponent(pane, layout, gc, positionSecondLengthField,	3, 3, false);
		gridLayoutComponent(pane, layout, gc, positionSecondLengthBox,		4, 3, false);
		gridLayoutComponent(pane, layout, gc, positionSecondKeywordBtn,		2, 4, false);
		gridLayoutComponent(pane, layout, gc, positionSecondKeywordBox,		3, 4, false);
		gridLayoutComponent(pane, layout, gc, positionInheritBtn,			0, 5, true);

		positionPositionBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionFirstLabel);
				enabledSetting(e, positionFirstLengthBtn);
				enabledSetting(e, positionFirstKeywordBtn);
				enabledSetting(e, positionSecondLabel);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					positionFirstLengthField.setEnabled(false);
					positionFirstLengthBox.setEnabled(false);
					positionFirstKeywordBox.setEnabled(false);
					positionSecondLengthBtn.setEnabled(false);
					positionSecondLengthField.setEnabled(false);
					positionSecondLengthBox.setEnabled(false);
					positionSecondKeywordBtn.setEnabled(false);
					positionSecondKeywordBox.setEnabled(false);

				} else {
					if (positionFirstLengthBtn.isSelected()) {
						positionFirstLengthField.setEnabled(true);
						positionFirstLengthBox.setEnabled(true);
					} else {
						positionFirstKeywordBox.setEnabled(true);
					}
					if (positionSecondLabel.isSelected()) {
						positionSecondLengthBtn.setEnabled(true);
						positionSecondKeywordBtn.setEnabled(true);
						if (positionSecondLengthBtn.isSelected()) {
							positionSecondLengthField.setEnabled(true);
							positionSecondLengthBox.setEnabled(true);
						} else {
							positionSecondKeywordBox.setEnabled(true);
						}
					}
				}
			}
		});
		positionFirstLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionFirstLengthBox);
				enabledSetting(e, positionFirstLengthField);
			}
		});
		positionFirstKeywordBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionFirstKeywordBox);
			}
		});
		positionSecondLabel.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionSecondLengthBtn);
				enabledSetting(e, positionSecondKeywordBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					positionSecondLengthField.setEnabled(false);
					positionSecondLengthBox.setEnabled(false);
					positionSecondKeywordBox.setEnabled(false);
				} else {
					if (positionSecondLengthBtn.isSelected()) {
						positionSecondLengthField.setEnabled(true);
						positionSecondLengthBox.setEnabled(true);
					} else {
						positionSecondKeywordBox.setEnabled(true);
					}
				}
			}
		});
		positionSecondLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionSecondLengthBox);
				enabledSetting(e, positionSecondLengthField);
			}
		});
		positionSecondKeywordBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, positionSecondKeywordBox);
			}
		});

		return pane;
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		colorItem = new CSSColorComponent(this);

		JPanel pane = new JPanel();
		JTabbedPane tabPane = new JTabbedPane();
		tabPane.add("背景色", this.createColorPanel());
		tabPane.add("画像指定", this.createImagePanel());
		tabPane.add("画像繰返し", this.createRepeatPanel());
		tabPane.add("画像固定", this.createAttachmentPanel());
		tabPane.add("画像初期位置", this.createPositionPanel());
		pane.add(tabPane);

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (setFlag) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("background:");
		}
		if (!colorBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("background-color:");
			}
			if (colorTransparentBtn.isSelected()) {
				buff.append(" transparent");
			} else if (colorColorBtn.isSelected()) {
				buff.append(" " + colorItem.getColor());
			} else if (colorInheritBtn.isSelected()) {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}

		if (!imageBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("background-image:");
			}
			if (imageNoneBtn.isSelected()) {
				buff.append(" none");
			} else if (imageUriBtn.isSelected()) {
				buff.append(" url(\"" + imageUriField.getText() + "\")");
			} else if (imageInheritBtn.isSelected()) {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}

		if (!repeatBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("background-repeat:");
			}
			if (repeatXYBtn.isSelected()) {
				buff.append(" repeat");
			} else if (repeatXBtn.isSelected()) {
				buff.append(" repeat-x");
			} else if (repeatYBtn.isSelected()) {
				buff.append(" repeat-y");
			} else if (repeatNoBtn.isSelected()) {
				buff.append(" no-repeat");
			} else if (repeatInheritBtn.isSelected()) {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}

		if (!attachmentBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("background-attachment:");
			}
			if (attachmentScrollBtn.isSelected()) {
				buff.append(" scroll");
			} else if (attachmentFixedBtn.isSelected()) {
				buff.append(" fixed");
			} else if (attachmentInheritBtn.isSelected()) {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}

		if (!positionBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("background-position:");
			}
			if (positionInheritBtn.isSelected()) {
				buff.append(" inherit");
			} else {
				if (positionFirstLengthBtn.isSelected()) {
					buff.append(" " + positionFirstLengthField.getText());
					buff.append(positionFirstLengthBox.getSelectedItem());
				} else {
					buff.append(" " + positionFirstKeywordBox.getSelectedItem());
				}
				if (positionSecondLabel.isSelected()) {
					if (positionSecondLengthBtn.isSelected()) {
						buff.append(" " + positionSecondLengthField.getText());
						buff.append(positionSecondLengthBox.getSelectedItem());
					} else {
						buff.append(" " + positionSecondKeywordBox.getSelectedItem());
					}
				}
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (setFlag) {
			buff.append(";\n");
		}

		return buff.toString();
	}
}