//
//  CSSAtMediaDialog.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/24.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CSSAtMediaDialog extends HTMLDialog {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JLabel mediaLabel = new JLabel("メディア", JLabel.RIGHT);

	private String[] media_str = {
		"all", "screen", "print", "tv", "projection", "handheld", "tty",
		"braille", "embossed", "aural"
	};
	private JComboBox mediaBox = new JComboBox(media_str);

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSAtMediaDialog (TextView view) {
		super(view);
		setDialog(view, "@media設定", 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		mediaBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, mediaLabel,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, mediaBox,		1, 0, true);

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得(開始)
	//--------------------------------------------------------------------------------
	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		buff.append("@media ");
		buff.append((String)mediaBox.getSelectedItem() + " {\n");

		return buff.toString();
	}

	//--------------------------------------------------------------------------------
	//	結果文字列取得(終了)
	//--------------------------------------------------------------------------------
	public String getStringEnd() {
		StringBuffer buff = new StringBuffer();

		buff.append("}\n");

		return buff.toString();
	}
}