//
//  CSSAtImportDialog.java
//  JHime
//
//  Created by HIROTAKA_YAMASHITA on 08/04/24.
//  Copyright 2008 HIROTAKA_YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CSSAtImportDialog extends HTMLDialog {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JLabel urlLabel = new JLabel("url", JLabel.RIGHT);
	private JCheckBox mediaBtn = new JCheckBox("メディア");

	private JTextField urlField = new JTextField(30);
	private JButton urlLinkBtn = new JButton("参照");
	private String[] media_str = {
		"all", "screen", "print", "tv", "projection", "handheld", "tty",
		"braille", "embossed", "aural"
	};
	private JComboBox mediaBox = new JComboBox(media_str);

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSAtImportDialog (TextView view) {
		super(view);
		setDialog(view, "@import設定", 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		mediaBox.setEditable(true);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, urlLabel,		0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, urlField,		1, 0, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, urlLinkBtn,	3, 0, true);
		gridLayoutComponent(pane, layout, gc, mediaBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, mediaBox,		1, 1, false);

		mediaBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mediaBox);
			}
		});
		urlLinkBtn.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				String[] filter = {FileIOFilter.CSS};
				fileSelect(urlField, filter);
			}
		});

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("@import \"" + urlField.getText() + "\"");
		if (mediaBtn.isSelected()) {
			buff.append(" " + (String)mediaBox.getSelectedItem());
		}
		buff.append(";\n");

		return buff.toString();
	}
}