/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtEndOfLineRule.java,v 1.2 2007/09/03 08:59:39 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2007/09/03 08:59:39 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;


import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;

/**
 * ExtEndOfLineRule
 * @since 1.0.0
 */
public class ExtEndOfLineRule extends EndOfLineRule implements IExtRule {
    
    /**
     * Initiate ExtEndOfLineRule.
     * @param start start string.
     * @param token color defined token.
     */
    public ExtEndOfLineRule(String start, IToken token) {
        super(start, token);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#activateColor(jp.sourceforge.jeextension.editor.editors.ColorManager)
     */
    public void activateColor(IColorManager cm) {
        Object obj = super.fToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator) obj).activateColor(cm);
        }
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#getWords()
     */
    public String[] getWords() {
        return new String[] {
            new String(super.fStartSequence),
        };
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#setWords(java.lang.String[])
     */
    public void setWords(String[] words) {
        super.fStartSequence = words[0].toCharArray();
    }
}
