/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;

public class ReflectFactory {
    private Class fClass;
    private String fName;
    private Object fTarget;
    private Class[] fTypes = new Class[0];
    private Object[] fParams = new Object[0];

    public void setTarget(Object target) {
        this.fTarget = target;
    }

    public void setClass(Class clazz) {
        this.fClass = clazz;
    }

    public void setClass(String clazz) {
        this.fClass = this.loadClass(clazz);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setType(String type) {
        this.fTypes = new Class[]{this.loadClass(type)};
    }

    public void setType(String[] type) {
        this.fTypes = new Class[type.length];
        int i = 0;
        while (i < type.length) {
            this.fTypes[i] = this.loadClass(type[i]);
            ++i;
        }
    }

    public void setType(Class[] type) {
        this.fTypes = type;
    }

    public void setType(Class type) {
        this.fTypes = new Class[]{type};
    }

    public void setParam(Object param) {
        this.fParams = new Object[]{param};
    }

    public void setParam(Object[] param) {
        this.fParams = param;
    }

    public Object invoke() {
        Object obj = null;
        try {
            Method m = this.fClass.getDeclaredMethod(this.fName, this.fTypes);
            m.setAccessible(true);
            obj = m.invoke(this.fTarget, this.fParams);
            m.setAccessible(false);
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
        return obj;
    }

    public Object get() {
        Object obj = null;
        try {
            Field f = this.fClass.getDeclaredField(this.fName);
            f.setAccessible(true);
            obj = f.get(this.fTarget);
            f.setAccessible(false);
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
        return obj;
    }

    public void set() {
        try {
            Field f = this.fClass.getDeclaredField(this.fName);
            f.setAccessible(true);
            f.set(this.fTarget, this.fParams);
            f.setAccessible(false);
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
    }

    public Object newInstance() {
        Object obj = null;
        try {
            Constructor c = this.fClass.getDeclaredConstructor(this.fTypes);
            c.setAccessible(true);
            obj = c.newInstance(this.fParams);
            c.setAccessible(false);
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
        return obj;
    }

    private Class loadClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            StyleEditorPlugin.log(e);
        }
        return clazz;
    }
}

