/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.entry;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;

public class DefinedStyleEntry {
    private static final String DEFAULT_EXT = "*";
    private final Map fExtPartitionEntryMap = new LinkedHashMap();
    private final Map fExtFontMap = new LinkedHashMap();

    public void add(IEntry entry, String ext) {
        this.getEntryList(entry, ext).add(entry);
    }

    public void clearAll() {
        this.fExtPartitionEntryMap.clear();
    }

    public IPartitionEntry getPartitionEntry(String partName, String ext, boolean create) {
        PartitionEntryList list = this.getPartitionEntryList(ext, create);
        int i = 0;
        while (i < list.size()) {
            IPartitionEntry entry = list.getPartitionEntry(i);
            if (entry.getName().equals(partName)) {
                return entry;
            }
            ++i;
        }
        if (!this.fExtPartitionEntryMap.containsKey(ext)) {
            return this.getPartitionEntry(partName, DEFAULT_EXT, create);
        }
        return new PartitionEntry();
    }

    public Map getPartitionEntryMap() {
        return this.fExtPartitionEntryMap;
    }

    public PartitionEntryList getPartitionEntryList(String ext, boolean create) {
        PartitionEntryList list = (PartitionEntryList)this.fExtPartitionEntryMap.get(ext);
        if (list == null && !create) {
            list = (PartitionEntryList)this.fExtPartitionEntryMap.get(DEFAULT_EXT);
        }
        if (list == null && create) {
            this.createNewParitionEntryMap(ext);
            return this.getPartitionEntryList(ext, false);
        }
        return list;
    }

    public void createNewParitionEntryMap(String ext) {
        this.fExtPartitionEntryMap.put(ext, new PartitionEntryList());
    }

    public void remove(IEntry entry, String ext) {
        this.getEntryList(entry, ext).remove(entry);
    }

    public boolean isSizeZero() {
        return this.fExtPartitionEntryMap.size() == 0;
    }

    private List getEntryList(IEntry entry, String ext) {
        if (entry instanceof IPartitionEntry) {
            return this.getPartitionEntryList(ext, false);
        }
        IDependsEntry depdEntry = (IDependsEntry)entry;
        String partName = depdEntry.getDepends().getName();
        IPartitionEntry partEntry = this.getPartitionEntry(partName, ext, false);
        return partEntry.getDependsEntryList();
    }

    public void addFontEntry(FontEntry entry, String ext) {
        this.fExtFontMap.put(ext, entry);
    }

    public FontEntry getFontEntry(String ext) {
        return (FontEntry)this.fExtFontMap.get(ext);
    }

    public Map getFontEntryMap() {
        return this.fExtFontMap;
    }
}

