/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorDamagerRepairer;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SourceViewerConfigurationProxyHandler
implements MethodHandler {
    private final SourceViewerConfiguration fWrapped;
    private String fFileExtension = "*";

    public SourceViewerConfigurationProxyHandler(Object wrapped) {
        this.fWrapped = (SourceViewerConfiguration)wrapped;
    }

    public void setFileExtension(String fileExtension) {
        this.fFileExtension = fileExtension;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod.getName().equals("getConfiguredContentTypes")) {
            return this.getConfiguredContentTypes((ISourceViewer)args[0]);
        }
        if (thisMethod.getName().equals("getPresentationReconciler")) {
            return this.getPresentationReconciler((ISourceViewer)args[0]);
        }
        return proceed.invoke(self, args);
    }

    private String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return StyleEditorTools.getContentTypes(this.fFileExtension);
    }

    private IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)this.fWrapped.getPresentationReconciler(sourceViewer);
        reconciler.setDamager(null, "__java_string");
        reconciler.setRepairer(null, "__java_string");
        reconciler.setDamager(null, "__java_character");
        reconciler.setRepairer(null, "__java_character");
        reconciler.setDamager(null, "__java_singleline_comment");
        reconciler.setRepairer(null, "__java_singleline_comment");
        String ext = this.fFileExtension;
        StyleEditorTools tools = StyleEditorPlugin.getDefault().getEditorTools();
        PartitionEntryList list = StyleEditorTools.getPartitionEntryList(ext, false);
        int i = 0;
        while (i < list.size()) {
            IPartitionEntry pe = list.getPartitionEntry(i);
            String partName = pe.getName();
            RuleBasedScanner scanner = tools.createScanner(partName, ext);
            scanner.setDefaultReturnToken(tools.getDefaultToken(pe));
            StyleEditorDamagerRepairer dr = new StyleEditorDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, partName);
            reconciler.setRepairer((IPresentationRepairer)dr, partName);
            ++i;
        }
        return reconciler;
    }
}

