/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeex.gnu.charset;

import gnu.java.nio.charset.iconv.IconvProvider;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class Shift_JIS
extends Charset {
    Shift_JIS() {
        super("Shift_JIS", new String[]{"sjis", "pck", "shift_jis", "shift-jis", "ms_kanji", "x-sjis", "csShiftJIS"});
    }

    public CharsetDecoder newDecoder() {
        Charset cs = IconvProvider.provider().charsetForName("Shift_JIS");
        return new Decoder((Charset)this, cs.newDecoder());
    }

    public CharsetEncoder newEncoder() {
        Charset cs = IconvProvider.provider().charsetForName("Shift_JIS");
        return new Encoder((Charset)this, cs.newEncoder());
    }

    public boolean contains(Charset cs) {
        return false;
    }

    private static final class Decoder
    extends CharsetDecoder {
        private CharsetDecoder iconvDecoder;

        private Decoder(Charset cs, CharsetDecoder iconvDecoder) {
            super(cs, iconvDecoder.averageCharsPerByte(), iconvDecoder.maxCharsPerByte());
            this.iconvDecoder = iconvDecoder;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int p0 = out.position();
            CoderResult result = this.iconvDecoder.decode(in, out, false);
            if (!result.isError()) {
                int p = out.position();
                int i = p0;
                while (i < p) {
                    char c = out.get(i);
                    if (c == '\u00a5') {
                        out.put(i, '\\');
                    } else if (c == '\u203e') {
                        out.put(i, '~');
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private CharsetEncoder iconvEncoder;

        private Encoder(Charset cs, CharsetEncoder iconvEncoder) {
            super(cs, iconvEncoder.averageBytesPerChar(), iconvEncoder.maxBytesPerChar());
            this.iconvEncoder = iconvEncoder;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CoderResult result = this.iconvEncoder.encode(in, out, false);
            if (result.isError()) {
                int l = result.length();
                int p = in.position();
                int i = 0;
                while (i < l) {
                    char c = in.get(p);
                    if (c == '\\' || c == '~') {
                        try {
                            out.put((byte)c);
                            in.position(++p);
                        }
                        catch (BufferOverflowException _) {
                            return CoderResult.OVERFLOW;
                        }
                    } else {
                        return CoderResult.unmappableForLength(1);
                    }
                    ++i;
                }
                return this.encodeLoop(in, out);
            }
            return result;
        }
    }
}

