/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtTextAttribute.java,v 1.1 2005/01/29 03:25:36 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:25:36 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/**
 * ExtTextAttribute
 */
public class ExtTextAttribute extends TextAttribute
        implements IColorActivator {
    
    /** Background color after activation */
    private Color fBackgroundColor;
    
    /** Background RGB */
    private RGB fBackgroundRGB;
    
    /** Foreground color after activation */
    private Color fForegroundColor;
    
    /** Foreground RGB */
    private RGB fForegroundRGB;

    /**
     * Initiate extended TextAttribute Object using foreground RGB.
     * @param foreground RGB.
     */
    public ExtTextAttribute(RGB foreground) {
        this(foreground, null, SWT.NORMAL);
    }

    /**
     * Initiate extended TextAttribute Object using foreground RGB, background
     * RGB, SWT style.
     * @param foreground    RGB.
     * @param background    RGB.
     * @param style         SWT style.
     */
    public ExtTextAttribute(RGB foreground, RGB background, int style) {
        super(null, null, style);
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
    }
    
    /**
     * Activate Color device.
     * @param cm ColorManager
     */
    public void activateColor(ColorManager cm) {
        if (fForegroundRGB != null) {
            this.fForegroundColor = cm.getColor(this.fForegroundRGB);
        }
        if (fBackgroundRGB != null) {
            this.fBackgroundColor = cm.getColor(this.fBackgroundRGB);
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.TextAttribute#getBackground()
     */
    public Color getBackground() {
        return this.fBackgroundColor;
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.text.TextAttribute#getForeground()
     */
    public Color getForeground() {
        return this.fForegroundColor;
    }
}
