/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtEndOfLineRule.java,v 1.1 2005/01/29 03:25:36 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:25:36 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;

/**
 * ExtEndOfLineRule
 */
public class ExtEndOfLineRule extends EndOfLineRule implements IExtRule {
    
    /**
     * Initiate ExtEndOfLineRule.
     * @param start start string.
     * @param token color defined token.
     */
    public ExtEndOfLineRule(String start, IToken token) {
        super(start, token);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#activateColor(jp.sourceforge.jeextension.editor.editors.ColorManager)
     */
    public void activateColor(ColorManager cm) {
        Object obj = super.fToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator) obj).activateColor(cm);
        }
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#getWords()
     */
    public String[] getWords() {
        return new String[] {
            new String(super.fStartSequence),
        };
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#setWords(java.lang.String[])
     */
    public void setWords(String[] words) {
        super.fStartSequence = words[0].toCharArray();
    }
}
