/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.swt.graphics.RGB;

public class DependsEntry
implements IDependsEntry {
    private String fName = "";
    private IPartitionEntry fPartitionEntry;
    private RGB fRGB = new RGB(0, 0, 0);
    private IExtRule fRule;

    public DependsEntry() {
    }

    public DependsEntry(XMLNode node, String ext) {
        this.fPartitionEntry = EditorTools.getPartitionEntry(node.getParentNode().getAttribute("name"), ext, true);
        this.fName = node.getNodeName();
        this.fRGB.red = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue = Integer.parseInt(node.getAttribute("blue"));
        this.fRule = EditorTools.createExtRule(node, ext);
    }

    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode(this.fName);
        xmlNode.setAttribute("red", String.valueOf(this.fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(this.fRGB.green));
        xmlNode.setAttribute("blue", String.valueOf(this.fRGB.blue));
        if (this.fName.equals("multiLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
            xmlNode.setAttribute("end", this.fRule.getWords()[1]);
        }
        if (this.fName.equals("singleLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
            xmlNode.setAttribute("end", this.fRule.getWords()[1]);
        }
        if (this.fName.equals("endOfLine")) {
            xmlNode.setAttribute("start", this.fRule.getWords()[0]);
        }
        if (this.fName.equals("keyword")) {
            xmlNode.setAttribute("word", this.fRule.getWords()[0]);
            xmlNode.setAttribute("case", this.fRule.getWords()[1]);
        }
        return xmlNode;
    }

    public IPartitionEntry getDepends() {
        return this.fPartitionEntry;
    }

    public String getName() {
        return this.fName;
    }

    public RGB getRGB() {
        return this.fRGB;
    }

    public IExtRule getRule() {
        return this.fRule;
    }

    public String[] getWords() {
        return this.fRule.getWords();
    }

    public void setDepends(IPartitionEntry depends) {
        this.fPartitionEntry = depends;
    }

    public void setRGB(RGB pRGB) {
        this.fRGB = pRGB;
    }

    public void setRule(IExtRule rule) {
        this.fRule = rule;
    }

    public void setWords(String[] words) {
        this.fRule.setWords(words);
    }
}

