package jp.jsuite.snmp;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;

/**
 * SnmpTrapSender 生成ファクトリ
 */
public final class SnmpTrapSenderFactory{
   private SnmpTrapSenderFactory(){}

   /**
    * SnmpTrapSender 生成
    * @param ip SNMP 宛先アドレス
    * @return SnmpTrapSender
    */
   public static SnmpTrapSender create(final String ip){
      Injector injector = Guice.createInjector(new AbstractModule(){
            @Override
            protected void configure(){
               binder().bind(String.class).annotatedWith(SnmpIPaddress.class).toInstance(ip);
            }
         }
      );
      return injector.getInstance(SnmpTrapSender.class);
   }
}
