package jp.jsuite.snmp;

import org.snmp4j.CommandResponder;

import com.google.inject.AbstractModule;

/**
 * SNMPトラップ受信バインド定義.
 * <pre>
 * SnmpTrapReceiver をGoogle guice でインジェクト生成する場合のModule
 * 生成したSnmpTrapReceiver は、受信を終了させるまでインスタンスが有効になるようにすること。
 * </pre>
 */
public class SnmpTrapReceiveModule extends AbstractModule{
   private String recvIP;
   private int threadNum;
   private Class<? extends CommandResponder> cls;

   /**
    * コンストラクタ
    * @param recvIP SNMP受信のアドレス
    * @param threadNum SNMP受信スレッド数
    * @param cls CommandResponder実装クラス
    */
   public SnmpTrapReceiveModule(String recvIP,int threadNum,Class<? extends CommandResponder> cls){
      this.recvIP = recvIP;
      this.threadNum = threadNum;
      this.cls = cls;
   }

   /* (非 Javadoc)
    * @see com.google.inject.AbstractModule#configure()
    */
   @Override
   protected void configure(){
      binder().bind(String.class).annotatedWith(SnmpIPaddress.class).toInstance(this.recvIP);
      binder().bind(int.class).annotatedWith(SnmpRecvThreadnum.class).toInstance(this.threadNum);
      try{
      binder().bind(CommandResponder.class).toInstance(this.cls.newInstance());
      }catch(Exception e){
         throw new RuntimeException(e);
      }
   }

}
