package jp.jsuite.test;

import java.io.IOException;

//import org.snmp4j.CommandResponder;

//import jp.jsuite.snmp.SnmpIPaddress;
//import jp.jsuite.snmp.SnmpRecvThreadnum;
import jp.jsuite.snmp.SnmpTrapReceiveModule;
import jp.jsuite.snmp.SnmpTrapReceiver;

//import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;

/**
 * 受信テスト
 */
public class TestSnmpTrapReceiver{

   static String recvIP = "111.11.111.11";
   static int threadNum = 2;

   public static void main(String[] args) throws IOException{
      /************
      Injector injector2 = Guice.createInjector(new AbstractModule(){
            @Override
            protected void configure(){
               // IP とスレッド数
               binder().bind(String.class).annotatedWith(SnmpIPaddress.class).toInstance(recvIP);
               binder().bind(int.class).annotatedWith(SnmpRecvThreadnum.class).toInstance(threadNum);
               //
               binder().bind(CommandResponder.class).toInstance(new CommandResponderSample());
            }
         }
      );
      /*********/

      Injector injector = Guice.createInjector(new SnmpTrapReceiveModule(recvIP,threadNum,CommandResponderSample.class));
      SnmpTrapReceiver snmpTrapReceiver = injector.getInstance(SnmpTrapReceiver.class);

      snmpTrapReceiver.start();

      try{
      Thread.sleep(60L * 4000L);
      }catch(InterruptedException e){
      }

      snmpTrapReceiver.end();

   }

}
