package jp.jsuite.test;

import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.VariableBinding;

/**
 * CommandResponder サンプル
 */
public class CommandResponderSample implements CommandResponder{
   private Logger logger;

   public CommandResponderSample(){
      this.logger = Logger.getLogger(this.getClass());
   }

   /* 受信プロセス
    * @see org.snmp4j.CommandResponder#processPdu(org.snmp4j.CommandResponderEvent)
    */
   @Override
   public void processPdu(CommandResponderEvent event){
      // 受信した内容を表示する
      StringBuffer sb = new StringBuffer("## recv CommandResponderEvent\n");
      sb.append("\t"+"PDU toString   = "+event.getPDU().toString()+"\n");

      PDUv1 pduv1 = (PDUv1)event.getPDU();

      sb.append("\t"+"PDUv1.toString = "         +pduv1.toString()+"\n");
      sb.append("\t"+"PDUv1.getAgentAddress   = "+pduv1.getAgentAddress()+"\n");
      sb.append("\t"+"PDUv1.getEnterprise()   = "+pduv1.getEnterprise()+"\n");
      sb.append("\t"+"PDUv1.getGenericTrap()  = "+pduv1.getGenericTrap()+"\n");
      sb.append("\t"+"PDUv1.getSpecificTrap() = "+pduv1.getSpecificTrap()+"\n");

      Vector vars = event.getPDU().getVariableBindings();
      for(Iterator<?> it=vars.iterator();it.hasNext();){
         VariableBinding v = (VariableBinding)it.next();

         sb.append("\t"+"---------------------------------------------\n");
         sb.append("\t"+"VariableBinding.getOid()      = "+v.getOid()+"\n");
         sb.append("\t"+"VariableBinding.getVariable() = "+v.getVariable()+"\n");
         sb.append("\t"+"VariableBinding.toString()    = ["+v.toString()+"]"+"\n");
      }
      this.logger.info(sb.toString());
   }

}
