package jp.sourceforge.mailagent;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;


import org.apache.log4j.Logger;

/**
 * [MXbh.
 */
class SendmailThread implements Runnable{
   private MailSource source;       // [M\[X
   private String smtpserver;       // SMTP[T[o
   private boolean smtpauth=false; // SMTPF true=s
   private String smtpuser;         // SMTPF؃[U
   private String smtppasswd;       // SMTPF؃pX[h
   private String smtptimeout;      // SMTP^CAEg(milli seconds)
   private String encode;           // GR[h
  
   /**
    * RXgN^.
    * @param msource [M\[X
    */
   protected SendmailThread(MailSource msource){
      this.precheck(msource);
      this.source = msource;
   }
   /**
    * rlsoT[oZbg
    * @param smtp rlsoT[o
    * @param auth SMTPF
    * @param user SMTPF؃[UisvȂnullj
    * @param passwd SMTPF؃pX[hisvȂnullj
    * @param smtpconntimeout SMTP^CAEg
    */
   protected void setSMTP(String smtp,boolean auth,String smtpuser,String smtppasswd, int smtpconntimeout){
      this.smtpserver = smtp;
      this.smtpauth = auth;
      this.smtpuser = smtpuser;
      this.smtppasswd = smtppasswd;
      this.smtptimeout = Integer.toString(smtpconntimeout * 1000);
   }
   /**
    * GR[hZbg
    * @param encode
    */
   protected void setEncode(String encode){
      this.encode = encode;
   }
   
   /* [MXbhs
    * @see java.lang.Runnable#run()
    */
   public void run(){
      Logger logger = Logger.getLogger("mailagent"); // MO
      ResultMail rtn = this.send();
      logger.debug("mail send status = "+rtn.isStatus()+" subject:"+this.source.getSubject());
      if (rtn.isStatus()==false){
         logger.warn("send failed : subject:"+this.source.getSubject(),rtn.getThrowable());
      }
   }
   
   /**
    * [M.
    * @return 
    */
   protected ResultMail send(){
      ResultMail rtn = new ResultMail();
      // SMTP̐ݒ
      Properties props = System.getProperties();
      props.put("mail.smtp.host",this.smtpserver);
      props.put("mail.smtp.timeout",this.smtptimeout);
      if (this.smtpauth){ 
         // SMTPF؂Kvȏꍇ
         props.put("mail.smtp.auth","true");
      }
      Session session=Session.getDefaultInstance(props,null);
      try{
      MimeMessage mimeMessage = new MimeMessage(session);
      // [쐬
      Map<String,String> map;
      // FROM:
      map = this.source.getFrommap();
      Iterator<String> itr=map.keySet().iterator();
      String fromaddres = itr.next();
      String fromalias = map.get(fromaddres);
      if (fromalias != null && fromalias.length() > 0){
         mimeMessage.setFrom(new InternetAddress(fromaddres,fromalias,this.encode));
         // ԐM悠ΐݒ
         if (this.source.getReplyto() != null){
            mimeMessage.setReplyTo(new Address[]{new InternetAddress(this.source.getReplyto())});  
         }
      }else{
         mimeMessage.setFrom(new InternetAddress(fromaddres));
         // ԐM悠ΐݒ
         if (this.source.getReplyto() != null){
            mimeMessage.setReplyTo(new Address[]{new InternetAddress(this.source.getReplyto())});  
         }
      }
      // TO:
      mimeMessage = setMimeAddres(mimeMessage,this.source.getTomap(),Message.RecipientType.TO);
      // CC:
      mimeMessage = setMimeAddres(mimeMessage,this.source.getCcmap(),Message.RecipientType.CC);
      // BCC:
      mimeMessage = setMimeAddres(mimeMessage,this.source.getBccmap(),Message.RecipientType.BCC);
      // Subject:
      mimeMessage.setSubject(this.source.getSubject(),this.encode);
      // [eiYt^ȂŖ{ZbgقȂj
      List<File> templist = this.source.getTemplist();
      if (templist.size() > 0){
         // Yt
         MimeBodyPart txtmbp = new MimeBodyPart();  
         txtmbp.setText(this.source.getMessage(),this.encode);
         txtmbp.setHeader("Content-Type","text/plain; charset="+this.encode);
         MimeMultipart multipart = new MimeMultipart(); // }`p[gIuWFNg
         multipart.addBodyPart(txtmbp);
         for(Iterator<File> it=templist.iterator();it.hasNext();){
            MimeBodyPart mbp2 = new MimeBodyPart();
            // Ytt@Cw
            FileDataSource fds = new FileDataSource(it.next());
            mbp2.setDataHandler(new DataHandler(fds));
            //mbp2.setFileName(MimeUtility.encodeWord(fds.getName()));
            mbp2.setFileName(MimeUtility.encodeWord(fds.getName(),"Windows-31J","B"));
            // {fBp[gǉ
            multipart.addBodyPart(mbp2);
         }
         // }`p[gIuWFNgbZ[Wɐݒ
         mimeMessage.setContent(multipart);

      }else{
         // YtȂ
         mimeMessage.setText(this.source.getMessage(),this.encode);
         mimeMessage.setHeader("Content-Type","text/plain; charset="+this.encode);
         mimeMessage.setHeader("Content-Transfer-Encoding","quoted-printable");
      }
      
      mimeMessage.setSentDate(new Date());   // Mt
      // M
      if (this.smtpauth){ 
         // SMTPF؂Kvȏꍇ
         Transport transport = session.getTransport("smtp");
         transport.connect(this.smtpserver,this.smtpuser,this.smtppasswd);
         transport.sendMessage(mimeMessage,mimeMessage.getAllRecipients());
      }else{
         Transport.send(mimeMessage);
      }
      }catch(AuthenticationFailedException e){
         rtn.setStatus(false);
         rtn.setErrormsg("AuthenticationFailedException : "+this.smtpserver
                        +":"+this.smtpuser+":"+this.smtppasswd);
      }catch(NoSuchProviderException e){
         rtn.setStatus(false);
         rtn.setErrormsg("NoSuchProviderException : "+this.smtpserver
                        +":"+this.smtpuser+":"+this.smtppasswd);
      }catch(MessagingException e){
         rtn.setStatus(false);
         rtn.setErrormsg("MessagingException : "+e.getMessage(),e);
      }catch(UnsupportedEncodingException e){
         rtn.setStatus(false);
         rtn.setErrormsg("UnsupportedEncodingException : "+this.encode);
      }catch(Exception e){
         rtn.setStatus(false);
         rtn.setErrormsg("other Exception : "+e.getMessage());
      }
      return rtn;
   }
   private MimeMessage setMimeAddres(MimeMessage mime,Map<String,String> map,Message.RecipientType type) 
   throws MessagingException,UnsupportedEncodingException{
      int mapsize = map.size();
      if (mapsize==0){ return mime; }
      MimeMessage rtn = mime;
      String[] addres = new String[mapsize];
      String[] alias  = new String[mapsize];
      int i=0;
      for(Iterator<String> it=map.keySet().iterator();it.hasNext();i++){
         addres[i] = it.next();
         alias[i] = map.get(addres);
      }
      rtn.setRecipients(type,addres[0]);
      if (alias[0] != null && alias[0].length() > 0){
         rtn.setRecipient(type,new InternetAddress(addres[0],alias[0],this.encode));
      }
      for(int k=1;k < addres.length;k++){
         rtn.addRecipients(type,addres[k]);
         if (alias[k] != null && alias[k].length() > 0){
            rtn.addRecipient(type,new InternetAddress(addres[k],alias[k],this.encode));
         }
      }
      return rtn;
   }
   /**
    * O`FbN
    * @param msource
    */
   private void precheck(MailSource msource){
      // M[AhX
      if (msource.getFrommap().isEmpty()){
         throw new UnsupportedOperationException(" mail from Not found");
      }
      // TO:̑݃`FbN
      if (msource.getTomap().isEmpty()){
         throw new UnsupportedOperationException(" mail to Not found");
      }
      // ^Cĝ́AG[
      String chk;
      chk = msource.getSubject();
      if (chk==null || chk.length()==0){
         throw new UnsupportedOperationException(" mail subject Not found");
      }
      // bZ[Ŵ́AG[
      chk = msource.getMessage();
      if (chk==null || chk.length()==0){
         throw new UnsupportedOperationException(" mail mail Body Not found");
      }
   }
}
