/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mailagent;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.sourceforge.mailagent.MailSource;
import jp.sourceforge.mailagent.ResultMail;
import org.apache.log4j.Logger;

class SendmailThread
implements Runnable {
    private MailSource source;
    private String smtpserver;
    private boolean smtpauth = false;
    private String smtpuser;
    private String smtppasswd;
    private String smtptimeout;
    private String encode;

    protected SendmailThread(MailSource msource) {
        this.precheck(msource);
        this.source = msource;
    }

    protected void setSMTP(String smtp, boolean auth, String smtpuser, String smtppasswd, int smtpconntimeout) {
        this.smtpserver = smtp;
        this.smtpauth = auth;
        this.smtpuser = smtpuser;
        this.smtppasswd = smtppasswd;
        this.smtptimeout = Integer.toString(smtpconntimeout * 1000);
    }

    protected void setEncode(String encode) {
        this.encode = encode;
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger((String)"mailagent");
        ResultMail rtn = this.send();
        logger.debug((Object)("mail send status = " + rtn.isStatus() + " subject:" + this.source.getSubject()));
        if (!rtn.isStatus()) {
            logger.warn((Object)("send failed : subject:" + this.source.getSubject()), rtn.getThrowable());
        }
    }

    protected ResultMail send() {
        ResultMail rtn = new ResultMail();
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.smtpserver);
        props.put("mail.smtp.timeout", this.smtptimeout);
        if (this.smtpauth) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            Map<String, String> map = this.source.getFrommap();
            Iterator<String> itr = map.keySet().iterator();
            String fromaddres = itr.next();
            String fromalias = map.get(fromaddres);
            if (fromalias != null && fromalias.length() > 0) {
                mimeMessage.setFrom((Address)new InternetAddress(fromaddres, fromalias, this.encode));
                if (this.source.getReplyto() != null) {
                    mimeMessage.setReplyTo(new Address[]{new InternetAddress(this.source.getReplyto())});
                }
            } else {
                mimeMessage.setFrom((Address)new InternetAddress(fromaddres));
                if (this.source.getReplyto() != null) {
                    mimeMessage.setReplyTo(new Address[]{new InternetAddress(this.source.getReplyto())});
                }
            }
            mimeMessage = this.setMimeAddres(mimeMessage, this.source.getTomap(), Message.RecipientType.TO);
            mimeMessage = this.setMimeAddres(mimeMessage, this.source.getCcmap(), Message.RecipientType.CC);
            mimeMessage = this.setMimeAddres(mimeMessage, this.source.getBccmap(), Message.RecipientType.BCC);
            mimeMessage.setSubject(this.source.getSubject(), this.encode);
            List<File> templist = this.source.getTemplist();
            if (templist.size() > 0) {
                MimeBodyPart txtmbp = new MimeBodyPart();
                txtmbp.setText(this.source.getMessage(), this.encode);
                txtmbp.setHeader("Content-Type", "text/plain; charset=" + this.encode);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)txtmbp);
                Iterator<File> it = templist.iterator();
                while (it.hasNext()) {
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(it.next());
                    mbp2.setDataHandler(new DataHandler((DataSource)fds));
                    mbp2.setFileName(MimeUtility.encodeWord((String)fds.getName(), (String)"Windows-31J", (String)"B"));
                    multipart.addBodyPart((BodyPart)mbp2);
                }
                mimeMessage.setContent((Multipart)multipart);
            } else {
                mimeMessage.setText(this.source.getMessage(), this.encode);
                mimeMessage.setHeader("Content-Type", "text/plain; charset=" + this.encode);
                mimeMessage.setHeader("Content-Transfer-Encoding", "quoted-printable");
            }
            mimeMessage.setSentDate(new Date());
            if (this.smtpauth) {
                Transport transport = session.getTransport("smtp");
                transport.connect(this.smtpserver, this.smtpuser, this.smtppasswd);
                transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            } else {
                Transport.send((Message)mimeMessage);
            }
        }
        catch (AuthenticationFailedException e) {
            rtn.setStatus(false);
            rtn.setErrormsg("AuthenticationFailedException : " + this.smtpserver + ":" + this.smtpuser + ":" + this.smtppasswd);
        }
        catch (NoSuchProviderException e) {
            rtn.setStatus(false);
            rtn.setErrormsg("NoSuchProviderException : " + this.smtpserver + ":" + this.smtpuser + ":" + this.smtppasswd);
        }
        catch (MessagingException e) {
            rtn.setStatus(false);
            rtn.setErrormsg("MessagingException : " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            rtn.setStatus(false);
            rtn.setErrormsg("UnsupportedEncodingException : " + this.encode);
        }
        catch (Exception e) {
            rtn.setStatus(false);
            rtn.setErrormsg("other Exception : " + e.getMessage());
        }
        return rtn;
    }

    private MimeMessage setMimeAddres(MimeMessage mime, Map<String, String> map, Message.RecipientType type) throws MessagingException, UnsupportedEncodingException {
        int mapsize = map.size();
        if (mapsize == 0) {
            return mime;
        }
        MimeMessage rtn = mime;
        String[] addres = new String[mapsize];
        String[] alias = new String[mapsize];
        int i = 0;
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            addres[i] = it.next();
            alias[i] = map.get(addres);
            ++i;
        }
        rtn.setRecipients(type, addres[0]);
        if (alias[0] != null && alias[0].length() > 0) {
            rtn.setRecipient(type, (Address)new InternetAddress(addres[0], alias[0], this.encode));
        }
        for (int k = 1; k < addres.length; ++k) {
            rtn.addRecipients(type, addres[k]);
            if (alias[k] == null || alias[k].length() <= 0) continue;
            rtn.addRecipient(type, (Address)new InternetAddress(addres[k], alias[k], this.encode));
        }
        return rtn;
    }

    private void precheck(MailSource msource) {
        if (msource.getFrommap().isEmpty()) {
            throw new UnsupportedOperationException("\u25c6 mail from Not found");
        }
        if (msource.getTomap().isEmpty()) {
            throw new UnsupportedOperationException("\u25c6 mail to Not found");
        }
        String chk = msource.getSubject();
        if (chk == null || chk.length() == 0) {
            throw new UnsupportedOperationException("\u25c6 mail subject Not found");
        }
        chk = msource.getMessage();
        if (chk == null || chk.length() == 0) {
            throw new UnsupportedOperationException("\u25c6 mail mail Body Not found");
        }
    }
}

